/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.processor;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCache;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheEntry;
import org.wso2.carbon.identity.oauth.cache.AuthorizationGrantCacheKey;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.tokenprocessor.RefreshTokenGrantProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.is.key.manager.tokenpersistence.internal.ServiceReferenceHolder;
import org.wso2.is.key.manager.tokenpersistence.utils.TokenMgtUtil;

public class InMemoryRefreshTokenGrantProcessor
implements RefreshTokenGrantProcessor {
    private static final Log log = LogFactory.getLog(InMemoryRefreshTokenGrantProcessor.class);

    public RefreshTokenValidationDataDO validateRefreshToken(OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        OAuth2AccessTokenReqDTO tokenReq = tokenReqMessageContext.getOauth2AccessTokenReqDTO();
        RefreshTokenValidationDataDO validationBean = OAuth2ServiceComponentHolder.getInstance().getTokenProvider().getVerifiedRefreshToken(tokenReq.getRefreshToken(), tokenReq.getClientId());
        if (validationBean == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid Refresh Token provided for Client with Client Id : %s", tokenReq.getClientId()));
            }
            throw new IdentityOAuth2Exception("Valid refresh token data not found");
        }
        return validationBean;
    }

    public void persistNewToken(OAuthTokenReqMessageContext tokenReqMessageContext, AccessTokenDO accessTokenBean, String userStoreDomain, String clientId) throws IdentityOAuth2Exception {
        OAuth2AccessTokenReqDTO tokenReq = tokenReqMessageContext.getOauth2AccessTokenReqDTO();
        RefreshTokenValidationDataDO oldRefreshToken = (RefreshTokenValidationDataDO)tokenReqMessageContext.getProperty((Object)"previousAccessToken");
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
                log.debug((Object)String.format("Invalidating previous refresh token (hashed): %s", DigestUtils.sha256Hex((String)oldRefreshToken.getRefreshToken())));
            } else {
                log.debug((Object)"Invalidating previous refresh token.");
            }
        }
        if (oldRefreshToken.getProperty((Object)"IS_PERSISTED") != null && ((Boolean)oldRefreshToken.getProperty((Object)"IS_PERSISTED")).booleanValue()) {
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().invalidateAndCreateNewAccessToken(oldRefreshToken.getTokenId(), "INACTIVE", clientId, UUID.randomUUID().toString(), accessTokenBean, userStoreDomain, oldRefreshToken.getGrantType());
        } else {
            long tokenExpirationTime = oldRefreshToken.getIssuedTime().getTime() + oldRefreshToken.getValidityPeriodInMillis();
            Optional<OAuthAppDO> oAuthAppDO = TokenMgtUtil.getOAuthApp(tokenReq.getClientId());
            if (oAuthAppDO.isPresent()) {
                if (this.isRenewRefreshToken(oAuthAppDO.get().getRenewRefreshTokenEnabled())) {
                    ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().addInvalidToken(oldRefreshToken.getRefreshToken(), clientId, tokenExpirationTime);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("OAuth App not found for Client Id: %s", tokenReq.getClientId()));
                }
                throw new IdentityOAuth2Exception("OAuth App not found for Client Id: " + tokenReq.getClientId());
            }
        }
    }

    public AccessTokenDO createAccessTokenBean(OAuthTokenReqMessageContext tokReqMsgCtx, OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean, String tokenType) {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String tokenId = UUID.randomUUID().toString();
        tokReqMsgCtx.addProperty((Object)"usid", (Object)tokenId);
        AccessTokenDO accessTokenDO = new AccessTokenDO();
        accessTokenDO.setConsumerKey(tokenReq.getClientId());
        accessTokenDO.setAuthzUser(tokReqMsgCtx.getAuthorizedUser());
        accessTokenDO.setScope(tokReqMsgCtx.getScope());
        accessTokenDO.setTokenType(tokenType);
        accessTokenDO.setTokenState("ACTIVE");
        accessTokenDO.setTokenId(tokenId);
        accessTokenDO.setGrantType(tokenReq.getGrantType());
        accessTokenDO.setIssuedTime(timestamp);
        accessTokenDO.setTokenBinding(tokReqMsgCtx.getTokenBinding());
        if (OAuth2ServiceComponentHolder.isConsentedTokenColumnEnabled() && validationBean.isConsented()) {
            accessTokenDO.setIsConsentedToken(true);
            tokReqMsgCtx.setConsentedToken(true);
        }
        return accessTokenDO;
    }

    public boolean isLatestRefreshToken(OAuth2AccessTokenReqDTO tokenReq, RefreshTokenValidationDataDO validationBean, String userStoreDomain) {
        return true;
    }

    private boolean isRenewRefreshToken(String renewRefreshToken) {
        if (StringUtils.isNotBlank((String)renewRefreshToken)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading the Oauth application specific renew refresh token value as " + renewRefreshToken + " from the IDN_OIDC_PROPERTY table."));
            }
            return Boolean.parseBoolean(renewRefreshToken);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading the global renew refresh token value from the identity.xml");
        }
        return OAuthServerConfiguration.getInstance().isRefreshTokenRenewalEnabled();
    }

    public void addUserAttributesToCache(AccessTokenDO accessTokenBean, OAuthTokenReqMessageContext msgCtx) {
        RefreshTokenValidationDataDO oldAccessToken = (RefreshTokenValidationDataDO)msgCtx.getProperty((Object)"previousAccessToken");
        if (oldAccessToken.getAccessToken() == null) {
            AuthorizationGrantCacheEntry existingGrantCacheEntry;
            if (oldAccessToken.getTokenId() != null && accessTokenBean.getTokenId() != null && (existingGrantCacheEntry = AuthorizationGrantCache.getInstance().getFromSessionStore(oldAccessToken.getTokenId())) != null) {
                existingGrantCacheEntry.setValidityPeriod(TimeUnit.MILLISECONDS.toNanos(accessTokenBean.getValidityPeriodInMillis()));
                AuthorizationGrantCache.getInstance().clearFromSessionStore(oldAccessToken.getTokenId());
                AuthorizationGrantCache.getInstance().storeToSessionStore(accessTokenBean.getTokenId(), existingGrantCacheEntry);
            }
        } else {
            AuthorizationGrantCacheEntry grantCacheEntry;
            AuthorizationGrantCacheKey oldAuthorizationGrantCacheKey = new AuthorizationGrantCacheKey(oldAccessToken.getAccessToken());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting AuthorizationGrantCacheEntry using access token id: " + accessTokenBean.getTokenId()));
            }
            if ((grantCacheEntry = AuthorizationGrantCache.getInstance().getValueFromCacheByTokenId(oldAuthorizationGrantCacheKey, oldAccessToken.getTokenId())) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Getting user attributes cached against the previous access token with access token id: " + oldAccessToken.getTokenId()));
                }
                AuthorizationGrantCacheKey authorizationGrantCacheKey = new AuthorizationGrantCacheKey(accessTokenBean.getAccessToken());
                if (StringUtils.isNotBlank((String)accessTokenBean.getTokenId())) {
                    grantCacheEntry.setTokenId(accessTokenBean.getTokenId());
                } else {
                    grantCacheEntry.setTokenId(null);
                }
                grantCacheEntry.setValidityPeriod(TimeUnit.MILLISECONDS.toNanos(accessTokenBean.getValidityPeriodInMillis()));
                AuthorizationGrantCache.getInstance().clearCacheEntryByTokenId(oldAuthorizationGrantCacheKey, oldAccessToken.getTokenId());
                AuthorizationGrantCache.getInstance().addToCacheByToken(authorizationGrantCacheKey, grantCacheEntry);
            }
        }
    }
}

