/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.processor;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.tokenprocessor.TokenProvider;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.util.JWTUtils;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.is.key.manager.tokenpersistence.internal.ServiceReferenceHolder;
import org.wso2.is.key.manager.tokenpersistence.utils.OpaqueTokenUtil;
import org.wso2.is.key.manager.tokenpersistence.utils.TokenMgtUtil;

public class InMemoryTokenProvider
implements TokenProvider {
    private static final Log log = LogFactory.getLog(InMemoryTokenProvider.class);

    public AccessTokenDO getVerifiedAccessToken(String token, boolean includeExpired) throws IdentityOAuth2Exception {
        if (!JWTUtils.isJWT((String)token)) {
            return this.getMigratedAccessToken(token, includeExpired);
        }
        SignedJWT signedJWT = TokenMgtUtil.parseJWT(token);
        JWTClaimsSet claimsSet = TokenMgtUtil.getTokenJWTClaims(signedJWT);
        String accessTokenIdentifier = TokenMgtUtil.getTokenIdentifier(claimsSet);
        String consumerKey = (String)claimsSet.getClaim("azp");
        if (claimsSet.getClaim("entity_id") == null) {
            return this.getMigratedAccessToken(accessTokenIdentifier, includeExpired);
        }
        AccessTokenDO validationDataDO = null;
        if (!TokenMgtUtil.isRefreshTokenType(claimsSet)) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)String.format("Validating JWT access token: %s with expiry: %s", includeExpired, DigestUtils.sha256Hex((String)accessTokenIdentifier)));
                } else {
                    log.debug((Object)String.format("Validating JWT access token with expiry: %s", includeExpired));
                }
            }
            AuthenticatedUser authenticatedUser = TokenMgtUtil.getAuthenticatedUser(claimsSet);
            TokenMgtUtil.validateJWTSignature(signedJWT, claimsSet, authenticatedUser);
            boolean isTokenActive = true;
            if (!JWTUtils.checkExpirationTime((Date)claimsSet.getExpirationTime())) {
                if (!includeExpired) {
                    this.handleInvalidAccessTokenError(accessTokenIdentifier);
                }
                isTokenActive = false;
            }
            JWTUtils.checkNotBeforeTime((Date)claimsSet.getNotBeforeTime());
            if (TokenMgtUtil.isTokenRevokedDirectly(accessTokenIdentifier, consumerKey) || TokenMgtUtil.isTokenRevokedIndirectly(claimsSet, authenticatedUser)) {
                if (!includeExpired) {
                    this.handleInvalidAccessTokenError(accessTokenIdentifier);
                }
                return null;
            }
            Optional<AccessTokenDO> accessTokenDO = TokenMgtUtil.getTokenDOFromCache(accessTokenIdentifier);
            if (accessTokenDO.isPresent()) {
                validationDataDO = accessTokenDO.get();
                if (log.isDebugEnabled()) {
                    if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                        log.debug((Object)String.format("Retrieved access token(hashed): %s from OAuthCache to verify.", DigestUtils.sha256Hex((String)validationDataDO.getAccessToken())));
                    } else {
                        log.debug((Object)"Retrieved access token from cache to verify.");
                    }
                }
            } else {
                validationDataDO = new AccessTokenDO();
                validationDataDO.setAccessToken(accessTokenIdentifier);
                validationDataDO.setConsumerKey(consumerKey);
                validationDataDO.setIssuedTime(new Timestamp(claimsSet.getIssueTime().getTime()));
                validationDataDO.setValidityPeriodInMillis(claimsSet.getExpirationTime().getTime() - claimsSet.getIssueTime().getTime());
                Object scopes = claimsSet.getClaim("scope");
                validationDataDO.setScope(TokenMgtUtil.getScopes(scopes));
                validationDataDO.setAuthzUser(authenticatedUser);
                RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
                try {
                    int tenantId = realmService.getTenantManager().getTenantId(authenticatedUser.getTenantDomain());
                    validationDataDO.setTenantID(tenantId);
                }
                catch (UserStoreException e) {
                    throw new IdentityOAuth2Exception("Error while getting tenant ID from tenant domain:" + authenticatedUser.getTenantDomain(), (Throwable)e);
                }
                if (isTokenActive) {
                    validationDataDO.setTokenState("ACTIVE");
                } else {
                    validationDataDO.setTokenState("EXPIRED");
                }
                if (OAuth2ServiceComponentHolder.isConsentedTokenColumnEnabled()) {
                    validationDataDO.setIsConsentedToken(((Boolean)claimsSet.getClaim("is_consented")).booleanValue());
                }
                validationDataDO.setTokenId(TokenMgtUtil.getTokenId(claimsSet));
                TokenMgtUtil.addTokenToCache(accessTokenIdentifier, validationDataDO);
            }
        } else if (!includeExpired) {
            this.handleInvalidAccessTokenError(accessTokenIdentifier);
        }
        return validationDataDO;
    }

    public RefreshTokenValidationDataDO getVerifiedRefreshToken(String refreshToken, String consumerKey) throws IdentityOAuth2Exception {
        RefreshTokenValidationDataDO validationDataDO = null;
        if (!JWTUtils.isJWT((String)refreshToken)) {
            log.debug((Object)"Refresh token is not a JWT. Hence, validating as an migrated opaque token from database.");
            validationDataDO = OpaqueTokenUtil.validateOpaqueRefreshToken(refreshToken, consumerKey);
            OpaqueTokenUtil.validateTokenConsent(validationDataDO);
            return validationDataDO;
        }
        SignedJWT signedJWT = TokenMgtUtil.parseJWT(refreshToken);
        JWTClaimsSet claimsSet = TokenMgtUtil.getTokenJWTClaims(signedJWT);
        String consumerKeyFromToken = (String)claimsSet.getClaim("azp");
        if (!StringUtils.equals((CharSequence)consumerKey, (CharSequence)consumerKeyFromToken)) {
            throw new IdentityOAuth2Exception("Invalid refresh token. Consumer key does not match.");
        }
        if (TokenMgtUtil.isRefreshTokenType(claimsSet)) {
            validationDataDO = this.validateJWTRefreshToken(claimsSet, signedJWT);
        }
        return validationDataDO;
    }

    public AccessTokenDO getVerifiedRefreshToken(String refreshToken) throws IdentityOAuth2Exception {
        RefreshTokenValidationDataDO validationDataDO;
        AccessTokenDO accessTokenDO = null;
        if (!OAuth2Util.isJWT((String)refreshToken)) {
            log.debug((Object)"Refresh token is not a JWT. Hence, finding as an migrated opaque token from database.");
            accessTokenDO = OpaqueTokenUtil.findRefreshToken(refreshToken);
            return accessTokenDO;
        }
        SignedJWT signedJWT = TokenMgtUtil.parseJWT(refreshToken);
        JWTClaimsSet claimsSet = TokenMgtUtil.getTokenJWTClaims(signedJWT);
        if (TokenMgtUtil.isRefreshTokenType(claimsSet) && StringUtils.equals((CharSequence)"ACTIVE", (CharSequence)(validationDataDO = this.validateJWTRefreshToken(claimsSet, signedJWT)).getRefreshTokenState())) {
            accessTokenDO = new AccessTokenDO();
            accessTokenDO.setRefreshTokenValidityPeriodInMillis(validationDataDO.getValidityPeriodInMillis());
            accessTokenDO.setRefreshTokenIssuedTime(validationDataDO.getIssuedTime());
            accessTokenDO.setScope(validationDataDO.getScope());
            accessTokenDO.setAuthzUser(validationDataDO.getAuthorizedUser());
            accessTokenDO.setConsumerKey((String)claimsSet.getClaim("azp"));
            RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
            try {
                int tenantId = realmService.getTenantManager().getTenantId(validationDataDO.getAuthorizedUser().getTenantDomain());
                accessTokenDO.setTenantID(tenantId);
            }
            catch (UserStoreException e) {
                throw new IdentityOAuth2Exception("Error while getting tenant ID from tenant domain:" + validationDataDO.getAuthorizedUser().getTenantDomain(), (Throwable)e);
            }
            accessTokenDO.setTokenId(TokenMgtUtil.getTokenId(claimsSet));
        }
        return accessTokenDO;
    }

    private void handleInvalidAccessTokenError(String tokenIdentifier) {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)String.format("Failed to validate the JWT Access Token %s in memory.", DigestUtils.sha256Hex((String)tokenIdentifier)));
            } else {
                log.debug((Object)"Failed to validate the JWT Access Token in memory.");
            }
        }
        throw new IllegalArgumentException("Invalid Access Token. Access token is not ACTIVE.");
    }

    private RefreshTokenValidationDataDO validateJWTRefreshToken(JWTClaimsSet claimsSet, SignedJWT signedJWT) throws IdentityOAuth2Exception {
        RefreshTokenValidationDataDO validationDataDO = new RefreshTokenValidationDataDO();
        String consumerKey = (String)claimsSet.getClaim("azp");
        String refreshTokenIdentifier = TokenMgtUtil.getTokenIdentifier(claimsSet);
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
                log.debug((Object)String.format("Validating JWT refresh token (hashed): %s", DigestUtils.sha256Hex((String)refreshTokenIdentifier)));
            } else {
                log.debug((Object)"Validating JWT refresh token.");
            }
        }
        AuthenticatedUser authenticatedUser = TokenMgtUtil.getAuthenticatedUser(claimsSet);
        TokenMgtUtil.validateJWTSignature(signedJWT, claimsSet, authenticatedUser);
        if (JWTUtils.checkExpirationTime((Date)claimsSet.getExpirationTime())) {
            if (TokenMgtUtil.isTokenRevokedDirectly(refreshTokenIdentifier, consumerKey) || TokenMgtUtil.isTokenRevokedIndirectly(claimsSet, authenticatedUser)) {
                validationDataDO.setRefreshTokenState("REVOKED");
            } else {
                validationDataDO.setRefreshTokenState("ACTIVE");
            }
        } else {
            validationDataDO.setRefreshTokenState("EXPIRED");
        }
        validationDataDO.setIssuedTime(new Timestamp(claimsSet.getIssueTime().getTime()));
        validationDataDO.setValidityPeriodInMillis(claimsSet.getExpirationTime().getTime() - claimsSet.getIssueTime().getTime());
        validationDataDO.setScope(TokenMgtUtil.getScopes(claimsSet.getClaim("scope")));
        if (OAuth2ServiceComponentHolder.isConsentedTokenColumnEnabled() && claimsSet.getClaim("is_consented") != null) {
            validationDataDO.setConsented(((Boolean)claimsSet.getClaim("is_consented")).booleanValue());
        }
        validationDataDO.setAuthorizedUser(authenticatedUser);
        validationDataDO.setRefreshToken(refreshTokenIdentifier);
        validationDataDO.setTokenId(TokenMgtUtil.getTokenId(claimsSet));
        return validationDataDO;
    }

    private AccessTokenDO getMigratedAccessToken(String accessTokenIdentifier, boolean includeExpired) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO = OAuth2Util.findAccessToken((String)accessTokenIdentifier, (boolean)includeExpired);
        if (accessTokenDO != null) {
            accessTokenDO.addProperty((Object)"IS_PERSISTED", (Object)true);
        }
        return accessTokenDO;
    }
}

