/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.listner;

import java.util.Calendar;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.identity.oauth.listener.OAuthApplicationMgtListener;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.is.key.manager.tokenpersistence.internal.ServiceReferenceHolder;
import org.wso2.is.notification.event.ConsumerAppRevocationEvent;
import org.wso2.is.notification.event.Event;

public class APIMOAuthApplicationMgtListener
implements OAuthApplicationMgtListener {
    private static final Log log = LogFactory.getLog(APIMOAuthApplicationMgtListener.class);

    public boolean isEnabled() {
        return false;
    }

    public int getExecutionOrder() {
        return 0;
    }

    public void doPreUpdateConsumerApplication(OAuthConsumerAppDTO oAuthConsumerAppDTO) {
    }

    public void doPreUpdateConsumerApplicationState(String s, String s1) {
    }

    public void doPreRemoveOAuthApplicationData(String s) {
    }

    public void doPostTokenRevocationOnClientAppEvent(String consumerKey, Properties properties) throws IdentityOAuthAdminException {
        if (!OAuth2Util.isTokenPersistenceEnabled()) {
            long revocationTime = Calendar.getInstance().getTimeInMillis();
            String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            try {
                ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().revokeTokensByConsumerKeyEvent(consumerKey, revocationTime, tenantDomain, 0);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)"Error while persisting revoking access tokens by consumer key event.", (Throwable)e);
                throw new IdentityOAuthAdminException(e.getMessage(), (Throwable)e);
            }
            ConsumerAppRevocationEvent consumerAppRevocationEvent = new ConsumerAppRevocationEvent(consumerKey);
            try {
                int tenantId = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getTenantId(tenantDomain);
                consumerAppRevocationEvent.setTenantDomain(tenantDomain);
                consumerAppRevocationEvent.setTenantId(tenantId);
            }
            catch (UserStoreException e) {
                log.error((Object)"Error while finding tenant id", (Throwable)e);
            }
            consumerAppRevocationEvent.setRevocationTime(revocationTime);
            ServiceReferenceHolder.getInstance().getEventSenderService().publishEvent((Event)consumerAppRevocationEvent);
        }
    }
}

