/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.processor;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.tokenprocessor.OAuth2RevocationProcessor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.AccessTokenDAO;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.is.key.manager.tokenpersistence.internal.ServiceReferenceHolder;
import org.wso2.is.key.manager.tokenpersistence.utils.OpaqueTokenUtil;

public class InMemoryOAuth2RevocationProcessor
implements OAuth2RevocationProcessor {
    private static final Log log = LogFactory.getLog(InMemoryOAuth2RevocationProcessor.class);

    public void revokeAccessToken(OAuthRevocationRequestDTO revokeRequestDTO, AccessTokenDO accessTokenDO) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)String.format("Revoking access token(hashed): %s", DigestUtils.sha256Hex((String)accessTokenDO.getAccessToken())));
            } else {
                log.debug((Object)"Revoking access token.");
            }
        }
        if (accessTokenDO.getProperty((Object)"IS_PERSISTED") != null && ((Boolean)accessTokenDO.getProperty((Object)"IS_PERSISTED")).booleanValue()) {
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{accessTokenDO.getAccessToken()});
        } else {
            accessTokenDO.setTokenState("REVOKED");
            ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().addInvalidToken(accessTokenDO.getAccessToken(), accessTokenDO.getConsumerKey(), accessTokenDO.getIssuedTime().getTime() + accessTokenDO.getValidityPeriodInMillis());
        }
    }

    public void revokeRefreshToken(OAuthRevocationRequestDTO revokeRequestDTO, RefreshTokenValidationDataDO refreshTokenDO) throws IdentityOAuth2Exception {
        String refreshTokenIdentifier = refreshTokenDO.getRefreshToken();
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
                log.debug((Object)String.format("Revoking refresh token(hashed): %s", DigestUtils.sha256Hex((String)refreshTokenIdentifier)));
            } else {
                log.debug((Object)"Revoking refresh token.");
            }
        }
        if (refreshTokenDO.getProperty((Object)"IS_PERSISTED") != null && ((Boolean)refreshTokenDO.getProperty((Object)"IS_PERSISTED")).booleanValue()) {
            OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{refreshTokenDO.getAccessToken()});
        } else {
            refreshTokenDO.setRefreshTokenState("REVOKED");
            ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().addInvalidToken(refreshTokenIdentifier, revokeRequestDTO.getConsumerKey(), refreshTokenDO.getIssuedTime().getTime() + refreshTokenDO.getValidityPeriodInMillis());
        }
    }

    public boolean revokeTokens(String username, UserStoreManager userStoreManager) throws UserStoreException {
        this.revokeMigratedTokenOfUser(username, userStoreManager);
        String userUUID = ((AbstractUserStoreManager)userStoreManager).getUserIDFromUserName(username);
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantId);
        long revocationTime = Calendar.getInstance().getTimeInMillis();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("entityId", userUUID);
        params.put("entityType", "USER_ID");
        params.put("revocationTime", revocationTime);
        params.put("tenantDomain", tenantDomain);
        params.put("tenantId", tenantId);
        params.put("username", username);
        OAuthUtil.invokePreRevocationBySystemListeners((String)userUUID, params);
        try {
            ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().revokeTokensByUserEvent(userUUID, "USER_ID", revocationTime, tenantDomain, 0);
            this.revokeAppTokensOfUser(params);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)"Error while persisting revoke rules for tokens by user event.", (Throwable)e);
            return false;
        }
        OAuthUtil.invokePostRevocationBySystemListeners((String)userUUID, params);
        return true;
    }

    private void revokeAppTokensOfUser(Map<String, Object> params) {
        int tenantId = (Integer)params.get("tenantId");
        String tenantDomain = params.get("tenantDomain").toString();
        long revocationTime = (Long)params.get("revocationTime");
        OAuthAppDAO oAuthAppDAO = new OAuthAppDAO();
        try {
            OAuthAppDO[] oAuthAppDOs;
            for (OAuthAppDO oAuthAppDO : oAuthAppDOs = oAuthAppDAO.getOAuthConsumerAppsOfUser((String)params.get("username"), tenantId)) {
                String consumerKey = oAuthAppDO.getOauthConsumerKey();
                HashMap<String, Object> revokeAppTokenParams = new HashMap<String, Object>();
                revokeAppTokenParams.put("entityId", consumerKey);
                revokeAppTokenParams.put("entityType", "CLIENT_ID");
                revokeAppTokenParams.put("revocationTime", revocationTime);
                revokeAppTokenParams.put("tenantDomain", tenantDomain);
                revokeAppTokenParams.put("tenantId", tenantId);
                OAuthUtil.invokePreRevocationBySystemListeners((String)consumerKey, revokeAppTokenParams);
                ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().revokeTokensByUserEvent(consumerKey, "CLIENT_ID", revocationTime, tenantDomain, 0);
                OAuthUtil.invokePostRevocationBySystemListeners((String)consumerKey, revokeAppTokenParams);
            }
        }
        catch (IdentityOAuthAdminException | IdentityOAuth2Exception e) {
            log.error((Object)"Error while persisting revoke rules for app tokens by user event.", e);
        }
    }

    private void revokeMigratedTokenOfUser(String username, UserStoreManager userStoreManager) throws UserStoreException {
        Set clientIds;
        String userStoreDomain = UserCoreUtil.getDomainName((RealmConfiguration)userStoreManager.getRealmConfiguration());
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)userStoreManager.getTenantId());
        AuthenticatedUser authenticatedUser = new AuthenticatedUser();
        authenticatedUser.setUserStoreDomain(userStoreDomain);
        authenticatedUser.setTenantDomain(tenantDomain);
        authenticatedUser.setUserName(username);
        userStoreDomain = null;
        if (OAuth2Util.checkAccessTokenPartitioningEnabled() && OAuth2Util.checkUserNameAssertionEnabled()) {
            try {
                userStoreDomain = OAuth2Util.getUserStoreForFederatedUser((AuthenticatedUser)authenticatedUser);
            }
            catch (IdentityOAuth2Exception e) {
                log.error((Object)("Error occurred while getting user store domain for User ID : " + authenticatedUser), (Throwable)e);
                throw new UserStoreException((Throwable)e);
            }
        }
        try {
            clientIds = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().getAllTimeAuthorizedClientIds(authenticatedUser);
        }
        catch (IdentityOAuth2Exception e) {
            log.error((Object)("Error occurred while retrieving apps authorized by User ID : " + authenticatedUser), (Throwable)e);
            throw new UserStoreException((Throwable)e);
        }
        boolean isErrorOnRevokingTokens = false;
        for (String clientId : clientIds) {
            try {
                Set accessTokenDOs;
                try {
                    AccessTokenDAO accessTokenDAO = ServiceReferenceHolder.getInstance().getMigratedAccessTokenDAO();
                    accessTokenDOs = accessTokenDAO.getAccessTokens(clientId, authenticatedUser, userStoreDomain, true);
                }
                catch (IdentityOAuth2Exception e) {
                    String errorMsg = "Error occurred while retrieving access tokens issued for Client ID : " + clientId + ", User ID : " + authenticatedUser;
                    log.error((Object)errorMsg, (Throwable)e);
                    throw new UserStoreException((Throwable)e);
                }
                if (log.isDebugEnabled() && CollectionUtils.isNotEmpty((Collection)accessTokenDOs)) {
                    log.debug((Object)("ACTIVE or EXPIRED access tokens found for the client: " + clientId + " for the user: " + username));
                }
                ArrayList<AccessTokenDO> accessTokens = new ArrayList<AccessTokenDO>();
                for (AccessTokenDO accessTokenDO : accessTokenDOs) {
                    String tokenBindingReference = "NONE";
                    if (accessTokenDO.getTokenBinding() != null && StringUtils.isNotBlank((String)accessTokenDO.getTokenBinding().getBindingReference())) {
                        tokenBindingReference = accessTokenDO.getTokenBinding().getBindingReference();
                    }
                    OAuthUtil.clearOAuthCache((String)accessTokenDO.getConsumerKey(), (AuthenticatedUser)accessTokenDO.getAuthzUser(), (String)OAuth2Util.buildScopeString((String[])accessTokenDO.getScope()), (String)tokenBindingReference);
                    OAuthUtil.clearOAuthCache((String)accessTokenDO.getConsumerKey(), (AuthenticatedUser)accessTokenDO.getAuthzUser(), (String)OAuth2Util.buildScopeString((String[])accessTokenDO.getScope()), (String)tokenBindingReference);
                    OAuthUtil.clearOAuthCache((String)accessTokenDO.getConsumerKey(), (AuthenticatedUser)accessTokenDO.getAuthzUser(), (String)OAuth2Util.buildScopeString((String[])accessTokenDO.getScope()));
                    OAuthUtil.clearOAuthCache((String)accessTokenDO.getConsumerKey(), (AuthenticatedUser)accessTokenDO.getAuthzUser());
                    OAuthUtil.clearOAuthCache((AccessTokenDO)accessTokenDO);
                    accessTokens.add(accessTokenDO);
                }
                try {
                    OpaqueTokenUtil.revokeTokens(accessTokens);
                }
                catch (IdentityOAuth2Exception e) {
                    String errorMsg = "Error occurred while revoking Access Token";
                    log.error((Object)errorMsg, (Throwable)e);
                    throw new UserStoreException((Throwable)e);
                }
            }
            catch (UserStoreException e) {
                isErrorOnRevokingTokens = true;
            }
        }
        if (isErrorOnRevokingTokens) {
            throw new UserStoreException("Error occurred while revoking Access Tokens of the user " + username);
        }
    }
}

