/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.is.key.manager.tokenpersistence.model.InvalidTokenPersistenceService;

public class DBInvalidTokenPersistence
implements InvalidTokenPersistenceService {
    private static final Log log = LogFactory.getLog(DBInvalidTokenPersistence.class);
    private static final DBInvalidTokenPersistence instance = new DBInvalidTokenPersistence();
    private static final String OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT = "OAuth.TokenPersistence.RetryCount";
    private static final int DEFAULT_TOKEN_PERSIST_RETRY_COUNT = 5;

    private DBInvalidTokenPersistence() {
    }

    public static synchronized DBInvalidTokenPersistence getInstance() {
        return instance;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isInvalidToken(String token, String consumerKey) throws IdentityOAuth2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addInvalidToken(String token, String consumerKey, Long expiryTime) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)String.format("Insert invalid token (hashed): %s for consumer key: %s with expiry time: %s", DigestUtils.sha256Hex((String)token), consumerKey, expiryTime));
            } else {
                log.debug((Object)String.format("Insert invalid token for consumer key: %s with expiry time: %s", consumerKey, expiryTime));
            }
        }
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
            try (PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO IDN_INVALID_TOKENS (UUID, TOKEN_IDENTIFIER, CONSUMER_KEY, EXPIRY_TIMESTAMP) VALUES (?,?,?,?)");){
                preparedStatement.setString(1, UUID.randomUUID().toString());
                preparedStatement.setString(2, token);
                preparedStatement.setString(3, consumerKey);
                preparedStatement.setTimestamp(4, new Timestamp(expiryTime), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                preparedStatement.executeUpdate();
                IdentityDatabaseUtil.commitTransaction((Connection)connection);
            }
            catch (SQLException e) {
                IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                throw new IdentityOAuth2Exception(String.format("Failed to add invalid token for consumer key: %s with expiry time: %s", consumerKey, expiryTime), (Throwable)e);
            }
        }
        catch (SQLException e) {
            throw new IdentityOAuth2Exception(String.format("Failed to add invalid token for consumer key: %s with expiry time: %s", consumerKey, expiryTime), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isTokenRevokedForConsumerKey(String consumerKey, Date tokenIssuedTime) throws IdentityOAuth2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isTokenRevokedForSubjectEntity(String entityId, Date tokenIssuedTime) throws IdentityOAuth2Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void revokeTokensByUserEvent(String subjectId, String subjectIdType, long revocationTime, String organization, int retryAttemptCounter) throws IdentityOAuth2Exception {
        block48: {
            try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
                String updateQuery = "UPDATE IDN_SUBJECT_ENTITY_REVOKED_EVENT SET TIME_REVOKED = ? WHERE ENTITY_ID = ? AND ENTITY_TYPE = ? AND ORGANIZATION = ?";
                try (PreparedStatement ps = connection.prepareStatement(updateQuery);){
                    ps.setTimestamp(1, new Timestamp(revocationTime), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    ps.setString(2, subjectId);
                    ps.setString(3, subjectIdType);
                    ps.setString(4, organization);
                    int rowsAffected = ps.executeUpdate();
                    if (rowsAffected == 0) {
                        log.debug((Object)"User event token revocation rule not found. Inserting new rule.");
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        String insertQuery = "INSERT INTO IDN_SUBJECT_ENTITY_REVOKED_EVENT (EVENT_ID, ENTITY_ID, ENTITY_TYPE, TIME_REVOKED, ORGANIZATION) VALUES (?, ?, ?, ?, ?)";
                        try (PreparedStatement ps1 = connection.prepareStatement(insertQuery);){
                            ps1.setString(1, UUID.randomUUID().toString());
                            ps1.setString(2, subjectId);
                            ps1.setString(3, subjectIdType);
                            ps1.setTimestamp(4, new Timestamp(revocationTime), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                            ps1.setString(5, organization);
                            ps1.execute();
                            IdentityDatabaseUtil.commitTransaction((Connection)connection);
                            if (retryAttemptCounter > 0) {
                                log.info((Object)("Successfully recovered CON_SUB_EVT_KEY constraint violation with the attempt : " + retryAttemptCounter));
                            }
                            break block48;
                        }
                        catch (SQLIntegrityConstraintViolationException e) {
                            this.rollbackUserEventTransaction(connection);
                            this.retryOnConstraintViolationException(retryAttemptCounter, subjectId, subjectIdType, revocationTime, organization, e);
                            break block48;
                        }
                        catch (SQLException e) {
                            this.rollbackUserEventTransaction(connection);
                            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"CON_SUB_EVT_KEY")) {
                                this.retryOnConstraintViolationException(retryAttemptCounter, subjectId, subjectIdType, revocationTime, organization, e);
                                break block48;
                            }
                            throw new IdentityOAuth2Exception("Error while inserting user event revocation rule to db." + e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            this.rollbackUserEventTransaction(connection);
                            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"CON_SUB_EVT_KEY") || e.getCause() != null && StringUtils.containsIgnoreCase((String)e.getCause().getMessage(), (String)"CON_SUB_EVT_KEY") || e.getCause() != null && e.getCause().getCause() != null && StringUtils.containsIgnoreCase((String)e.getCause().getCause().getMessage(), (String)"CON_SUB_EVT_KEY")) {
                                this.retryOnConstraintViolationException(retryAttemptCounter, subjectId, subjectIdType, revocationTime, organization, e);
                                break block48;
                            }
                            throw new IdentityOAuth2Exception("Error while inserting user event revocation rule to db." + e.getMessage(), (Throwable)e);
                        }
                    }
                    log.debug((Object)"User event token revocation rule updated.");
                    IdentityDatabaseUtil.commitTransaction((Connection)connection);
                }
                catch (SQLException e) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                    throw new IdentityOAuth2Exception("Error while inserting user event revocation rule to db." + e.getMessage(), (Throwable)e);
                }
            }
            catch (SQLException e) {
                throw new IdentityOAuth2Exception("Error while inserting user event revocation rule to db." + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void retryOnConstraintViolationException(int retryAttemptCounter, String subjectId, String subjectIdType, long revocationTime, String organization, Exception exception) throws IdentityOAuth2Exception {
        String errorMessage = String.format("User event token revocation rule for subject id : %s, type : %s and organization : %s already exists", subjectId, subjectIdType, organization);
        if (retryAttemptCounter >= this.getTokenPersistRetryCount()) {
            log.error((Object)"CON_SUB_EVT_KEY constraint violation retry count exceeds the maximum");
            throw new IdentityOAuth2Exception(errorMessage, (Throwable)exception);
        }
        this.revokeTokensByUserEvent(subjectId, subjectIdType, revocationTime, organization, retryAttemptCounter + 1);
    }

    private void rollbackUserEventTransaction(Connection connection) {
        log.warn((Object)"User event token revocation rule already persisted.");
        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
    }

    @Override
    public void revokeTokensByConsumerKeyEvent(String consumerKey, long revocationTime, String organization, int retryAttemptCounter) throws IdentityOAuth2Exception {
        block48: {
            try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)true);){
                String updateQuery = "UPDATE IDN_APP_REVOKED_EVENT SET TIME_REVOKED = ? WHERE CONSUMER_KEY = ? AND ORGANIZATION = ?";
                try (PreparedStatement ps = connection.prepareStatement(updateQuery);){
                    ps.setTimestamp(1, new Timestamp(revocationTime), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                    ps.setString(2, consumerKey);
                    ps.setString(3, organization);
                    int rowsAffected = ps.executeUpdate();
                    if (rowsAffected == 0) {
                        log.debug((Object)"Consumer key event token revocation rule not found. Inserting new rule.");
                        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                        String insertQuery = "INSERT INTO IDN_APP_REVOKED_EVENT (EVENT_ID, CONSUMER_KEY, TIME_REVOKED, ORGANIZATION) VALUES (?, ?, ?, ?)";
                        try (PreparedStatement ps1 = connection.prepareStatement(insertQuery);){
                            ps1.setString(1, UUID.randomUUID().toString());
                            ps1.setString(2, consumerKey);
                            ps1.setTimestamp(3, new Timestamp(revocationTime), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                            ps1.setString(4, organization);
                            ps1.execute();
                            IdentityDatabaseUtil.commitTransaction((Connection)connection);
                            if (retryAttemptCounter > 0) {
                                log.info((Object)("Successfully recovered CON_APP_EVT_KEY constraint violation with the attempt : " + retryAttemptCounter));
                            }
                            break block48;
                        }
                        catch (SQLIntegrityConstraintViolationException e) {
                            this.rollbackConsumerAppEventTransaction(connection);
                            this.retryOnConstraintViolationException(consumerKey, revocationTime, organization, retryAttemptCounter, e);
                            break block48;
                        }
                        catch (SQLException e) {
                            this.rollbackConsumerAppEventTransaction(connection);
                            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"CON_APP_EVT_KEY")) {
                                this.retryOnConstraintViolationException(consumerKey, revocationTime, organization, retryAttemptCounter, e);
                                break block48;
                            }
                            throw new IdentityOAuth2Exception("Error while inserting consumer key event revocation rule to db." + e.getMessage(), (Throwable)e);
                        }
                        catch (Exception e) {
                            this.rollbackConsumerAppEventTransaction(connection);
                            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"CON_APP_EVT_KEY") || e.getCause() != null && StringUtils.containsIgnoreCase((String)e.getCause().getMessage(), (String)"CON_APP_EVT_KEY") || e.getCause() != null && e.getCause().getCause() != null && StringUtils.containsIgnoreCase((String)e.getCause().getCause().getMessage(), (String)"CON_APP_EVT_KEY")) {
                                this.retryOnConstraintViolationException(consumerKey, revocationTime, organization, retryAttemptCounter, e);
                                break block48;
                            }
                            throw new IdentityOAuth2Exception("Error while inserting user event revocation rule to db." + e.getMessage(), (Throwable)e);
                        }
                    }
                    log.debug((Object)"Consumer key event token revocation rule updated.");
                    IdentityDatabaseUtil.commitTransaction((Connection)connection);
                }
                catch (SQLException e) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
                    throw new IdentityOAuth2Exception("Error while inserting consumer key event revocation rule to db." + e.getMessage(), (Throwable)e);
                }
            }
            catch (SQLException e) {
                throw new IdentityOAuth2Exception("Error while inserting consumer key event revocation rule to db." + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void retryOnConstraintViolationException(String consumerKey, long revocationTime, String organization, int retryAttemptCounter, Exception exception) throws IdentityOAuth2Exception {
        String errorMessage = String.format("Consumer app event token revocation rule for consumer key : %sand organization : %s already exists", consumerKey, organization);
        if (retryAttemptCounter >= this.getTokenPersistRetryCount()) {
            log.error((Object)"'CON_APP_EVT_KEY' constrain violation retry count exceeds the maximum");
            throw new IdentityOAuth2Exception(errorMessage, (Throwable)exception);
        }
        this.revokeTokensByConsumerKeyEvent(consumerKey, revocationTime, organization, retryAttemptCounter + 1);
    }

    private void rollbackConsumerAppEventTransaction(Connection connection) {
        log.warn((Object)"Consumer key event token revocation rule already persisted.");
        IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
    }

    private int getTokenPersistRetryCount() {
        int tokenPersistRetryCount = 5;
        if (IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT) != null) {
            tokenPersistRetryCount = Integer.parseInt(IdentityUtil.getProperty((String)OAUTH_TOKEN_PERSISTENCE_RETRY_COUNT));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("OAuth Token Persistence Retry count set to " + tokenPersistRetryCount));
        }
        return tokenPersistRetryCount;
    }
}

