/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.issuer;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.token.JWTTokenIssuer;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class ExtendedJWTTokenIssuer
extends JWTTokenIssuer {
    private static final Log log = LogFactory.getLog(ExtendedJWTTokenIssuer.class);
    private final Algorithm signatureAlgorithm;

    public ExtendedJWTTokenIssuer() throws IdentityOAuth2Exception {
        OAuthServerConfiguration config = OAuthServerConfiguration.getInstance();
        this.signatureAlgorithm = this.mapSignatureAlgorithm(config.getSignatureAlgorithm());
    }

    public String refreshToken(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext) throws OAuthSystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh token request with authorization request message context message context. Authorized user " + oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getUser().getLoggableUserId()));
        }
        try {
            return this.buildJWTTokenForRefreshTokens(oAuthAuthzReqMessageContext);
        }
        catch (IdentityOAuth2Exception e) {
            throw new OAuthSystemException((Throwable)e);
        }
    }

    public String refreshToken(OAuthTokenReqMessageContext tokReqMsgCtx) throws OAuthSystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh token request with token request message context. Authorized user " + tokReqMsgCtx.getAuthorizedUser().getLoggableUserId()));
        }
        try {
            String grantType = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getGrantType();
            if (OAuthServerConfiguration.getInstance().getValueForIsRefreshTokenAllowed(grantType)) {
                return this.buildJWTTokenForRefreshTokens(tokReqMsgCtx);
            }
            return null;
        }
        catch (IdentityOAuth2Exception e) {
            throw new OAuthSystemException((Throwable)e);
        }
    }

    protected String buildJWTTokenForRefreshTokens(OAuthAuthzReqMessageContext request) throws IdentityOAuth2Exception {
        JWTClaimsSet jwtClaimsSet = this.createJWTClaimSetForRefreshTokens(request, null, request.getAuthorizationReqDTO().getConsumerKey());
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder(jwtClaimsSet);
        if (request.getApprovedScope() != null && Arrays.asList(request.getApprovedScope()).contains("aud")) {
            jwtClaimsSetBuilder.audience(Arrays.asList(request.getApprovedScope()));
        }
        jwtClaimsSet = jwtClaimsSetBuilder.build();
        if (JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName())) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.signJWT(jwtClaimsSet, null, request);
    }

    protected String buildJWTTokenForRefreshTokens(OAuthTokenReqMessageContext request) throws IdentityOAuth2Exception {
        JWTClaimsSet jwtClaimsSet = this.createJWTClaimSetForRefreshTokens(null, request, request.getOauth2AccessTokenReqDTO().getClientId());
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder(jwtClaimsSet);
        if (request.getScope() != null && Arrays.asList(request.getScope()).contains("aud")) {
            jwtClaimsSetBuilder.audience(Arrays.asList(request.getScope()));
        }
        jwtClaimsSet = jwtClaimsSetBuilder.build();
        if (JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName())) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.signJWT(jwtClaimsSet, request, null);
    }

    protected JWTClaimsSet createJWTClaimSetForRefreshTokens(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext, String consumerKey) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        String spTenantDomain;
        try {
            spTenantDomain = authAuthzReqMessageContext != null ? authAuthzReqMessageContext.getAuthorizationReqDTO().getTenantDomain() : tokenReqMessageContext.getOauth2AccessTokenReqDTO().getTenantDomain();
            oAuthAppDO = OAuth2Util.getAppInformationByClientId((String)consumerKey);
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while retrieving app information for clientId: " + consumerKey, (Throwable)e);
        }
        String issuer = OAuth2Util.getIdTokenIssuer((String)spTenantDomain);
        AuthenticatedUser authenticatedUser = this.getAuthenticatedUser(authAuthzReqMessageContext, tokenReqMessageContext);
        String sub = this.getSubjectClaim(authenticatedUser);
        JWTClaimsSet.Builder jwtClaimsSetBuilder = new JWTClaimsSet.Builder();
        jwtClaimsSetBuilder.issuer(issuer);
        jwtClaimsSetBuilder.subject(sub);
        jwtClaimsSetBuilder.claim("azp", (Object)consumerKey);
        long refreshTokenLifeTimeInMillis = tokenReqMessageContext != null ? this.getRefreshTokenLifeTimeInMillis(oAuthAppDO, tokenReqMessageContext) : this.getRefreshTokenLifeTimeInMillis(oAuthAppDO, authAuthzReqMessageContext);
        long curTimeInMillis = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        Date issuedTime = new Date(curTimeInMillis);
        jwtClaimsSetBuilder.issueTime(this.getRefreshTokenIssuedTime(tokenReqMessageContext, oAuthAppDO, issuedTime));
        jwtClaimsSetBuilder.expirationTime(this.calculateRefreshTokenExpiryTime(refreshTokenLifeTimeInMillis, curTimeInMillis));
        jwtClaimsSetBuilder.jwtID(UUID.randomUUID().toString());
        jwtClaimsSetBuilder.claim("client_id", (Object)consumerKey);
        String scope = this.getScope(authAuthzReqMessageContext, tokenReqMessageContext, sub);
        if (StringUtils.isNotEmpty((String)scope)) {
            jwtClaimsSetBuilder.claim("scope", (Object)scope);
        }
        jwtClaimsSetBuilder.claim("token_type", (Object)"refresh_token");
        List audience = OAuth2Util.getOIDCAudience((String)consumerKey, (OAuthAppDO)oAuthAppDO);
        jwtClaimsSetBuilder.audience(audience);
        this.setClaimsForNonPersistence(jwtClaimsSetBuilder, authAuthzReqMessageContext, tokenReqMessageContext, authenticatedUser, oAuthAppDO);
        return jwtClaimsSetBuilder.build();
    }

    private long getRefreshTokenLifeTimeInMillisFromConfig(OAuthAppDO oAuthAppDO) {
        long refreshTokenValidityPeriodInMillis;
        String consumerKey = oAuthAppDO.getOauthConsumerKey();
        if (oAuthAppDO.getRefreshTokenExpiryTime() != 0L) {
            refreshTokenValidityPeriodInMillis = oAuthAppDO.getRefreshTokenExpiryTime() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + consumerKey + ", refresh token validity time " + refreshTokenValidityPeriodInMillis + "ms"));
            }
        } else {
            refreshTokenValidityPeriodInMillis = OAuthServerConfiguration.getInstance().getRefreshTokenValidityPeriodInSeconds() * 1000L;
        }
        return refreshTokenValidityPeriodInMillis;
    }

    private long getRefreshTokenLifeTimeInMillis(OAuthAppDO oAuthAppDO, OAuthTokenReqMessageContext tokenReqMessageContext) {
        String consumerKey = oAuthAppDO.getOauthConsumerKey();
        long refreshTokenValidityPeriodInMillis = 0L;
        long validityPeriodFromMsgContext = tokenReqMessageContext.getRefreshTokenvalidityPeriod();
        if (validityPeriodFromMsgContext > 0L) {
            refreshTokenValidityPeriodInMillis = validityPeriodFromMsgContext * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + consumerKey + ", using refresh token validity period configured from OAuthTokenReqMessageContext: " + refreshTokenValidityPeriodInMillis + " ms"));
            }
        } else if (tokenReqMessageContext.getProperty((Object)"previousAccessToken") != null) {
            RefreshTokenValidationDataDO validationBean = (RefreshTokenValidationDataDO)tokenReqMessageContext.getProperty((Object)"previousAccessToken");
            if (this.isRenewRefreshToken(oAuthAppDO.getRenewRefreshTokenEnabled()) && !OAuthServerConfiguration.getInstance().isExtendRenewedTokenExpiryTimeEnabled()) {
                refreshTokenValidityPeriodInMillis = validationBean.getValidityPeriodInMillis();
            }
        }
        if (refreshTokenValidityPeriodInMillis == 0L) {
            refreshTokenValidityPeriodInMillis = this.getRefreshTokenLifeTimeInMillisFromConfig(oAuthAppDO);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JWT Self Signed Refresh Token Life time set to : " + refreshTokenValidityPeriodInMillis + "ms."));
        }
        return refreshTokenValidityPeriodInMillis;
    }

    private long getRefreshTokenLifeTimeInMillis(OAuthAppDO oAuthAppBean, OAuthAuthzReqMessageContext oauthAuthzMsgCtx) {
        long refreshTokenValidityPeriodInMillis = 0L;
        long refreshTokenValidityPeriod = oauthAuthzMsgCtx.getRefreshTokenvalidityPeriod();
        if (refreshTokenValidityPeriod > 0L) {
            refreshTokenValidityPeriodInMillis = oauthAuthzMsgCtx.getRefreshTokenvalidityPeriod() * 1000L;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OAuth application id : " + oAuthAppBean.getOauthConsumerKey() + ", using refresh token validity period configured from OAuthAuthzReqMessageContext: " + refreshTokenValidityPeriodInMillis + " ms"));
            }
        }
        if (refreshTokenValidityPeriodInMillis == 0L) {
            refreshTokenValidityPeriodInMillis = this.getRefreshTokenLifeTimeInMillisFromConfig(oAuthAppBean);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JWT Self Signed Refresh Token Life time set to : " + refreshTokenValidityPeriodInMillis + "ms."));
        }
        return refreshTokenValidityPeriodInMillis;
    }

    private Date getRefreshTokenIssuedTime(OAuthTokenReqMessageContext tokenReqMessageContext, OAuthAppDO oAuthAppDO, Date currentTime) {
        Date refreshTokenIssuedTime = currentTime;
        if (tokenReqMessageContext != null && tokenReqMessageContext.getProperty((Object)"previousAccessToken") != null) {
            RefreshTokenValidationDataDO validationBean = (RefreshTokenValidationDataDO)tokenReqMessageContext.getProperty((Object)"previousAccessToken");
            if (this.isRenewRefreshToken(oAuthAppDO.getRenewRefreshTokenEnabled()) && !OAuthServerConfiguration.getInstance().isExtendRenewedTokenExpiryTimeEnabled()) {
                refreshTokenIssuedTime = validationBean.getIssuedTime();
            }
            if (refreshTokenIssuedTime == null) {
                refreshTokenIssuedTime = currentTime;
            }
        }
        return refreshTokenIssuedTime;
    }

    private boolean isRenewRefreshToken(String renewRefreshToken) {
        if (StringUtils.isNotBlank((String)renewRefreshToken)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Reading the Oauth application specific renew refresh token value as " + renewRefreshToken + " from the IDN_OIDC_PROPERTY table"));
            }
            return Boolean.parseBoolean(renewRefreshToken);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading the global renew refresh token value from the identity.xml");
        }
        return OAuthServerConfiguration.getInstance().isRefreshTokenRenewalEnabled();
    }

    protected AuthenticatedUser getAuthenticatedUser(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext) throws IdentityOAuth2Exception {
        AuthenticatedUser authenticatedUser = authAuthzReqMessageContext != null ? authAuthzReqMessageContext.getAuthorizationReqDTO().getUser() : tokenReqMessageContext.getAuthorizedUser();
        if (authenticatedUser == null) {
            throw new IdentityOAuth2Exception("Authenticated user is null for the request.");
        }
        return authenticatedUser;
    }

    protected String getScope(OAuthAuthzReqMessageContext authAuthzReqMessageContext, OAuthTokenReqMessageContext tokenReqMessageContext, String subject) {
        String scopeString = null;
        Object[] scope = tokenReqMessageContext != null ? tokenReqMessageContext.getScope() : authAuthzReqMessageContext.getApprovedScope();
        if (ArrayUtils.isNotEmpty((Object[])scope)) {
            scopeString = OAuth2Util.buildScopeString((String[])scope);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scope exist for the jwt access token with subject " + subject + " and the scope is " + scopeString));
            }
        }
        return scopeString;
    }

    protected String getSubjectClaim(AuthenticatedUser authenticatedUser) {
        return authenticatedUser.getAuthenticatedSubjectIdentifier();
    }

    private Date calculateRefreshTokenExpiryTime(Long refreshTokenLifeTimeInMillis, Long curTimeInMillis) {
        Date expirationTime = curTimeInMillis + refreshTokenLifeTimeInMillis < curTimeInMillis ? new Date(Long.MAX_VALUE) : new Date(curTimeInMillis + refreshTokenLifeTimeInMillis);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refresh token expiry time : " + expirationTime + "ms."));
        }
        return expirationTime;
    }
}

