/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.utils;

import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dao.OAuthTokenPersistenceFactory;
import org.wso2.carbon.identity.oauth2.internal.OAuth2ServiceComponentHolder;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.openidconnect.OIDCClaimUtil;

public class OpaqueTokenUtil {
    private static final Log log = LogFactory.getLog(OpaqueTokenUtil.class);

    public static AccessTokenDO findRefreshToken(String refreshToken) throws IdentityOAuth2Exception {
        AccessTokenDO accessTokenDO = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().getRefreshToken(refreshToken);
        accessTokenDO.addProperty((Object)"IS_PERSISTED", (Object)true);
        return accessTokenDO;
    }

    public static RefreshTokenValidationDataDO validateOpaqueRefreshToken(String token, String consumerKey) throws IdentityOAuth2Exception {
        RefreshTokenValidationDataDO validationBean = OpaqueTokenUtil.validateRefreshToken(consumerKey, token);
        if (validationBean.getAccessToken() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid Refresh Token provided for Client with Client Id : %s", consumerKey));
            }
            throw new IdentityOAuth2Exception("Persisted access token data not found.");
        }
        return validationBean;
    }

    private static RefreshTokenValidationDataDO validateRefreshToken(String clientId, String refreshToken) throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"RefreshToken")) {
                log.debug((Object)("Validating refresh token(hashed): " + DigestUtils.sha256Hex((String)refreshToken) + " client: " + clientId));
            } else {
                log.debug((Object)("Validating refresh token for client: " + clientId));
            }
        }
        RefreshTokenValidationDataDO refreshTokenValidationDataDO = OAuthTokenPersistenceFactory.getInstance().getTokenManagementDAO().validateRefreshToken(clientId, refreshToken);
        refreshTokenValidationDataDO.addProperty((Object)"IS_PERSISTED", (Object)true);
        return refreshTokenValidationDataDO;
    }

    public static void validateTokenConsent(RefreshTokenValidationDataDO validationBean) throws IdentityOAuth2Exception {
        if (OAuth2ServiceComponentHolder.isConsentedTokenColumnEnabled()) {
            String previousGrantType = validationBean.getGrantType();
            if (!"refresh_token".equals(previousGrantType)) {
                if (OIDCClaimUtil.isConsentBasedClaimFilteringApplicable((String)previousGrantType)) {
                    validationBean.setConsented(true);
                }
            } else {
                AccessTokenDO accessTokenDOFromTokenIdentifier = OAuth2Util.getAccessTokenDOFromTokenIdentifier((String)validationBean.getAccessToken(), (boolean)false);
                validationBean.setConsented(accessTokenDOFromTokenIdentifier.isConsentedToken());
            }
        }
    }

    public static void revokeTokens(List<AccessTokenDO> accessTokens) throws IdentityOAuth2Exception {
        if (!accessTokens.isEmpty()) {
            for (AccessTokenDO accessToken : accessTokens) {
                OAuthUtil.invokePreRevocationBySystemListeners((AccessTokenDO)accessToken, Collections.emptyMap());
                OAuthTokenPersistenceFactory.getInstance().getAccessTokenDAO().revokeAccessTokens(new String[]{accessToken.getAccessToken()}, OAuth2Util.isHashEnabled());
                OAuthUtil.invokePostRevocationBySystemListeners((AccessTokenDO)accessToken, Collections.emptyMap());
            }
        }
    }
}

