/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.key.manager.tokenpersistence.utils;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.application.authentication.framework.exception.UserSessionException;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.store.UserSessionStore;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.cache.CacheEntry;
import org.wso2.carbon.identity.oauth.cache.OAuthCache;
import org.wso2.carbon.identity.oauth.cache.OAuthCacheKey;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.util.JWTUtils;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.is.key.manager.tokenpersistence.internal.ServiceReferenceHolder;

public class TokenMgtUtil {
    private static final Log log = LogFactory.getLog(TokenMgtUtil.class);

    public static String getTokenIdentifier(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        String jwtId = claimsSet.getJWTID();
        if (jwtId == null) {
            throw new IdentityOAuth2Exception("JTI could not be retrieved from the JWT token.");
        }
        return jwtId;
    }

    public static SignedJWT parseJWT(String accessToken) throws IdentityOAuth2Exception {
        try {
            return JWTUtils.parseJWT((String)accessToken);
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)String.format("Failed to parse the received token: %s", accessToken));
                } else {
                    log.debug((Object)"Failed to parse the received token.");
                }
            }
            throw new IdentityOAuth2Exception("Error while parsing token.", (Throwable)e);
        }
    }

    public static JWTClaimsSet getTokenJWTClaims(SignedJWT signedJWT) throws IdentityOAuth2Exception {
        Optional claimsSet = JWTUtils.getJWTClaimSet((SignedJWT)signedJWT);
        if (!claimsSet.isPresent()) {
            throw new IdentityOAuth2Exception("Claim values are empty in the given Token.");
        }
        return (JWTClaimsSet)claimsSet.get();
    }

    public static void validateJWTSignature(SignedJWT signedJWT, JWTClaimsSet claimsSet, AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        try {
            JWTClaimsSet jwtClaimsSet = signedJWT.getJWTClaimsSet();
            String tenantDomain = TokenMgtUtil.getSigningTenantDomain(claimsSet, authenticatedUser);
            IdentityProvider idp = JWTUtils.getResidentIDPForIssuer((JWTClaimsSet)claimsSet, (String)tenantDomain);
            Optional certificate = JWTUtils.getCertificateFromClaims((JWTClaimsSet)jwtClaimsSet);
            X509Certificate x509Certificate = certificate.isPresent() ? (X509Certificate)certificate.get() : JWTUtils.resolveSignerCertificate((IdentityProvider)idp);
            if (x509Certificate == null) {
                throw new IdentityOAuth2Exception("Unable to locate certificate for Identity Provider: " + idp.getDisplayName());
            }
            String algorithm = JWTUtils.verifyAlgorithm((SignedJWT)signedJWT);
            if (!JWTUtils.verifySignature((SignedJWT)signedJWT, (X509Certificate)x509Certificate, (String)algorithm)) {
                throw new IdentityOAuth2Exception("Invalid signature.");
            }
        }
        catch (JOSEException | ParseException e) {
            throw new IdentityOAuth2Exception("Error while validating Token.", e);
        }
    }

    public static String[] getScopes(Object scopes) {
        if (scopes instanceof String) {
            return ((String)scopes).split(" ");
        }
        return new String[0];
    }

    public static AuthenticatedUser getAuthenticatedUser(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        String consumerKey = null;
        String appTenantDomain = null;
        String userTenantDomain = null;
        try {
            log.debug((Object)"Getting tenant domain from OAuth app.");
            if (claimsSet.getClaim("app_td") != null) {
                appTenantDomain = (String)claimsSet.getClaim("app_td");
            } else {
                consumerKey = (String)claimsSet.getClaim("azp");
                if (consumerKey != null) {
                    appTenantDomain = OAuth2Util.getTenantDomainOfOauthApp((String)consumerKey);
                }
            }
        }
        catch (InvalidOAuthClientException e) {
            throw new IdentityOAuth2Exception("Error while getting tenant domain from OAuth app with consumer key: " + consumerKey);
        }
        boolean isFederated = claimsSet.getClaim("is_federated") != null && (Boolean)claimsSet.getClaim("is_federated") != false;
        userTenantDomain = claimsSet.getClaim("user_td") != null ? (String)claimsSet.getClaim("user_td") : TokenMgtUtil.getTenantDomain();
        AuthenticatedUser authenticatedUser = TokenMgtUtil.resolveAuthenticatedUserFromEntityId((String)claimsSet.getClaim("entity_id"), appTenantDomain, userTenantDomain, isFederated, claimsSet.getSubject());
        if (isFederated) {
            if (authenticatedUser == null) {
                authenticatedUser = TokenMgtUtil.createFederatedAuthenticatedUser((String)claimsSet.getClaim("entity_id"));
            } else {
                authenticatedUser.setFederatedUser(true);
            }
        }
        if (authenticatedUser == null) {
            throw new IdentityOAuth2Exception("Error while getting authenticated user. Authenticated user not found.");
        }
        authenticatedUser.setAuthenticatedSubjectIdentifier(claimsSet.getSubject());
        return authenticatedUser;
    }

    private static AuthenticatedUser resolveAuthenticatedUserFromEntityId(String entityId, String consumerAppTenantDomain, String userTenantDomain, boolean isFederated, String sub) throws IdentityOAuth2Exception {
        AuthenticatedUser authenticatedUser = null;
        Optional<OAuthAppDO> consumerApp = TokenMgtUtil.getOAuthApp(entityId);
        if (consumerApp.isPresent()) {
            authenticatedUser = consumerApp.get().getAppOwner();
        } else {
            try {
                String userName = TokenMgtUtil.getUserNameFromUserID(entityId, userTenantDomain);
                if (StringUtils.isBlank((CharSequence)userName)) {
                    userTenantDomain = consumerAppTenantDomain;
                    userName = TokenMgtUtil.getUserNameFromUserID(entityId, userTenantDomain);
                }
                if (StringUtils.isNotBlank((CharSequence)userName)) {
                    authenticatedUser = OAuth2Util.getUserFromUserName((String)userName);
                    authenticatedUser.setTenantDomain(userTenantDomain);
                    authenticatedUser.setUserId(entityId);
                } else if (!isFederated && !StringUtils.isBlank((CharSequence)sub)) {
                    userName = sub;
                    authenticatedUser = OAuth2Util.getUserFromUserName((String)userName);
                    authenticatedUser.setUserId(entityId);
                }
            }
            catch (UserStoreException e) {
                throw new IdentityOAuth2Exception("Error while getting username from JWT.", (Throwable)e);
            }
        }
        return authenticatedUser;
    }

    private static String getUserNameFromUserID(String userId, String tenantDomain) throws UserStoreException {
        RealmService realmService = ServiceReferenceHolder.getInstance().getRealmService();
        int tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
        AbstractUserStoreManager userStoreManager = (AbstractUserStoreManager)realmService.getTenantUserRealm(tenantId).getUserStoreManager();
        return userStoreManager.getUserNameFromUserID(userId);
    }

    public static String getTenantDomain() {
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if (StringUtils.isEmpty((CharSequence)tenantDomain)) {
            tenantDomain = "carbon.super";
        }
        return tenantDomain;
    }

    public static boolean isTokenRevokedIndirectly(JWTClaimsSet claimsSet, AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        Date tokenIssuedTime = claimsSet.getIssueTime();
        String entityId = (String)claimsSet.getClaim("entity_id");
        String consumerKey = (String)claimsSet.getClaim("azp");
        boolean isRevoked = TokenMgtUtil.isTokenRevokedIndirectlyFromApp(consumerKey, tokenIssuedTime);
        if (!isRevoked) {
            isRevoked = ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().isTokenRevokedForSubjectEntity(entityId, tokenIssuedTime);
        }
        if (isRevoked) {
            String tenantDomain = null;
            if (authenticatedUser != null) {
                String[] scopes = TokenMgtUtil.getScopes(claimsSet.getClaim("scope"));
                OAuthUtil.clearOAuthCache((String)consumerKey, (AuthenticatedUser)authenticatedUser, (String)OAuth2Util.buildScopeString((String[])scopes), (String)"NONE");
                OAuthUtil.clearOAuthCache((String)consumerKey, (AuthenticatedUser)authenticatedUser, (String)OAuth2Util.buildScopeString((String[])scopes));
                OAuthUtil.clearOAuthCache((String)consumerKey, (AuthenticatedUser)authenticatedUser);
                tenantDomain = authenticatedUser.getTenantDomain();
            }
            String accessTokenIdentifier = TokenMgtUtil.getTokenIdentifier(claimsSet);
            OAuthCacheKey cacheKey = new OAuthCacheKey(accessTokenIdentifier);
            OAuthCache.getInstance().clearCacheEntry(cacheKey, tenantDomain);
        }
        return isRevoked;
    }

    public static boolean isTokenRevokedIndirectlyFromApp(String consumerKey, Date tokenIssuedTime) throws IdentityOAuth2Exception {
        return ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().isTokenRevokedForConsumerKey(consumerKey, tokenIssuedTime);
    }

    public static boolean isTokenRevokedDirectly(String tokenIdentifier, String consumerKey) throws IdentityOAuth2Exception {
        return ServiceReferenceHolder.getInstance().getInvalidTokenPersistenceService().isInvalidToken(tokenIdentifier, consumerKey);
    }

    public static Optional<AccessTokenDO> getTokenDOFromCache(String accessTokenIdentifier) {
        CacheEntry result;
        AccessTokenDO accessTokenDO = null;
        if (OAuthCache.getInstance().isEnabled() && (result = (CacheEntry)OAuthCache.getInstance().getValueFromCache((Serializable)TokenMgtUtil.getOAuthCacheKey(accessTokenIdentifier))) instanceof AccessTokenDO) {
            accessTokenDO = (AccessTokenDO)result;
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)String.format("Hit OAuthCache for accessTokenIdentifier: %s", accessTokenIdentifier));
            } else {
                log.debug((Object)"Hit OAuthCache with accessTokenIdentifier");
            }
        }
        return Optional.ofNullable(accessTokenDO);
    }

    public static void addTokenToCache(String accessTokenIdentifier, AccessTokenDO accessTokenDO) {
        if (OAuthCache.getInstance().isEnabled()) {
            OAuthCache.getInstance().addToCache(TokenMgtUtil.getOAuthCacheKey(accessTokenIdentifier), (CacheEntry)accessTokenDO);
            if (log.isDebugEnabled()) {
                if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                    log.debug((Object)String.format("Access token(hashed): %s added to OAuthCache.", DigestUtils.sha256Hex((String)accessTokenIdentifier)));
                } else {
                    log.debug((Object)"Access token added to OAuthCache.");
                }
            }
        }
    }

    public static OAuthCacheKey getOAuthCacheKey(String accessTokenIdentifier) {
        return new OAuthCacheKey(accessTokenIdentifier);
    }

    public static boolean isRefreshTokenType(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        if (claimsSet.getClaim("token_type") != null && "refresh_token".equals(claimsSet.getClaim("token_type").toString())) {
            return true;
        }
        if (claimsSet.getClaim("token_type") != null) {
            throw new IdentityOAuth2Exception("Invalid token type received");
        }
        if (log.isDebugEnabled()) {
            if (IdentityUtil.isTokenLoggable((String)"AccessToken")) {
                log.debug((Object)String.format("The refresh_token claim missing in the JWT: %s. Hence not considering as a valid refresh token.", DigestUtils.sha256Hex((String)TokenMgtUtil.getTokenIdentifier(claimsSet))));
            } else {
                log.debug((Object)"The refresh_token claim missing in the JWT. Hence not considering as a valid refresh token.");
            }
        }
        return false;
    }

    public static Optional<OAuthAppDO> getOAuthApp(String clientId) throws IdentityOAuth2Exception {
        OAuthAppDO oAuthAppDO;
        block3: {
            oAuthAppDO = null;
            try {
                oAuthAppDO = OAuth2Util.getAppInformationByClientId((String)clientId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Retrieved OAuth application : " + clientId + ". Authorized user : " + oAuthAppDO.getAppOwner().toString()));
                }
            }
            catch (InvalidOAuthClientException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("OAuth application : " + clientId + " not found"));
            }
        }
        return Optional.ofNullable(oAuthAppDO);
    }

    public static AuthenticatedUser createFederatedAuthenticatedUser(String userId) throws IdentityOAuth2Exception {
        AuthenticatedUser authenticatedUser;
        try {
            authenticatedUser = UserSessionStore.getInstance().getUser(userId);
            if (authenticatedUser == null) {
                throw new IdentityOAuth2Exception("Error occurred while resolving the user from the userId for the federated user. No user found for the userId");
            }
            authenticatedUser.setUserId(userId);
            authenticatedUser.setUserName(authenticatedUser.getUserName());
            authenticatedUser.setTenantDomain(authenticatedUser.getTenantDomain());
            authenticatedUser.setUserStoreDomain(authenticatedUser.getUserStoreDomain());
            authenticatedUser.setFederatedUser(true);
            authenticatedUser.setFederatedIdPName(authenticatedUser.getFederatedIdPName());
        }
        catch (UserSessionException e) {
            throw new IdentityOAuth2Exception("Error occurred while resolving the user from the userId for the federated user", (Throwable)e);
        }
        return authenticatedUser;
    }

    public static String getTokenId(JWTClaimsSet claimsSet) throws IdentityOAuth2Exception {
        String tokenId;
        String string = tokenId = claimsSet.getClaim("usid") != null ? claimsSet.getClaim("usid").toString() : null;
        if (tokenId == null) {
            throw new IdentityOAuth2Exception("TokenId could not be retrieved from the JWT token.");
        }
        return tokenId;
    }

    public static String getSigningTenantDomain(JWTClaimsSet claimsSet, AuthenticatedUser authenticatedUser) throws IdentityOAuth2Exception {
        String consumerKey;
        HashMap realm = (HashMap)claimsSet.getClaim("realm");
        if (MapUtils.isNotEmpty((Map)realm)) {
            if (realm.get("signing_tenant") != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting signing tenant domain from JWT's 'signing_tenant' claim.");
                }
                return (String)realm.get("signing_tenant");
            }
            if (realm.get("tenant") != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting signing tenant domain from JWT's 'tenant' claim.");
                }
                return (String)realm.get("tenant");
            }
        }
        if ((consumerKey = (String)claimsSet.getClaim("azp")) == null) {
            return TokenMgtUtil.getTenantDomain();
        }
        boolean isJWTSignedWithSPKey = OAuthServerConfiguration.getInstance().isJWTSignedWithSPKey();
        if (isJWTSignedWithSPKey) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting signing tenant domain from OAuth app.");
                }
                return OAuth2Util.getTenantDomainOfOauthApp((String)consumerKey);
            }
            catch (InvalidOAuthClientException e) {
                throw new IdentityOAuth2Exception("Error while getting tenant domain from OAuth app with consumer key: " + consumerKey);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Getting signing tenant domain from authenticated user.");
        }
        return authenticatedUser.getTenantDomain();
    }
}

