/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.notification;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.common.exception.InvalidOAuthClientException;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDO;
import org.wso2.carbon.identity.oauth.dto.OAuthRevocationRequestDTO;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuthRevocationResponseDTO;
import org.wso2.carbon.identity.oauth2.model.AccessTokenDO;
import org.wso2.carbon.identity.oauth2.model.RefreshTokenValidationDataDO;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.is.notification.EventSender;
import org.wso2.is.notification.NotificationUtil;
import org.wso2.is.notification.event.TokenRevocationEvent;
import org.wso2.is.notification.internal.ServiceReferenceHolder;

public class ApimOauthEventInterceptor
extends AbstractOAuthEventInterceptor {
    String notificationEndpoint;
    Map<String, String> headerMap = new HashMap<String, String>();
    boolean enabled;
    String username;
    char[] password;
    private EventSender eventSender;
    private static final Log log = LogFactory.getLog(ApimOauthEventInterceptor.class);

    public ApimOauthEventInterceptor() {
        super.init(this.initConfig);
        String endpointProperty = this.properties.getProperty("notification_endpoint");
        String usernameProperty = this.properties.getProperty("username");
        String passwordProperty = this.properties.getProperty("password");
        if (StringUtils.isNotEmpty((String)endpointProperty)) {
            this.enabled = true;
            this.notificationEndpoint = NotificationUtil.replaceSystemProperty(endpointProperty);
            this.headerMap.putAll(NotificationUtil.extractHeadersMapFromProperties(this.properties));
            if (StringUtils.isNotEmpty((String)usernameProperty) && StringUtils.isNotEmpty((String)passwordProperty)) {
                this.username = NotificationUtil.replaceSystemProperty(usernameProperty);
                this.password = NotificationUtil.replaceSystemProperty(passwordProperty).toCharArray();
                this.eventSender = new EventSender(this.notificationEndpoint, this.username, String.valueOf(this.password), this.headerMap);
            } else {
                this.eventSender = new EventSender(this.notificationEndpoint, this.headerMap);
            }
        }
    }

    public void onPostTokenRevocationByClient(org.wso2.carbon.identity.oauth2.dto.OAuthRevocationRequestDTO revokeRequestDTO, OAuthRevocationResponseDTO revokeResponseDTO, AccessTokenDO accessTokenDO, RefreshTokenValidationDataDO refreshTokenDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        if (this.enabled && accessTokenDO != null) {
            try {
                long expiryTime = accessTokenDO.getIssuedTime().getTime() + accessTokenDO.getValidityPeriodInMillis();
                String accessToken = accessTokenDO.getAccessToken();
                String user = accessTokenDO.getAuthzUser().getUserName();
                int tenantID = accessTokenDO.getTenantID();
                String tenantDomain = ServiceReferenceHolder.getInstance().getRealmService().getTenantManager().getDomain(tenantID);
                OAuthAppDO oauthApp = OAuth2Util.getAppInformationByClientId((String)accessTokenDO.getConsumerKey());
                String tokenType = oauthApp.getTokenType();
                TokenRevocationEvent tokenRevocationEvent = new TokenRevocationEvent(accessToken, expiryTime, user, accessTokenDO.getConsumerKey(), tokenType);
                tokenRevocationEvent.setTenantId(tenantID);
                tokenRevocationEvent.setTenantDomain(tenantDomain);
                this.publishEvent(tokenRevocationEvent);
            }
            catch (InvalidOAuthClientException e) {
                log.error((Object)"Error while retrieving token type", (Throwable)e);
            }
            catch (UserStoreException e) {
                log.error((Object)"Error while resolving tenantDomain", (Throwable)e);
            }
        }
    }

    public void onPostTokenRevocationByResourceOwner(OAuthRevocationRequestDTO revokeRequestDTO, org.wso2.carbon.identity.oauth.dto.OAuthRevocationResponseDTO revokeRespDTO, AccessTokenDO accessTokenDO, Map<String, Object> params) throws IdentityOAuth2Exception {
        if (this.enabled && accessTokenDO != null) {
            try {
                long expiryTime = accessTokenDO.getIssuedTime().getTime() + accessTokenDO.getValidityPeriodInMillis();
                String accessToken = accessTokenDO.getAccessToken();
                String user = accessTokenDO.getAuthzUser().getUserName();
                OAuthAppDO oauthApp = OAuth2Util.getAppInformationByClientId((String)accessTokenDO.getConsumerKey());
                String tokenType = oauthApp.getTokenType();
                TokenRevocationEvent tokenRevocationEvent = new TokenRevocationEvent(accessToken, expiryTime, user, accessTokenDO.getConsumerKey(), tokenType);
                this.publishEvent(tokenRevocationEvent);
            }
            catch (InvalidOAuthClientException e) {
                log.error((Object)"Error while retrieving token type", (Throwable)e);
            }
        }
    }

    private void publishEvent(TokenRevocationEvent tokenRevocationEvent) {
        if (this.isEnabled() && StringUtils.isNotEmpty((String)this.notificationEndpoint)) {
            this.eventSender.publishEvent(tokenRevocationEvent);
        }
    }
}

