/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.notification;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.json.JSONObject;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.identity.oauth.event.AbstractOAuthEventInterceptor;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class APIMTokenExchangeAuditLogger
extends AbstractOAuthEventInterceptor {
    private static final Log audit = CarbonConstants.AUDIT_LOG;

    public APIMTokenExchangeAuditLogger() {
        super.init(this.initConfig);
    }

    public void onPostTokenIssue(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO, OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> params) {
        if (!APIMTokenExchangeAuditLogger.isTokenExchangeGrant(tokenReqDTO)) {
            return;
        }
        if (this.isTokenRequestSuccessful(tokenRespDTO)) {
            JSONObject entityInfo = APIMTokenExchangeAuditLogger.constructEntityInfo(tokenReqDTO, tokenRespDTO);
            APIMTokenExchangeAuditLogger.logAuditMessage(entityInfo, tokReqMsgCtx.getAuthorizedUser().getUserName());
        }
    }

    private static void logAuditMessage(JSONObject entityInfo, String performedBy) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("typ", (Object)"Token Generation");
        jsonObject.put("action", (Object)"Token Exchange");
        jsonObject.put("performedBy", (Object)performedBy);
        jsonObject.put("info", (Object)entityInfo);
        audit.info((Object)StringEscapeUtils.unescapeJava((String)jsonObject.toString()));
    }

    private static Map<String, String> getRequestParams(RequestParameter[] params) {
        return Arrays.stream(params).collect(Collectors.toMap(RequestParameter::getKey, requestParam -> requestParam.getValue()[0]));
    }

    private static JSONObject getJWTClaims(String jwtToken) {
        JSONObject entityInfo = new JSONObject();
        try {
            SignedJWT signedJWT;
            if (StringUtils.isNotEmpty((String)jwtToken) && (signedJWT = SignedJWT.parse((String)jwtToken)).getJWTClaimsSet() != null) {
                JWTClaimsSet claimsSet = signedJWT.getJWTClaimsSet();
                entityInfo.put("issuer", (Object)claimsSet.getIssuer());
                entityInfo.put("audience", claimsSet.getAudience() != null ? claimsSet.getAudience() : "");
                entityInfo.put("jti", (Object)(claimsSet.getJWTID() != null ? claimsSet.getJWTID() : ""));
                entityInfo.put("iat", claimsSet.getIssueTime().getTime());
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return entityInfo;
    }

    private static boolean isJWT(String subjectTokenType, String subjectToken) {
        return "urn:ietf:params:oauth:token-type:jwt".equals(subjectTokenType) || "urn:ietf:params:oauth:token-type:access_token".equals(subjectTokenType) && OAuth2Util.isJWT((String)subjectToken);
    }

    private static boolean isTokenExchangeGrant(OAuth2AccessTokenReqDTO tokenReqDTO) {
        return "urn:ietf:params:oauth:grant-type:token-exchange".equals(tokenReqDTO.getGrantType());
    }

    private boolean isTokenRequestSuccessful(OAuth2AccessTokenRespDTO tokenRespDTO) {
        return !tokenRespDTO.isError();
    }

    private static String getRequestedTokenType(Map<String, String> requestParams) {
        if (requestParams.get("requested_token_type") != null) {
            return requestParams.get("requested_token_type");
        }
        return "urn:ietf:params:oauth:token-type:jwt";
    }

    private static JSONObject constructEntityInfo(OAuth2AccessTokenReqDTO tokenReqDTO, OAuth2AccessTokenRespDTO tokenRespDTO) {
        JSONObject entityInfo = new JSONObject();
        Map<String, String> requestParams = APIMTokenExchangeAuditLogger.getRequestParams(tokenReqDTO.getRequestParameters());
        entityInfo.put("client_id", (Object)tokenReqDTO.getClientId());
        entityInfo.put("grant_type", (Object)tokenReqDTO.getGrantType());
        entityInfo.put("requested_token_type", (Object)APIMTokenExchangeAuditLogger.getRequestedTokenType(requestParams));
        if (APIMTokenExchangeAuditLogger.isJWT(requestParams.get("subject_token_type"), requestParams.get("subject_token"))) {
            entityInfo.put("subject_token_info", (Object)APIMTokenExchangeAuditLogger.getJWTClaims(requestParams.get("subject_token")));
        }
        entityInfo.put("issued_token_info", (Object)APIMTokenExchangeAuditLogger.getJWTClaims(tokenRespDTO.getAccessToken()));
        return entityInfo;
    }
}

