/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.notification;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.config.RealmConfigXMLProcessor;
import org.wso2.is.notification.internal.ServiceReferenceHolder;

public class NotificationUtil {
    private static final Log log = LogFactory.getLog(NotificationUtil.class);

    private NotificationUtil() {
    }

    public static Map<String, String> extractHeadersMapFromProperties(Properties properties) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<Object, Object> propertiesEntry : properties.entrySet()) {
            String key = (String)propertiesEntry.getKey();
            String value = (String)propertiesEntry.getValue();
            if (!key.startsWith("header.")) continue;
            headers.put(key.split("header.")[1], NotificationUtil.replaceSystemProperty(value));
        }
        return headers;
    }

    public static String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf("}")) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue == null) {
                if ("carbon.context".equals(sysProp)) {
                    propValue = ServiceReferenceHolder.getInstance().getContextService().getServerConfigContext().getContextRoot();
                } else if ("admin.username".equals(sysProp) || "admin.password".equals(sysProp)) {
                    try {
                        RealmConfiguration realmConfig = new RealmConfigXMLProcessor().buildRealmConfigurationFromFile();
                        propValue = "admin.username".equals(sysProp) ? realmConfig.getAdminUserName() : realmConfig.getAdminPassword();
                    }
                    catch (UserStoreException e) {
                        log.error((Object)"Unable to build the Realm Configuration", (Throwable)e);
                        return null;
                    }
                }
            }
            if (propValue != null) {
                text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
            }
            if (!"carbon.home".equals(sysProp) || !".".equals(propValue)) continue;
            text = new File(".").getAbsolutePath() + File.separator + text;
        }
        return text;
    }
}

