/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.is.notification;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.wso2.is.notification.event.Event;

public class EventSender {
    private static final Log log = LogFactory.getLog(EventSender.class);
    private String notificationEndpoint;
    private String username;
    private char[] password;
    private Map<String, String> headers;
    private static final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(200, 500, 100L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingDeque<Runnable>(){});

    public EventSender(String notificationEndpoint, String userName, String password, Map<String, String> headers) {
        this.notificationEndpoint = notificationEndpoint;
        this.username = userName;
        this.password = password.toCharArray();
        this.headers = headers;
    }

    public EventSender(String notificationEndpoint, Map<String, String> headers) {
        this.notificationEndpoint = notificationEndpoint;
        this.headers = headers;
    }

    public void publishEvent(Event event) {
        EventRunner eventRunner = new EventRunner(this.notificationEndpoint, this.username, String.valueOf(this.password), this.headers, event);
        threadPoolExecutor.execute(eventRunner);
    }

    public static class EventRunner
    implements Runnable {
        private String notificationEndpoint;
        private String username;
        private String password;
        private Map<String, String> headers;
        private Event event;

        public EventRunner(String notificationEndpoint, String username, String password, Map<String, String> headers, Event event) {
            this.notificationEndpoint = notificationEndpoint;
            this.username = username;
            this.password = password;
            this.headers = headers;
            this.event = event;
        }

        @Override
        public void run() {
            try (CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().useSystemProperties().build();){
                HttpPost httpPost = new HttpPost(this.notificationEndpoint);
                if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                    byte[] credentials = Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8));
                    httpPost.addHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
                }
                this.headers.forEach((key, value) -> httpPost.addHeader(key, value));
                String content = new Gson().toJson((Object)this.event);
                StringEntity requestEntity = new StringEntity(content);
                requestEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)requestEntity);
                CloseableHttpResponse execute = closeableHttpClient.execute((HttpUriRequest)httpPost);
                Throwable throwable = null;
                if (execute != null) {
                    if (throwable != null) {
                        try {
                            execute.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        execute.close();
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)("Error while sending Revocation Event to " + this.notificationEndpoint), (Throwable)e);
            }
        }
    }
}

