/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.samples.deployablejarinterceptorservice;

import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;
import org.wso2.msf4j.interceptor.annotation.ResponseInterceptor;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.samples.deployablejarinterceptorservice.interceptors.HTTPRequestLogger;
import org.wso2.msf4j.samples.deployablejarinterceptorservice.interceptors.HTTPResponseLogger;
import org.wso2.msf4j.samples.deployablejarinterceptorservice.interceptors.LogTextRequestInterceptor;
import org.wso2.msf4j.samples.deployablejarinterceptorservice.interceptors.LogTextResponseInterceptor;
import org.wso2.msf4j.samples.deployablejarinterceptorservice.interceptors.PropertyAddRequestInterceptor;
import org.wso2.msf4j.samples.deployablejarinterceptorservice.interceptors.PropertyGetResponseInterceptor;

@Path(value="/interceptor-service")
public class InterceptorService
implements Microservice {
    private static final Logger log = LoggerFactory.getLogger(InterceptorService.class);

    public InterceptorService() {
        Map microservicesRegistryMap = DataHolder.getInstance().getMicroservicesRegistries();
        MicroservicesRegistryImpl microServicesRegistry = (MicroservicesRegistryImpl)microservicesRegistryMap.get("CHANNEL_ID");
        if (microServicesRegistry != null) {
            this.addInterceptorsToRegistry(microServicesRegistry);
        } else {
            microservicesRegistryMap.values().forEach(this::addInterceptorsToRegistry);
        }
    }

    @GET
    @Path(value="/service-name")
    @RequestInterceptor(value={HTTPRequestLogger.class, LogTextRequestInterceptor.class})
    @ResponseInterceptor(value={HTTPResponseLogger.class, LogTextResponseInterceptor.class})
    public String getServiceName() {
        log.info("HTTP Method Execution - getServiceName()");
        return "Interceptor example micro-service";
    }

    private void addInterceptorsToRegistry(MicroservicesRegistryImpl microServicesRegistry) {
        microServicesRegistry.addGlobalRequestInterceptor(new org.wso2.msf4j.interceptor.RequestInterceptor[]{new LogTextRequestInterceptor(), new PropertyAddRequestInterceptor()});
        microServicesRegistry.addGlobalResponseInterceptor(new org.wso2.msf4j.interceptor.ResponseInterceptor[]{new LogTextResponseInterceptor(), new PropertyGetResponseInterceptor()});
    }
}

