/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.cache;

import com.hazelcast.sql.impl.plan.cache.CacheablePlan;
import com.hazelcast.sql.impl.plan.cache.CachedPlanInvalidationCallback;
import com.hazelcast.sql.impl.plan.cache.PlanCacheKey;
import com.hazelcast.sql.impl.plan.cache.PlanCheckContext;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class PlanCache
implements CachedPlanInvalidationCallback {
    private final int maxSize;
    private final ConcurrentHashMap<PlanCacheKey, CacheablePlan> plans = new ConcurrentHashMap();

    public PlanCache(int maxSize) {
        assert (maxSize > 0);
        this.maxSize = maxSize;
    }

    public CacheablePlan get(PlanCacheKey key) {
        CacheablePlan plan = this.plans.get(key);
        if (plan != null) {
            plan.onPlanUsed();
            return plan;
        }
        return null;
    }

    public void put(PlanCacheKey key, CacheablePlan plan) {
        this.plans.put(key, plan);
        plan.onPlanUsed();
        this.shrinkIfNeeded();
    }

    @Override
    public void invalidate(CacheablePlan plan) {
        this.remove(plan);
    }

    public void clear() {
        this.plans.clear();
    }

    public int size() {
        return this.plans.size();
    }

    public void check(PlanCheckContext context) {
        this.plans.values().removeIf(plan -> !plan.isPlanValid(context));
    }

    private void shrinkIfNeeded() {
        boolean removed;
        CacheablePlan plan2;
        int oversize = this.plans.size() - this.maxSize;
        if (oversize <= 0) {
            return;
        }
        TreeMap<Long, CacheablePlan> sorted = new TreeMap<Long, CacheablePlan>();
        for (CacheablePlan plan2 : this.plans.values()) {
            sorted.put(plan2.getPlanLastUsed(), plan2);
        }
        Iterator<CacheablePlan> iterator = sorted.values().iterator();
        while (iterator.hasNext() && (!(removed = this.remove(plan2 = iterator.next())) || --oversize != 0)) {
        }
    }

    private boolean remove(CacheablePlan plan) {
        return this.plans.remove(plan.getPlanKey(), plan);
    }

    public ConcurrentHashMap<PlanCacheKey, CacheablePlan> getPlans() {
        return this.plans;
    }
}

