/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.db2.Db2ChangeEventSourceFactory;
import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2Connector;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2EventMetadataProvider;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.connector.db2.Db2TaskContext;
import io.debezium.connector.db2.Db2ValueConverters;
import io.debezium.connector.db2.Module;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.DefaultChangeEventSourceMetricsFactory;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.relational.TableId;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.Clock;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2ConnectorTask
extends BaseSourceTask<Db2Partition, Db2OffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2ConnectorTask.class);
    private static final String CONTEXT_NAME = "db2-server-connector-task";
    private volatile Db2TaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile Db2Connection dataConnection;
    private volatile Db2Connection metadataConnection;
    private volatile ErrorHandler errorHandler;
    private volatile Db2DatabaseSchema schema;

    @Override
    public String version() {
        return Module.version();
    }

    @Override
    public ChangeEventSourceCoordinator<Db2Partition, Db2OffsetContext> start(Configuration config) {
        Db2ConnectorConfig connectorConfig = new Db2ConnectorConfig(Db2ConnectorTask.applyFetchSizeToJdbcConfig(config));
        TopicNamingStrategy topicNamingStrategy = connectorConfig.getTopicNamingStrategy(CommonConnectorConfig.TOPIC_NAMING_STRATEGY);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjustmentMode().createAdjuster();
        this.dataConnection = new Db2Connection(connectorConfig.getJdbcConfig());
        this.metadataConnection = new Db2Connection(connectorConfig.getJdbcConfig());
        try {
            this.dataConnection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new ConnectException(e);
        }
        Db2ValueConverters valueConverters = new Db2ValueConverters(connectorConfig.getDecimalMode(), connectorConfig.getTemporalPrecisionMode());
        this.schema = new Db2DatabaseSchema(connectorConfig, valueConverters, schemaNameAdjuster, topicNamingStrategy, this.dataConnection);
        this.schema.initializeStorage();
        Offsets<Db2Partition, Db2OffsetContext> previousOffsets = this.getPreviousOffsets(new Db2Partition.Provider(connectorConfig), new Db2OffsetContext.Loader(connectorConfig));
        Db2Partition partition = previousOffsets.getTheOnlyPartition();
        Db2OffsetContext previousOffset = previousOffsets.getTheOnlyOffset();
        if (previousOffset != null) {
            this.schema.recover(partition, previousOffset);
        }
        this.taskContext = new Db2TaskContext(connectorConfig, this.schema);
        Clock clock = Clock.system();
        this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
        this.errorHandler = new ErrorHandler(Db2Connector.class, connectorConfig, this.queue);
        Db2EventMetadataProvider metadataProvider = new Db2EventMetadataProvider();
        EventDispatcher<Db2Partition, TableId> dispatcher = new EventDispatcher<Db2Partition, TableId>(connectorConfig, topicNamingStrategy, this.schema, this.queue, connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, metadataProvider, schemaNameAdjuster);
        ChangeEventSourceCoordinator<Db2Partition, Db2OffsetContext> coordinator = new ChangeEventSourceCoordinator<Db2Partition, Db2OffsetContext>(previousOffsets, this.errorHandler, Db2Connector.class, connectorConfig, new Db2ChangeEventSourceFactory(connectorConfig, this.dataConnection, this.metadataConnection, this.errorHandler, dispatcher, clock, this.schema), new DefaultChangeEventSourceMetricsFactory(), dispatcher, this.schema);
        coordinator.start(this.taskContext, this.queue, metadataProvider);
        return coordinator;
    }

    @Override
    public List<SourceRecord> doPoll() throws InterruptedException {
        List<DataChangeEvent> records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        return sourceRecords;
    }

    @Override
    public void doStop() {
        block9: {
            try {
                if (this.dataConnection == null) break block9;
                if (this.dataConnection.isConnected()) {
                    try {
                        this.dataConnection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.dataConnection.close();
            }
            catch (SQLException e) {
                LOGGER.error("Exception while closing JDBC connection", (Throwable)e);
            }
        }
        try {
            if (this.metadataConnection != null) {
                this.metadataConnection.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Exception while closing JDBC metadata connection", (Throwable)e);
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    @Override
    protected Iterable<Field> getAllConfigurationFields() {
        return Db2ConnectorConfig.ALL_FIELDS;
    }

    private static Configuration applyFetchSizeToJdbcConfig(Configuration config) {
        if (config.getInteger(Db2ConnectorConfig.QUERY_FETCH_SIZE) > 0) {
            String driverPrefix = "driver.";
            return ((Configuration.Builder)config.edit().withDefault("driver.responseBuffering", "adaptive").withDefault("driver.fetchSize", config.getInteger(Db2ConnectorConfig.QUERY_FETCH_SIZE))).build();
        }
        return config;
    }
}

