/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.connector.db2.Db2Connection;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Db2DatabaseSchema;
import io.debezium.connector.db2.Db2ObjectNameQuoter;
import io.debezium.connector.db2.Db2OffsetContext;
import io.debezium.connector.db2.Db2Partition;
import io.debezium.connector.db2.TxLogPosition;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Db2SnapshotChangeEventSource
extends RelationalSnapshotChangeEventSource<Db2Partition, Db2OffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Db2SnapshotChangeEventSource.class);
    private final Db2ConnectorConfig connectorConfig;
    private final Db2Connection jdbcConnection;

    public Db2SnapshotChangeEventSource(Db2ConnectorConfig connectorConfig, Db2Connection jdbcConnection, Db2DatabaseSchema schema, EventDispatcher<Db2Partition, TableId> dispatcher, Clock clock, SnapshotProgressListener<Db2Partition> snapshotProgressListener) {
        super(connectorConfig, jdbcConnection, schema, dispatcher, clock, snapshotProgressListener);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
    }

    @Override
    protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(Db2Partition partition, Db2OffsetContext previousOffset) {
        boolean snapshotSchema = true;
        boolean snapshotData = true;
        if (previousOffset != null && !previousOffset.isSnapshotRunning()) {
            LOGGER.info("A previous offset indicating a completed snapshot has been found. Neither schema nor data will be snapshotted.");
            snapshotSchema = false;
            snapshotData = false;
        } else {
            LOGGER.info("No previous offset has been found");
            if (this.connectorConfig.getSnapshotMode().includeData()) {
                LOGGER.info("According to the connector configuration both schema and data will be snapshotted");
            } else {
                LOGGER.info("According to the connector configuration only schema will be snapshotted");
            }
            snapshotData = this.connectorConfig.getSnapshotMode().includeData();
        }
        return new AbstractSnapshotChangeEventSource.SnapshottingTask(snapshotSchema, snapshotData);
    }

    @Override
    protected AbstractSnapshotChangeEventSource.SnapshotContext<Db2Partition, Db2OffsetContext> prepare(Db2Partition partition) throws Exception {
        return new Db2SnapshotContext(partition, this.jdbcConnection.getRealDatabaseName());
    }

    @Override
    protected void connectionCreated(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) throws Exception {
        ((Db2SnapshotContext)snapshotContext).isolationLevelBeforeStart = this.jdbcConnection.connection().getTransactionIsolation();
    }

    @Override
    protected Set<TableId> getAllTableIds(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> ctx) throws Exception {
        return this.jdbcConnection.readTableNames(null, null, null, new String[]{"TABLE"});
    }

    @Override
    protected void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) throws SQLException, InterruptedException {
        if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.READ_UNCOMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(1);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.READ_COMMITTED) {
            this.jdbcConnection.connection().setTransactionIsolation(2);
            LOGGER.info("Schema locking was disabled in connector configuration");
        } else if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.EXCLUSIVE || this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().setTransactionIsolation(4);
            ((Db2SnapshotContext)snapshotContext).preSchemaSnapshotSavepoint = this.jdbcConnection.connection().setSavepoint("db2_schema_snapshot");
            LOGGER.info("Executing schema locking");
            try (Statement statement = this.jdbcConnection.connection().createStatement(1003, 1007);){
                for (TableId tableId : snapshotContext.capturedTables) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while locking table " + tableId);
                    }
                    LOGGER.info("Locking table {}", (Object)tableId);
                    String query = String.format("SELECT * FROM %s.%s WHERE 0=1 WITH CS", Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.schema()), Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.table()));
                    statement.executeQuery(query).close();
                }
            }
        } else {
            throw new IllegalStateException("Unknown locking mode specified.");
        }
    }

    @Override
    protected void releaseSchemaSnapshotLocks(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) throws SQLException {
        if (this.connectorConfig.getSnapshotIsolationMode() == Db2ConnectorConfig.SnapshotIsolationMode.REPEATABLE_READ) {
            this.jdbcConnection.connection().rollback(((Db2SnapshotContext)snapshotContext).preSchemaSnapshotSavepoint);
            LOGGER.info("Schema locks released.");
        }
    }

    @Override
    protected void determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> ctx, Db2OffsetContext previousOffset) throws Exception {
        ctx.offset = new Db2OffsetContext(this.connectorConfig, TxLogPosition.valueOf(this.jdbcConnection.getMaxLsn()), false, false);
    }

    @Override
    protected void readTableStructure(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext, Db2OffsetContext previousOffset) throws SQLException, InterruptedException {
        Set schemas = snapshotContext.capturedTables.stream().map(TableId::schema).collect(Collectors.toSet());
        for (String schema : schemas) {
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while reading structure of schema " + schema);
            }
            LOGGER.info("Reading structure of schema '{}'", (Object)schema);
            this.jdbcConnection.readSchema(snapshotContext.tables, null, schema, this.connectorConfig.getTableFilters().dataCollectionFilter(), null, false);
        }
    }

    @Override
    protected SchemaChangeEvent getCreateTableEvent(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext, Table table) throws SQLException {
        return SchemaChangeEvent.ofSnapshotCreate(snapshotContext.partition, snapshotContext.offset, snapshotContext.catalogName, table);
    }

    @Override
    protected void complete(AbstractSnapshotChangeEventSource.SnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext) {
        try {
            this.jdbcConnection.connection().setTransactionIsolation(((Db2SnapshotContext)snapshotContext).isolationLevelBeforeStart);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to set transaction isolation level.", e);
        }
    }

    @Override
    protected Optional<String> getSnapshotSelect(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> snapshotContext, TableId tableId, List<String> columns) {
        String snapshotSelectColumns = columns.stream().collect(Collectors.joining(", "));
        return Optional.of(String.format("SELECT %s FROM %s.%s", snapshotSelectColumns, Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.schema()), Db2ObjectNameQuoter.quoteNameIfNecessary(tableId.table())));
    }

    private static class Db2SnapshotContext
    extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<Db2Partition, Db2OffsetContext> {
        private int isolationLevelBeforeStart;
        private Savepoint preSchemaSnapshotSavepoint;

        Db2SnapshotContext(Db2Partition partition, String catalogName) throws SQLException {
            super(partition, catalogName);
        }
    }
}

