/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.db2.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class Db2SourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.db2.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("change_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_lsn", Schema.OPTIONAL_STRING_SCHEMA).build();

    public Db2SourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    @Override
    public Schema schema() {
        return this.schema;
    }

    @Override
    public Struct struct(SourceInfo sourceInfo) {
        Struct ret = super.commonStruct(sourceInfo).put("schema", (Object)sourceInfo.getTableId().schema()).put("table", (Object)sourceInfo.getTableId().table());
        if (sourceInfo.getChangeLsn() != null && sourceInfo.getChangeLsn().isAvailable()) {
            ret.put("change_lsn", (Object)sourceInfo.getChangeLsn().toString());
        }
        if (sourceInfo.getCommitLsn() != null && sourceInfo.getCommitLsn().isAvailable()) {
            ret.put("commit_lsn", (Object)sourceInfo.getCommitLsn().toString());
        }
        return ret;
    }
}

