/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.db2;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.db2.Db2ConnectorConfig;
import io.debezium.connector.db2.Lsn;
import io.debezium.relational.TableId;
import java.time.Instant;

@NotThreadSafe
public class SourceInfo
extends BaseSourceInfo {
    public static final String CHANGE_LSN_KEY = "change_lsn";
    public static final String COMMIT_LSN_KEY = "commit_lsn";
    private Lsn changeLsn;
    private Lsn commitLsn;
    private Instant sourceTime;
    private TableId tableId;
    private String databaseName;

    protected SourceInfo(Db2ConnectorConfig connectorConfig) {
        super(connectorConfig);
        this.databaseName = connectorConfig.getDatabaseName();
    }

    public void setChangeLsn(Lsn lsn) {
        this.changeLsn = lsn;
    }

    public Lsn getChangeLsn() {
        return this.changeLsn;
    }

    public Lsn getCommitLsn() {
        return this.commitLsn;
    }

    public void setCommitLsn(Lsn commitLsn) {
        this.commitLsn = commitLsn;
    }

    public void setSourceTime(Instant instant) {
        this.sourceTime = instant;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public void setTableId(TableId tableId) {
        this.tableId = tableId;
    }

    public String toString() {
        return "SourceInfo [serverName=" + this.serverName() + ", changeLsn=" + this.changeLsn + ", commitLsn=" + this.commitLsn + ", snapshot=" + this.snapshotRecord + ", sourceTime=" + this.sourceTime + "]";
    }

    @Override
    protected Instant timestamp() {
        return this.sourceTime;
    }

    @Override
    protected String database() {
        return this.databaseName;
    }
}

