/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.antlr;

import com.mysql.cj.CharsetMapping;
import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.mysql.MySqlSystemVariables;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.connector.mysql.antlr.listener.MySqlAntlrDdlParserListener;
import io.debezium.ddl.parser.mysql.generated.MySqlLexer;
import io.debezium.ddl.parser.mysql.generated.MySqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.AbstractDdlParser;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class MySqlAntlrDdlParser
extends AntlrDdlParser<MySqlLexer, MySqlParser> {
    private final ConcurrentMap<String, String> charsetNameForDatabase = new ConcurrentHashMap<String, String>();
    private final MySqlValueConverters converters;
    private final Tables.TableFilter tableFilter;

    public MySqlAntlrDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters) {
        this(converters, Tables.TableFilter.includeAll());
    }

    public MySqlAntlrDdlParser(MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        this(true, false, false, converters, tableFilter);
    }

    public MySqlAntlrDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, boolean includeComments, MySqlValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews, includeComments);
        this.systemVariables = new MySqlSystemVariables();
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    protected ParseTree parseTree(MySqlParser parser) {
        return parser.root();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new MySqlAntlrDdlParserListener(this);
    }

    @Override
    protected MySqlLexer createNewLexerInstance(CharStream charStreams) {
        return new MySqlLexer(charStreams);
    }

    @Override
    protected MySqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new MySqlParser((TokenStream)commonTokenStream);
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return new MySqlSystemVariables();
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.StringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 222), new DataTypeResolver.DataTypeEntry(12, 222, 238), new DataTypeResolver.DataTypeEntry(12, 223), new DataTypeResolver.DataTypeEntry(12, 233), new DataTypeResolver.DataTypeEntry(12, 234), new DataTypeResolver.DataTypeEntry(12, 235), new DataTypeResolver.DataTypeEntry(12, 236), new DataTypeResolver.DataTypeEntry(12, 231), new DataTypeResolver.DataTypeEntry(-15, 518), new DataTypeResolver.DataTypeEntry(-9, 518, 238), new DataTypeResolver.DataTypeEntry(-9, 224), new DataTypeResolver.DataTypeEntry(1, 222, 226), new DataTypeResolver.DataTypeEntry(12, 223, 226), new DataTypeResolver.DataTypeEntry(12, 233, 226), new DataTypeResolver.DataTypeEntry(12, 234, 226), new DataTypeResolver.DataTypeEntry(12, 235, 226), new DataTypeResolver.DataTypeEntry(12, 236, 226), new DataTypeResolver.DataTypeEntry(-15, 518, 226), new DataTypeResolver.DataTypeEntry(-9, 224, 226), new DataTypeResolver.DataTypeEntry(1, 25), new DataTypeResolver.DataTypeEntry(12, 25, 238)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 225, 223).setSuffixTokens(226), new DataTypeResolver.DataTypeEntry(-15, 225, 25).setSuffixTokens(226), new DataTypeResolver.DataTypeEntry(-9, 518, 223).setSuffixTokens(226)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.NationalVaryingStringDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(-9, 225, 222, 238), new DataTypeResolver.DataTypeEntry(-9, 225, 25, 238)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.DimensionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(5, 196).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(5, 201).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(5, 197).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(5, 202).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(4, 198).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(4, 203).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(4, 199).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(4, 200).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(4, 206).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(4, 204).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(-5, 207).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(-5, 205).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(7, 208).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(8, 209).setSuffixTokens(210, 612, 183, 195), new DataTypeResolver.DataTypeEntry(8, 213).setSuffixTokens(210, 612, 183, 195), new DataTypeResolver.DataTypeEntry(6, 211).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(6, 212).setSuffixTokens(612, 183, 195), new DataTypeResolver.DataTypeEntry(3, 214).setSuffixTokens(612, 183, 195).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 215).setSuffixTokens(612, 183, 195).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(3, 431).setSuffixTokens(612, 183, 195).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(2, 216).setSuffixTokens(612, 183, 195).setDefaultLengthScaleDimension(10, 0), new DataTypeResolver.DataTypeEntry(-7, 346), new DataTypeResolver.DataTypeEntry(92, 218), new DataTypeResolver.DataTypeEntry(2014, 219), new DataTypeResolver.DataTypeEntry(93, 220), new DataTypeResolver.DataTypeEntry(-2, 226), new DataTypeResolver.DataTypeEntry(-3, 227), new DataTypeResolver.DataTypeEntry(2004, 229), new DataTypeResolver.DataTypeEntry(4, 221)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SimpleDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(91, 217), new DataTypeResolver.DataTypeEntry(2004, 228), new DataTypeResolver.DataTypeEntry(2004, 230), new DataTypeResolver.DataTypeEntry(2004, 232), new DataTypeResolver.DataTypeEntry(16, 348), new DataTypeResolver.DataTypeEntry(16, 349), new DataTypeResolver.DataTypeEntry(-5, 239)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.CollectionDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1, 237).setSuffixTokens(226), new DataTypeResolver.DataTypeEntry(1, 153).setSuffixTokens(226)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.SpatialDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(1111, 802), new DataTypeResolver.DataTypeEntry(1111, 803), new DataTypeResolver.DataTypeEntry(1111, 805), new DataTypeResolver.DataTypeEntry(1111, 806), new DataTypeResolver.DataTypeEntry(1111, 807), new DataTypeResolver.DataTypeEntry(1111, 808), new DataTypeResolver.DataTypeEntry(1111, 809), new DataTypeResolver.DataTypeEntry(1111, 810), new DataTypeResolver.DataTypeEntry(1111, 466), new DataTypeResolver.DataTypeEntry(1111, 804)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarbinaryDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2004, 231).setSuffixTokens(227)));
        dataTypeResolverBuilder.registerDataTypes(MySqlParser.LongVarcharDataTypeContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(12, 231).setSuffixTokens(223)));
        return dataTypeResolverBuilder.build();
    }

    public ConcurrentMap<String, String> charsetNameForDatabase() {
        return this.charsetNameForDatabase;
    }

    public String parseName(MySqlParser.UidContext uidContext) {
        return this.withoutQuotes(uidContext);
    }

    public TableId parseQualifiedTableId(MySqlParser.FullIdContext fullIdContext) {
        char[] fullTableName = fullIdContext.getText().toCharArray();
        StringBuilder component = new StringBuilder();
        String dbName = null;
        String tableName = null;
        boolean EMPTY = false;
        char lastQuote = '\u0000';
        for (int i = 0; i < fullTableName.length; ++i) {
            char c = fullTableName[i];
            if (MySqlAntlrDdlParser.isQuote(c)) {
                if (lastQuote == '\u0000') {
                    lastQuote = c;
                    continue;
                }
                if (lastQuote == c) {
                    if (i < fullTableName.length - 1 && fullTableName[i + 1] == c) {
                        component.append(c);
                        ++i;
                        continue;
                    }
                    lastQuote = '\u0000';
                    continue;
                }
                component.append(c);
                continue;
            }
            if (c == '.' && lastQuote == '\u0000') {
                dbName = component.toString();
                component = new StringBuilder();
                continue;
            }
            component.append(c);
        }
        tableName = component.toString();
        return this.resolveTableId(dbName != null ? dbName : this.currentSchema(), tableName);
    }

    public void parsePrimaryIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<String> pkColumnNames = indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : (indexColumnNameContext.STRING_LITERAL() != null ? MySqlAntlrDdlParser.withoutQuotes(indexColumnNameContext.STRING_LITERAL().getText()) : indexColumnNameContext.expression().getText());
            Column column = tableEditor.columnWithName(columnName);
            if (column != null && column.isOptional()) {
                ColumnEditor ce = column.edit().optional(false);
                if (ce.hasDefaultValue() && !ce.defaultValueExpression().isPresent()) {
                    ce.unsetDefaultValueExpression();
                }
                tableEditor.addColumn(ce.create());
            }
            return column != null ? column.name() : columnName;
        }).collect(Collectors.toList());
        tableEditor.setPrimaryKeyNames(pkColumnNames);
    }

    public void parseUniqueIndexColumnNames(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        List<Column> indexColumns = this.getIndexColumns(indexColumnNamesContext, tableEditor);
        if (indexColumns.stream().filter(col -> Objects.isNull(col) || col.isOptional()).count() > 0L) {
            this.logger.warn("Skip to set unique index columns {} to primary key which including optional columns", indexColumns);
        } else {
            tableEditor.setPrimaryKeyNames(indexColumns.stream().map(Column::name).collect(Collectors.toList()));
        }
    }

    public boolean isTableUniqueIndexIncluded(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        return this.getIndexColumns(indexColumnNamesContext, tableEditor).stream().filter(Objects::isNull).count() == 0L;
    }

    private List<Column> getIndexColumns(MySqlParser.IndexColumnNamesContext indexColumnNamesContext, TableEditor tableEditor) {
        return indexColumnNamesContext.indexColumnName().stream().map(indexColumnNameContext -> {
            String columnName = indexColumnNameContext.uid() != null ? this.parseName(indexColumnNameContext.uid()) : (indexColumnNameContext.STRING_LITERAL() != null ? MySqlAntlrDdlParser.withoutQuotes(indexColumnNameContext.STRING_LITERAL().getText()) : indexColumnNameContext.expression().getText());
            return tableEditor.columnWithName(columnName);
        }).collect(Collectors.toList());
    }

    public String currentDatabaseCharset() {
        String charsetName = this.systemVariables.getVariable("character_set_database");
        if (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName)) {
            charsetName = this.systemVariables.getVariable("character_set_server");
        }
        return charsetName;
    }

    public String charsetForTable(TableId tableId) {
        String defaultDatabaseCharset = tableId.catalog() != null ? (String)this.charsetNameForDatabase().get(tableId.catalog()) : null;
        return defaultDatabaseCharset != null ? defaultDatabaseCharset : this.currentDatabaseCharset();
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public static List<String> extractEnumAndSetOptions(List<String> enumValues) {
        return enumValues.stream().map(AbstractDdlParser::withoutQuotes).map(MySqlAntlrDdlParser::escapeOption).collect(Collectors.toList());
    }

    public static String escapeOption(String option) {
        return option.replaceAll(",", "\\\\,").replaceAll("\\\\'", "'").replaceAll("''", "'");
    }

    public MySqlValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }

    public String extractCharset(MySqlParser.CharsetNameContext charsetNode, MySqlParser.CollationNameContext collationNode) {
        String charsetName = null;
        if (charsetNode != null && charsetNode.getText() != null) {
            charsetName = MySqlAntlrDdlParser.withoutQuotes(charsetNode.getText());
        } else if (collationNode != null && collationNode.getText() != null) {
            String collationName = MySqlAntlrDdlParser.withoutQuotes(collationNode.getText()).toLowerCase();
            for (int index = 0; index < 1024; ++index) {
                if (!collationName.equals(CharsetMapping.getStaticCollationNameForCollationIndex((Integer)index))) continue;
                charsetName = CharsetMapping.getStaticMysqlCharsetNameForCollationIndex((Integer)index);
                break;
            }
        }
        return charsetName;
    }
}

