/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.SchemaNameAdjuster;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleDatabaseSchema
extends HistorizedRelationalDatabaseSchema {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleDatabaseSchema.class);
    private final OracleDdlParser ddlParser;
    private final ConcurrentMap<TableId, List<Column>> lobColumnsByTableId = new ConcurrentHashMap<TableId, List<Column>>();
    private final OracleValueConverters valueConverters;
    private boolean storageInitializationExecuted = false;

    public OracleDatabaseSchema(OracleConnectorConfig connectorConfig, OracleValueConverters valueConverters, DefaultValueConverter defaultValueConverter, SchemaNameAdjuster schemaNameAdjuster, TopicNamingStrategy<TableId> topicNamingStrategy, StreamingAdapter.TableNameCaseSensitivity tableNameCaseSensitivity) {
        super(connectorConfig, topicNamingStrategy, connectorConfig.getTableFilters().dataCollectionFilter(), connectorConfig.getColumnFilter(), new TableSchemaBuilder(valueConverters, defaultValueConverter, schemaNameAdjuster, connectorConfig.customConverterRegistry(), connectorConfig.getSourceInfoStructMaker().schema(), connectorConfig.getSanitizeFieldNames(), false), StreamingAdapter.TableNameCaseSensitivity.INSENSITIVE.equals((Object)tableNameCaseSensitivity), connectorConfig.getKeyMapper());
        this.valueConverters = valueConverters;
        this.ddlParser = new OracleDdlParser(true, false, connectorConfig.isSchemaCommentsHistoryEnabled(), valueConverters, connectorConfig.getTableFilters().dataCollectionFilter());
    }

    public Tables getTables() {
        return this.tables();
    }

    public OracleValueConverters getValueConverters() {
        return this.valueConverters;
    }

    @Override
    public OracleDdlParser getDdlParser() {
        return this.ddlParser;
    }

    @Override
    public void applySchemaChange(SchemaChangeEvent schemaChange) {
        block7: {
            block6: {
                LOGGER.debug("Applying schema change event {}", (Object)schemaChange);
                switch (schemaChange.getType()) {
                    case CREATE: 
                    case ALTER: {
                        schemaChange.getTableChanges().forEach(x -> {
                            this.buildAndRegisterSchema(x.getTable());
                            this.tables().overwriteTable(x.getTable());
                        });
                        break;
                    }
                    case DROP: {
                        schemaChange.getTableChanges().forEach(x -> this.removeSchema(x.getId()));
                        break;
                    }
                }
                if (!this.schemaHistory.storeOnlyCapturedTables()) break block6;
                if (!schemaChange.getTables().stream().map(Table::id).anyMatch(this.getTableFilter()::isIncluded)) break block7;
            }
            LOGGER.debug("Recorded DDL statements for database '{}': {}", (Object)schemaChange.getDatabase(), (Object)schemaChange.getDdl());
            this.record(schemaChange, schemaChange.getTableChanges());
        }
    }

    @Override
    public void initializeStorage() {
        super.initializeStorage();
        this.storageInitializationExecuted = true;
    }

    public boolean isStorageInitializationExecuted() {
        return this.storageInitializationExecuted;
    }

    public boolean historyExists() {
        return this.schemaHistory.exists();
    }

    @Override
    protected void removeSchema(TableId id) {
        super.removeSchema(id);
        this.lobColumnsByTableId.remove(id);
    }

    @Override
    protected void buildAndRegisterSchema(Table table) {
        if (this.getTableFilter().isIncluded(table.id())) {
            super.buildAndRegisterSchema(table);
            this.buildAndRegisterTableLobColumns(table);
        }
    }

    public List<Column> getLobColumnsForTable(TableId id) {
        return this.lobColumnsByTableId.getOrDefault(id, Collections.emptyList());
    }

    public boolean isColumnUnavailableValuePlaceholder(Column column, Object value) {
        if (OracleDatabaseSchema.isClobColumn(column)) {
            return this.valueConverters.getUnavailableValuePlaceholderString().equals(value);
        }
        if (OracleDatabaseSchema.isBlobColumn(column)) {
            return ByteBuffer.wrap(this.valueConverters.getUnavailableValuePlaceholderBinary()).equals(value);
        }
        return false;
    }

    public static boolean isLobColumn(Column column) {
        return OracleDatabaseSchema.isClobColumn(column) || OracleDatabaseSchema.isBlobColumn(column);
    }

    private static boolean isClobColumn(Column column) {
        return column.jdbcType() == 2005 || column.jdbcType() == 2011;
    }

    private static boolean isBlobColumn(Column column) {
        return column.jdbcType() == 2004;
    }

    private void buildAndRegisterTableLobColumns(Table table) {
        ArrayList<Column> lobColumns = new ArrayList<Column>();
        for (Column column : table.columns()) {
            switch (column.jdbcType()) {
                case 2004: 
                case 2005: 
                case 2011: {
                    lobColumns.add(column);
                }
            }
        }
        if (!lobColumns.isEmpty()) {
            this.lobColumnsByTableId.put(table.id(), lobColumns);
        } else {
            this.lobColumnsByTableId.remove(table.id());
        }
    }
}

