/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.DefaultValueConverter;
import io.debezium.relational.ValueConverter;
import io.debezium.util.Strings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Immutable
public class OracleDefaultValueConverter
implements DefaultValueConverter {
    private static Logger LOGGER = LoggerFactory.getLogger(OracleDefaultValueConverter.class);
    private final OracleValueConverters valueConverters;
    private final Map<Integer, DefaultValueConverter.DefaultValueMapper> defaultValueMappers;

    public OracleDefaultValueConverter(OracleValueConverters valueConverters, OracleConnection jdbcConnection) {
        this.valueConverters = valueConverters;
        this.defaultValueMappers = Collections.unmodifiableMap(OracleDefaultValueConverter.createDefaultValueMappers(jdbcConnection));
    }

    @Override
    public Optional<Object> parseDefaultValue(Column column, String defaultValue) {
        int dataType = column.jdbcType();
        DefaultValueConverter.DefaultValueMapper mapper = this.defaultValueMappers.get(dataType);
        if (mapper == null) {
            LOGGER.warn("Mapper for type '{}' not found.", (Object)dataType);
            return Optional.empty();
        }
        try {
            Object rawDefaultValue = mapper.parse(column, defaultValue != null ? defaultValue.trim() : defaultValue);
            Object convertedDefaultValue = this.convertDefaultValue(rawDefaultValue, column);
            if (convertedDefaultValue instanceof Struct) {
                LOGGER.warn("Struct can't be used as default value for column '{}', will use null instead.", (Object)column.name());
                return Optional.empty();
            }
            return Optional.ofNullable(convertedDefaultValue);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse column default value '{}' to type '{}'.  Expression evaluation is not supported.", (Object)defaultValue, (Object)dataType);
            LOGGER.debug("Parsing failed due to error", (Throwable)e);
            return Optional.empty();
        }
    }

    private Object convertDefaultValue(Object defaultValue, Column column) {
        SchemaBuilder schemaBuilder;
        if (this.valueConverters != null && defaultValue != null && (schemaBuilder = this.valueConverters.schemaBuilder(column)) != null) {
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), -1, schema);
            ValueConverter valueConverter = this.valueConverters.converter(column, field);
            Object result = valueConverter.convert(defaultValue);
            if (result instanceof BigDecimal && column.scale().isPresent() && column.scale().get() > ((BigDecimal)result).scale()) {
                result = ((BigDecimal)result).setScale((int)column.scale().get(), RoundingMode.HALF_EVEN);
            }
            return result;
        }
        return defaultValue;
    }

    private static Map<Integer, DefaultValueConverter.DefaultValueMapper> createDefaultValueMappers(OracleConnection jdbcConnection) {
        HashMap<Integer, DefaultValueConverter.DefaultValueMapper> result = new HashMap<Integer, DefaultValueConverter.DefaultValueMapper>();
        result.put(2, OracleDefaultValueConverter.nullableDefaultValueMapper());
        result.put(100, OracleDefaultValueConverter.nullableDefaultValueMapper());
        result.put(101, OracleDefaultValueConverter.nullableDefaultValueMapper());
        result.put(6, OracleDefaultValueConverter.nullableDefaultValueMapper());
        result.put(91, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.castTemporalFunctionCall(jdbcConnection)));
        result.put(92, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.castTemporalFunctionCall(jdbcConnection)));
        result.put(93, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.castTemporalFunctionCall(jdbcConnection)));
        result.put(-101, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.castTemporalFunctionCall(jdbcConnection)));
        result.put(-102, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.castTemporalFunctionCall(jdbcConnection)));
        result.put(-103, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.convertIntervalYearMonthStringLiteral()));
        result.put(-104, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.convertIntervalDaySecondStringLiteral()));
        result.put(1, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.enforceCharFieldPadding()));
        result.put(12, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.enforceStringUnquote()));
        result.put(-15, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.enforceCharFieldPadding()));
        result.put(-9, OracleDefaultValueConverter.nullableDefaultValueMapper(OracleDefaultValueConverter.enforceStringUnquote()));
        return result;
    }

    private static DefaultValueConverter.DefaultValueMapper nullableDefaultValueMapper() {
        return OracleDefaultValueConverter.nullableDefaultValueMapper(null);
    }

    private static DefaultValueConverter.DefaultValueMapper nullableDefaultValueMapper(DefaultValueConverter.DefaultValueMapper mapper) {
        return (column, value) -> {
            if ("NULL".equalsIgnoreCase(value)) {
                return null;
            }
            if (mapper != null) {
                return mapper.parse(column, value);
            }
            return value;
        };
    }

    private static DefaultValueConverter.DefaultValueMapper convertIntervalDaySecondStringLiteral() {
        return (column, value) -> {
            if (value != null && value.length() > 2 && value.startsWith("'") && value.endsWith("'")) {
                return new INTERVALDS(value.substring(1, value.length() - 1));
            }
            return value;
        };
    }

    private static DefaultValueConverter.DefaultValueMapper convertIntervalYearMonthStringLiteral() {
        return (column, value) -> {
            if (value != null && value.length() > 2 && value.startsWith("'") && value.endsWith("'")) {
                return new INTERVALYM(value.substring(1, value.length() - 1));
            }
            return value;
        };
    }

    private static DefaultValueConverter.DefaultValueMapper enforceCharFieldPadding() {
        return (column, value) -> value != null ? Strings.pad(OracleDefaultValueConverter.unquote(value), column.length(), ' ') : null;
    }

    private static DefaultValueConverter.DefaultValueMapper enforceStringUnquote() {
        return (column, value) -> value != null ? OracleDefaultValueConverter.unquote(value) : null;
    }

    private static DefaultValueConverter.DefaultValueMapper castTemporalFunctionCall(OracleConnection jdbcConnection) {
        return (column, value) -> {
            if ("SYSDATE".equalsIgnoreCase(value.trim())) {
                if (column.isOptional()) {
                    return null;
                }
                if (column.jdbcType() == -101 || column.jdbcType() == -102) {
                    return Date.from(Instant.EPOCH);
                }
                return "0";
            }
            if (value.toUpperCase().startsWith("TO_TIMESTAMP")) {
                switch (column.jdbcType()) {
                    case 92: 
                    case 93: {
                        return JdbcConnection.querySingleValue(jdbcConnection.connection(), "SELECT CAST(" + value + " AS TIMESTAMP) FROM DUAL", st -> {}, rs -> rs.getObject(1, TIMESTAMP.class));
                    }
                    case -101: {
                        return JdbcConnection.querySingleValue(jdbcConnection.connection(), "SELECT CAST(" + value + " AS TIMESTAMP WITH TIME ZONE) FROM DUAL", st -> {}, rs -> rs.getObject(1, TIMESTAMPTZ.class));
                    }
                    case -102: {
                        return JdbcConnection.querySingleValue(jdbcConnection.connection(), "SELECT CAST(" + value + " AS TIMESTAMP WITH LOCAL TIME ZONE) FROM DUAL", st -> {}, rs -> rs.getObject(1, TIMESTAMPLTZ.class));
                    }
                }
            } else if (value.toUpperCase().startsWith("TO_DATE") && (column.jdbcType() == 91 || column.jdbcType() == 93)) {
                return JdbcConnection.querySingleValue(jdbcConnection.connection(), "SELECT CAST(" + value + " AS TIMESTAMP) FROM DUAL", st -> {}, rs -> rs.getObject(1, TIMESTAMP.class));
            }
            return value;
        };
    }

    private static String unquote(String value) {
        if (value.startsWith("('") && value.endsWith("')")) {
            return value.substring(2, value.length() - 2);
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

