/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr;

import io.debezium.antlr.AntlrDdlParser;
import io.debezium.antlr.AntlrDdlParserListener;
import io.debezium.antlr.DataTypeResolver;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.antlr.listener.OracleDdlParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlLexer;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.SystemVariables;
import io.debezium.relational.Tables;
import java.util.Arrays;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;

public class OracleDdlParser
extends AntlrDdlParser<PlSqlLexer, PlSqlParser> {
    private final Tables.TableFilter tableFilter;
    private final OracleValueConverters converters;
    private String catalogName;
    private String schemaName;

    public OracleDdlParser() {
        this(null, Tables.TableFilter.includeAll());
    }

    public OracleDdlParser(OracleValueConverters valueConverters) {
        this(true, valueConverters, Tables.TableFilter.includeAll());
    }

    public OracleDdlParser(OracleValueConverters valueConverters, Tables.TableFilter tableFilter) {
        this(true, valueConverters, tableFilter);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, OracleValueConverters converters, Tables.TableFilter tableFilter) {
        this(throwErrorsFromTreeWalk, false, false, converters, tableFilter);
    }

    public OracleDdlParser(boolean throwErrorsFromTreeWalk, boolean includeViews, boolean includeComments, OracleValueConverters converters, Tables.TableFilter tableFilter) {
        super(throwErrorsFromTreeWalk, includeViews, includeComments);
        this.converters = converters;
        this.tableFilter = tableFilter;
    }

    @Override
    public void parse(String ddlContent, Tables databaseTables) {
        if (!((String)ddlContent).endsWith(";")) {
            ddlContent = (String)ddlContent + ";";
        }
        super.parse((String)ddlContent, databaseTables);
    }

    @Override
    public ParseTree parseTree(PlSqlParser parser) {
        return parser.sql_script();
    }

    @Override
    protected AntlrDdlParserListener createParseTreeWalkerListener() {
        return new OracleDdlParserListener(this.catalogName, this.schemaName, this);
    }

    @Override
    protected PlSqlLexer createNewLexerInstance(CharStream charStreams) {
        return new PlSqlLexer(charStreams);
    }

    @Override
    protected PlSqlParser createNewParserInstance(CommonTokenStream commonTokenStream) {
        return new PlSqlParser((TokenStream)commonTokenStream);
    }

    @Override
    protected boolean isGrammarInUpperCase() {
        return true;
    }

    @Override
    protected DataTypeResolver initializeDataTypeResolver() {
        DataTypeResolver.Builder dataTypeResolverBuilder = new DataTypeResolver.Builder();
        dataTypeResolverBuilder.registerDataTypes(PlSqlParser.Native_datatype_elementContext.class.getCanonicalName(), Arrays.asList(new DataTypeResolver.DataTypeEntry(2, 736), new DataTypeResolver.DataTypeEntry(2, 727), new DataTypeResolver.DataTypeEntry(2, 1626), new DataTypeResolver.DataTypeEntry(2, 1168), new DataTypeResolver.DataTypeEntry(2, 363), new DataTypeResolver.DataTypeEntry(2, 1167), new DataTypeResolver.DataTypeEntry(93, 343), new DataTypeResolver.DataTypeEntry(-102, 2023), new DataTypeResolver.DataTypeEntry(-101, 2023), new DataTypeResolver.DataTypeEntry(93, 2023), new DataTypeResolver.DataTypeEntry(12, 2169), new DataTypeResolver.DataTypeEntry(12, 2170), new DataTypeResolver.DataTypeEntry(-9, 1172), new DataTypeResolver.DataTypeEntry(1, 184), new DataTypeResolver.DataTypeEntry(-15, 948), new DataTypeResolver.DataTypeEntry(100, 119), new DataTypeResolver.DataTypeEntry(101, 116), new DataTypeResolver.DataTypeEntry(6, 576), new DataTypeResolver.DataTypeEntry(6, 1435), new DataTypeResolver.DataTypeEntry(2004, 133), new DataTypeResolver.DataTypeEntry(2005, 201)));
        return dataTypeResolverBuilder.build();
    }

    @Override
    protected SystemVariables createNewSystemVariablesInstance() {
        return null;
    }

    @Override
    public void setCurrentDatabase(String databaseName) {
        this.catalogName = databaseName;
    }

    @Override
    public void setCurrentSchema(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public SystemVariables systemVariables() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void runIfNotNull(Runnable function, Object ... nullableObjects) {
        for (Object nullableObject : nullableObjects) {
            if (nullableObject != null) continue;
            return;
        }
        function.run();
    }

    public OracleValueConverters getConverters() {
        return this.converters;
    }

    public Tables.TableFilter getTableFilter() {
        return this.tableFilter;
    }
}

