/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.antlr.listener.BaseParserListener;
import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.stream.Collectors;

public class CommentParserListener
extends BaseParserListener {
    private final String catalogName;
    private final String schemaName;
    private final OracleDdlParser parser;
    private TableEditor tableEditor;

    CommentParserListener(String catalogName, String schemaName, OracleDdlParser parser) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.parser = parser;
    }

    @Override
    public void enterComment_on_column(PlSqlParser.Comment_on_columnContext ctx) {
        if (!this.parser.skipComments()) {
            Table table;
            TableId tableId = new TableId(this.catalogName, this.schemaName, this.getTableName(ctx.column_name()));
            if (this.parser.getTableFilter().isIncluded(tableId) && (table = this.parser.databaseTables().forTable(tableId)) != null) {
                this.tableEditor = this.parser.databaseTables().editTable(tableId);
                this.parser.runIfNotNull(() -> {
                    String column = this.getColumnName(ctx.column_name());
                    String comment = OracleDdlParser.withoutQuotes(ctx.quoted_string().getText());
                    List<Column> columns = table.columns().stream().map(m -> {
                        if (m.name().equalsIgnoreCase(column)) {
                            m = m.edit().comment(comment).create();
                        }
                        return m;
                    }).collect(Collectors.toList());
                    this.tableEditor.setColumns(columns);
                }, this.tableEditor);
                super.enterComment_on_column(ctx);
            }
        }
    }

    @Override
    public void exitComment_on_column(PlSqlParser.Comment_on_columnContext ctx) {
        if (!this.parser.skipComments()) {
            this.parser.runIfNotNull(() -> {
                this.parser.databaseTables().overwriteTable(this.tableEditor.create());
                this.parser.signalCreateTable(this.tableEditor.tableId(), ctx);
            }, this.tableEditor);
        }
        super.exitComment_on_column(ctx);
    }

    @Override
    public void enterComment_on_table(PlSqlParser.Comment_on_tableContext ctx) {
        if (!this.parser.skipComments()) {
            TableId tableId = new TableId(this.catalogName, this.schemaName, this.getTableName(ctx.tableview_name()));
            if (this.parser.getTableFilter().isIncluded(tableId) && this.parser.databaseTables().forTable(tableId) != null) {
                this.tableEditor = this.parser.databaseTables().editTable(tableId);
                this.parser.runIfNotNull(() -> this.tableEditor.setComment(OracleDdlParser.withoutQuotes(ctx.quoted_string().getText())), this.tableEditor);
                super.enterComment_on_table(ctx);
            }
        }
    }

    @Override
    public void exitComment_on_table(PlSqlParser.Comment_on_tableContext ctx) {
        if (!this.parser.skipComments()) {
            this.parser.runIfNotNull(() -> {
                this.parser.databaseTables().overwriteTable(this.tableEditor.create());
                this.parser.signalCreateTable(this.tableEditor.tableId(), ctx);
            }, this.tableEditor);
        }
        super.exitComment_on_table(ctx);
    }
}

