/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.util.DelayStrategy;
import io.debezium.util.Strings;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerHelper {
    private static final String CURRENT = "CURRENT";
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerHelper.class);

    public static List<LogFile> setLogFilesForMining(OracleConnection connection, Scn lastProcessedScn, Duration archiveLogRetention, boolean archiveLogOnlyMode, String archiveDestinationName, int maxRetries, Duration initialDelay, Duration maxDelay) throws SQLException {
        LogMinerHelper.removeLogFilesFromMining(connection);
        int maxAttempts = Math.max(maxRetries, 0);
        DelayStrategy retryStrategy = DelayStrategy.exponential(initialDelay, maxDelay);
        ArrayList<LogFile> logFilesForMining = new ArrayList<LogFile>();
        for (int attempt = 0; attempt <= maxAttempts; ++attempt) {
            logFilesForMining.addAll(LogMinerHelper.getLogFilesForOffsetScn(connection, lastProcessedScn, archiveLogRetention, archiveLogOnlyMode, archiveDestinationName));
            if (LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(logFilesForMining, lastProcessedScn.add(Scn.ONE))) {
                List logFilesNames = logFilesForMining.stream().map(LogFile::getFileName).collect(Collectors.toList());
                for (String file : logFilesNames) {
                    LOGGER.trace("Adding log file {} to mining session", (Object)file);
                    String addLogFileStatement = SqlUtils.addLogFileStatement("DBMS_LOGMNR.ADDFILE", file);
                    LogMinerHelper.executeCallableStatement(connection, addLogFileStatement);
                }
                LOGGER.debug("Last mined SCN: {}, Log file list to mine: {}", (Object)lastProcessedScn, logFilesNames);
                return logFilesForMining;
            }
            LOGGER.info("No logs available yet (attempt {})...", (Object)(attempt + 1));
            logFilesForMining.clear();
            retryStrategy.sleepWhen(true);
        }
        Scn minScn = LogMinerHelper.getMinimumScn(logFilesForMining);
        if ((minScn.isNull() || logFilesForMining.isEmpty()) && archiveLogOnlyMode) {
            throw new DebeziumException("The log.mining.archive.log.only mode was recently enabled and the offset SCN " + lastProcessedScn + "is not yet in any available archive logs. Please perform an Oracle log switch and restart the connector.");
        }
        throw new IllegalStateException("None of log files contains offset SCN: " + lastProcessedScn + ", re-snapshot is required.");
    }

    private static boolean hasLogFilesStartingBeforeOrAtScn(List<LogFile> logs, Scn scn) {
        return logs.stream().anyMatch(l -> l.getFirstScn().compareTo(scn) <= 0);
    }

    private static Scn getMinimumScn(List<LogFile> logs) {
        return logs.stream().map(LogFile::getFirstScn).min(Scn::compareTo).orElse(Scn.NULL);
    }

    public static List<LogFile> getLogFilesForOffsetScn(OracleConnection connection, Scn offsetScn, Duration archiveLogRetention, boolean archiveLogOnlyMode, String archiveDestinationName) throws SQLException {
        LOGGER.trace("Getting logs to be mined for offset scn {}", (Object)offsetScn);
        ArrayList<LogFile> logFiles = new ArrayList<LogFile>();
        LinkedHashSet onlineLogFiles = new LinkedHashSet();
        LinkedHashSet<LogFile> archivedLogFiles = new LinkedHashSet<LogFile>();
        connection.query(SqlUtils.allMinableLogsQuery(offsetScn, archiveLogRetention, archiveLogOnlyMode, archiveDestinationName), rs -> {
            while (rs.next()) {
                LogFile logFile;
                String fileName = rs.getString(1);
                Scn firstScn = LogMinerHelper.getScnFromString(rs.getString(2));
                Scn nextScn = LogMinerHelper.getScnFromString(rs.getString(3));
                String status = rs.getString(5);
                String type = rs.getString(6);
                BigInteger sequence = new BigInteger(rs.getString(7));
                int thread = rs.getInt(10);
                if ("ARCHIVED".equals(type)) {
                    logFile = new LogFile(fileName, firstScn, nextScn, sequence, LogFile.Type.ARCHIVE, thread);
                    if (logFile.getNextScn().compareTo(offsetScn) < 0) continue;
                    LOGGER.trace("Archive log {} with SCN range {} to {} sequence {} to be added.", new Object[]{fileName, firstScn, nextScn, sequence});
                    archivedLogFiles.add(logFile);
                    continue;
                }
                if (!"ONLINE".equals(type)) continue;
                logFile = new LogFile(fileName, firstScn, nextScn, sequence, LogFile.Type.REDO, CURRENT.equalsIgnoreCase(status), thread);
                if (logFile.isCurrent() || logFile.getNextScn().compareTo(offsetScn) >= 0) {
                    LOGGER.trace("Online redo log {} with SCN range {} to {} ({}) sequence {} to be added.", new Object[]{fileName, firstScn, nextScn, status, sequence});
                    onlineLogFiles.add(logFile);
                    continue;
                }
                LOGGER.trace("Online redo log {} with SCN range {} to {} ({}) sequence {} to be excluded.", new Object[]{fileName, firstScn, nextScn, status, sequence});
            }
        });
        for (LogFile redoLog : onlineLogFiles) {
            archivedLogFiles.removeIf(f -> {
                if (f.getSequence().equals(redoLog.getSequence())) {
                    LOGGER.trace("Removing archive log {} with duplicate sequence {} to {}", new Object[]{f.getFileName(), f.getSequence(), redoLog.getFileName()});
                    return true;
                }
                return false;
            });
        }
        logFiles.addAll(archivedLogFiles);
        logFiles.addAll(onlineLogFiles);
        return logFiles;
    }

    private static Scn getScnFromString(String value) {
        if (Strings.isNullOrEmpty(value)) {
            return Scn.MAX;
        }
        return Scn.valueOf(value);
    }

    public static void removeLogFilesFromMining(OracleConnection conn) throws SQLException {
        try (PreparedStatement ps = conn.connection(false).prepareStatement("SELECT FILENAME AS NAME FROM V$LOGMNR_LOGS");
             ResultSet result = ps.executeQuery();){
            LinkedHashSet<String> files = new LinkedHashSet<String>();
            while (result.next()) {
                files.add(result.getString(1));
            }
            for (String fileName : files) {
                LogMinerHelper.executeCallableStatement(conn, SqlUtils.deleteLogFileStatement(fileName));
                LOGGER.debug("File {} was removed from mining", (Object)fileName);
            }
        }
    }

    private static void executeCallableStatement(OracleConnection connection, String statement) throws SQLException {
        Objects.requireNonNull(statement);
        try (CallableStatement s = connection.connection(false).prepareCall(statement);){
            s.execute();
        }
    }

    public static int getColumnIndexByName(String columnName, Table table) {
        Column column = table.columnWithName(columnName);
        if (column == null) {
            throw new DebeziumException("No column '" + columnName + "' found in table '" + table.id() + "'");
        }
        return column.position() - 1;
    }
}

