/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.parser.DmlParser;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import io.debezium.connector.oracle.logminer.parser.ParserUtils;
import io.debezium.relational.Table;

public class LogMinerDmlParser
implements DmlParser {
    private static final String NULL_SENTINEL = "${DBZ_NULL}";
    private static final String NULL = "NULL";
    private static final String INSERT_INTO = "insert into ";
    private static final String UPDATE = "update ";
    private static final String DELETE_FROM = "delete from ";
    private static final String AND = "and ";
    private static final String OR = "or ";
    private static final String SET = " set ";
    private static final String WHERE = " where ";
    private static final String VALUES = " values ";
    private static final String IS_NULL = "IS NULL";
    private static final String UNSUPPORTED = "Unsupported";
    private static final String UNSUPPORTED_TYPE = "Unsupported Type";
    private static final int INSERT_INTO_LENGTH = "insert into ".length();
    private static final int UPDATE_LENGTH = "update ".length();
    private static final int DELETE_FROM_LENGTH = "delete from ".length();
    private static final int VALUES_LENGTH = " values ".length();
    private static final int SET_LENGTH = " set ".length();
    private static final int WHERE_LENGTH = " where ".length();

    @Override
    public LogMinerDmlEntry parse(String sql, Table table) {
        if (table == null) {
            throw new DmlParserException("DML parser requires a non-null table");
        }
        if (sql != null && sql.length() > 0) {
            switch (sql.charAt(0)) {
                case 'i': {
                    return this.parseInsert(sql, table);
                }
                case 'u': {
                    return this.parseUpdate(sql, table);
                }
                case 'd': {
                    return this.parseDelete(sql, table);
                }
            }
        }
        throw new DmlParserException("Unknown supported SQL '" + sql + "'");
    }

    private LogMinerDmlEntry parseInsert(String sql, Table table) {
        try {
            int index = INSERT_INTO_LENGTH;
            index = this.parseTableName(sql, index);
            String[] columnNames = new String[table.columns().size()];
            index = this.parseColumnListClause(sql, index, columnNames);
            Object[] newValues = new Object[table.columns().size()];
            this.parseColumnValuesClause(sql, index, columnNames, newValues, table);
            return LogMinerDmlEntryImpl.forInsert(newValues);
        }
        catch (Exception e) {
            throw new DmlParserException("Failed to parse insert DML: '" + sql + "'", e);
        }
    }

    private LogMinerDmlEntry parseUpdate(String sql, Table table) {
        try {
            int index = UPDATE_LENGTH;
            index = this.parseTableName(sql, index);
            Object[] newValues = new Object[table.columns().size()];
            index = this.parseSetClause(sql, index, newValues, table);
            Object[] oldValues = new Object[table.columns().size()];
            this.parseWhereClause(sql, index, oldValues, table);
            for (int i = 0; i < oldValues.length; ++i) {
                oldValues[i] = ParserUtils.getColumnUnavailableValue(oldValues[i], table.columns().get(i));
                if (newValues[i] == NULL_SENTINEL) {
                    newValues[i] = null;
                    continue;
                }
                if (newValues[i] != null) continue;
                newValues[i] = oldValues[i];
            }
            return LogMinerDmlEntryImpl.forUpdate(newValues, oldValues);
        }
        catch (Exception e) {
            throw new DmlParserException("Failed to parse update DML: '" + sql + "'", e);
        }
    }

    private LogMinerDmlEntry parseDelete(String sql, Table table) {
        try {
            int index = DELETE_FROM_LENGTH;
            index = this.parseTableName(sql, index);
            Object[] oldValues = new Object[table.columns().size()];
            this.parseWhereClause(sql, index, oldValues, table);
            ParserUtils.setColumnUnavailableValues(oldValues, table);
            return LogMinerDmlEntryImpl.forDelete(oldValues);
        }
        catch (Exception e) {
            throw new DmlParserException("Failed to parse delete DML: '" + sql + "'", e);
        }
    }

    private int parseTableName(String sql, int index) {
        boolean inQuote = false;
        while (index < sql.length()) {
            char c = sql.charAt(index);
            if (c == '\"') {
                inQuote = !inQuote;
            } else if ((c == ' ' || c == '(') && !inQuote) break;
            ++index;
        }
        return index;
    }

    private int parseColumnListClause(String sql, int start, String[] columnNames) {
        int index;
        boolean inQuote = false;
        int columnIndex = 0;
        for (index = start; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (c == '(' && !inQuote) {
                start = index + 1;
                continue;
            }
            if (c == ')' && !inQuote) {
                ++index;
                break;
            }
            if (c != '\"') continue;
            if (inQuote) {
                inQuote = false;
                columnNames[columnIndex++] = sql.substring(start + 1, index);
                start = index + 2;
                continue;
            }
            inQuote = true;
        }
        return index;
    }

    /*
     * Unable to fully structure code
     */
    private int parseColumnValuesClause(String sql, int start, String[] columnNames, Object[] values, Table table) {
        index = start;
        nested = 0;
        inQuote = false;
        inValues = false;
        if (sql.indexOf(" values ", index) != index) {
            throw new DebeziumException("Failed to parse DML: " + sql);
        }
        index += LogMinerDmlParser.VALUES_LENGTH;
        columnIndex = 0;
        collectedValue = null;
        while (index < sql.length()) {
            block19: {
                c = sql.charAt(index);
                if (!inQuote) ** GOTO lbl-1000
                if (c == '\'') break block19;
                collectedValue.append(c);
                ** GOTO lbl-1000
            }
            if (sql.charAt(index + 1) == '\'') {
                collectedValue.append('\'');
                ++index;
            } else if (c == '(' && !inQuote && !inValues) {
                inValues = true;
                start = index + 1;
            } else if (c == '(' && !inQuote) {
                ++nested;
            } else if (c == '\'') {
                if (inQuote) {
                    inQuote = false;
                } else {
                    inQuote = true;
                    collectedValue = new StringBuilder();
                }
            } else if (!(inQuote || c != ',' && c != ')')) {
                if (c == ')' && nested != 0) {
                    --nested;
                } else if (c != ',' || nested == 0) {
                    if (sql.charAt(start) == '\'' && sql.charAt(index - 1) == '\'') {
                        position = LogMinerHelper.getColumnIndexByName(columnNames[columnIndex], table);
                        values[position] = collectedValue.toString();
                        collectedValue = null;
                    } else {
                        s = sql.substring(start, index);
                        if (!s.equals("Unsupported Type") && !s.equals("NULL")) {
                            position = LogMinerHelper.getColumnIndexByName(columnNames[columnIndex], table);
                            values[position] = s;
                        }
                    }
                    ++columnIndex;
                    start = index + 1;
                }
            }
            ++index;
        }
        return index;
    }

    private int parseSetClause(String sql, int start, Object[] newValues, Table table) {
        int index;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean inColumnName = true;
        boolean inColumnValue = false;
        boolean inSpecial = false;
        int nested = 0;
        int set = sql.indexOf(SET, start);
        if (set == -1) {
            throw new DebeziumException("Failed to parse DML: " + sql);
        }
        if (set != start) {
            start = set;
        }
        String currentColumnName = null;
        StringBuilder collectedValue = null;
        block0: for (index = start += SET_LENGTH; index < sql.length(); ++index) {
            char lookAhead;
            char c = sql.charAt(index);
            char c2 = lookAhead = index + 1 < sql.length() ? sql.charAt(index + 1) : (char)'\u0000';
            if (inSingleQuote) {
                if (c != '\'') {
                    collectedValue.append(c);
                } else if (lookAhead == '\'') {
                    collectedValue.append('\'');
                    ++index;
                    continue;
                }
            }
            if (c == '\"' && inColumnName) {
                if (inDoubleQuote) {
                    inDoubleQuote = false;
                    currentColumnName = sql.substring(start + 1, index);
                    start = index + 1;
                    inColumnName = false;
                    continue;
                }
                inDoubleQuote = true;
                start = index;
                continue;
            }
            if (c == '=' && !inColumnName && !inColumnValue) {
                inColumnValue = true;
                start = ++index + 1;
                continue;
            }
            if (nested == 0 && c == ' ' && lookAhead == '|') continue;
            if (nested == 0 && c == '|' && lookAhead == '|' && !inSingleQuote) {
                for (int i = index + 2; i < sql.length(); ++i) {
                    if (sql.charAt(i) == ' ') continue;
                    index = i - 1;
                    continue block0;
                }
                continue;
            }
            if (c == '\'' && inColumnValue) {
                if (inSingleQuote && lookAhead == '\'') {
                    ++index;
                    continue;
                }
                if (inSingleQuote) {
                    inSingleQuote = false;
                    if (nested != 0) continue;
                    int position = LogMinerHelper.getColumnIndexByName(currentColumnName, table);
                    newValues[position] = collectedValue.toString();
                    collectedValue = null;
                    start = index + 1;
                    inColumnValue = false;
                    inColumnName = false;
                    continue;
                }
                if (!inSpecial) {
                    start = index;
                }
                inSingleQuote = true;
                collectedValue = new StringBuilder();
                continue;
            }
            if (c == ',' && !inColumnValue && !inColumnName) {
                inColumnName = true;
                start = ++index;
                continue;
            }
            if (inColumnValue && !inSingleQuote) {
                int position;
                if (!inSpecial) {
                    start = index;
                    inSpecial = true;
                }
                if (c == '(') {
                    ++nested;
                    continue;
                }
                if (c == ')' && nested > 0) {
                    --nested;
                    continue;
                }
                if (c != ',' && c != ' ' && c != ';' || nested != 0) continue;
                String value = sql.substring(start, index);
                if (value.equals(NULL) || value.equals(UNSUPPORTED_TYPE)) {
                    if (value.equals(NULL)) {
                        position = LogMinerHelper.getColumnIndexByName(currentColumnName, table);
                        newValues[position] = NULL_SENTINEL;
                    }
                    start = index + 1;
                    inColumnValue = false;
                    inSpecial = false;
                    inColumnName = true;
                    continue;
                }
                if (value.equals(UNSUPPORTED)) continue;
                position = LogMinerHelper.getColumnIndexByName(currentColumnName, table);
                newValues[position] = value;
                start = index + 1;
                inColumnValue = false;
                inSpecial = false;
                inColumnName = true;
                continue;
            }
            if (inDoubleQuote || inSingleQuote || c != 'w' || lookAhead != 'h' || sql.indexOf(WHERE, index - 1) != index - 1) continue;
            --index;
            break;
        }
        return index;
    }

    private int parseWhereClause(String sql, int start, Object[] values, Table table) {
        int index;
        int nested = 0;
        boolean inColumnName = true;
        boolean inColumnValue = false;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        boolean inSpecial = false;
        if (start >= sql.length()) {
            return start;
        }
        int where = sql.indexOf(WHERE, start);
        if (where == -1) {
            throw new DebeziumException("Failed to parse DML: " + sql);
        }
        if (where != start) {
            start = where;
        }
        String currentColumnName = null;
        StringBuilder collectedValue = null;
        block0: for (index = start += WHERE_LENGTH; index < sql.length(); ++index) {
            char lookAhead;
            char c = sql.charAt(index);
            char c2 = lookAhead = index + 1 < sql.length() ? sql.charAt(index + 1) : (char)'\u0000';
            if (inSingleQuote) {
                if (c != '\'') {
                    collectedValue.append(c);
                } else if (lookAhead == '\'') {
                    collectedValue.append('\'');
                    ++index;
                    continue;
                }
            }
            if (c == '\"' && inColumnName) {
                if (inDoubleQuote) {
                    inDoubleQuote = false;
                    currentColumnName = sql.substring(start + 1, index);
                    start = index + 1;
                    inColumnName = false;
                    continue;
                }
                inDoubleQuote = true;
                start = index;
                continue;
            }
            if (c == '=' && !inColumnName && !inColumnValue) {
                inColumnValue = true;
                start = ++index + 1;
                continue;
            }
            if (c == 'I' && !inColumnName && !inColumnValue) {
                if (sql.indexOf(IS_NULL, index) != index) continue;
                start = index += 6;
                continue;
            }
            if (c == '\'' && inColumnValue) {
                if (inSingleQuote && lookAhead == '\'') {
                    ++index;
                    continue;
                }
                if (inSingleQuote) {
                    inSingleQuote = false;
                    if (nested != 0) continue;
                    int position = LogMinerHelper.getColumnIndexByName(currentColumnName, table);
                    values[position] = collectedValue.toString();
                    collectedValue = null;
                    start = index + 1;
                    inColumnValue = false;
                    inColumnName = false;
                    continue;
                }
                if (!inSpecial) {
                    start = index;
                }
                inSingleQuote = true;
                collectedValue = new StringBuilder();
                continue;
            }
            if (inColumnValue && !inSingleQuote) {
                if (!inSpecial) {
                    start = index;
                    inSpecial = true;
                }
                if (c == '(') {
                    ++nested;
                    continue;
                }
                if (c == ')' && nested > 0) {
                    --nested;
                    continue;
                }
                if (nested == 0 && c == ' ' && lookAhead == '|') continue;
                if (nested == 0 && c == '|' && lookAhead == '|') {
                    for (int i = index + 2; i < sql.length(); ++i) {
                        if (sql.charAt(i) == ' ') continue;
                        index = i - 1;
                        continue block0;
                    }
                    continue;
                }
                if (c != ';' && c != ' ' || nested != 0) continue;
                String value = sql.substring(start, index);
                if (value.equals(NULL) || value.equals(UNSUPPORTED_TYPE)) {
                    start = index + 1;
                    inColumnValue = false;
                    inSpecial = false;
                    inColumnName = true;
                    continue;
                }
                if (value.equals(UNSUPPORTED)) continue;
                int position = LogMinerHelper.getColumnIndexByName(currentColumnName, table);
                values[position] = value;
                start = index + 1;
                inColumnValue = false;
                inSpecial = false;
                inColumnName = true;
                continue;
            }
            if (inColumnValue || inColumnName) continue;
            if (c == 'a' && lookAhead == 'n' && sql.indexOf(AND, index) == index) {
                start = index += 3;
                inColumnName = true;
                continue;
            }
            if (c != 'o' || lookAhead != 'r' || sql.indexOf(OR, index) != index) continue;
            start = index += 2;
            inColumnName = true;
        }
        return index;
    }
}

