/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import java.util.Map;

public class XStreamOracleOffsetContextLoader
implements OffsetContext.Loader<OracleOffsetContext> {
    private final OracleConnectorConfig connectorConfig;

    public XStreamOracleOffsetContextLoader(OracleConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public OracleOffsetContext load(Map<String, ?> offset) {
        boolean snapshot = Boolean.TRUE.equals(offset.get("snapshot"));
        boolean snapshotCompleted = Boolean.TRUE.equals(offset.get("snapshot_completed"));
        String lcrPosition = (String)offset.get("lcr_position");
        Scn scn = lcrPosition != null ? LcrPosition.valueOf(lcrPosition).getScn() : OracleOffsetContext.getScnFromOffsetMapByKey(offset, "scn");
        Map<String, Scn> snapshotPendingTransactions = OracleOffsetContext.loadSnapshotPendingTransactions(offset);
        Scn snapshotScn = OracleOffsetContext.loadSnapshotScn(offset);
        return new OracleOffsetContext(this.connectorConfig, scn, lcrPosition, snapshotScn, snapshotPendingTransactions, snapshot, snapshotCompleted, TransactionContext.load(offset), SignalBasedIncrementalSnapshotContext.load(offset));
    }
}

