/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.AbstractPartition;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Collect;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PostgresPartition
extends AbstractPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private final String serverName;

    public PostgresPartition(String serverName, String databaseName) {
        super(databaseName);
        this.serverName = serverName;
    }

    @Override
    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf(SERVER_PARTITION_KEY, this.serverName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PostgresPartition other = (PostgresPartition)obj;
        return Objects.equals(this.serverName, other.serverName);
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    public String toString() {
        return "PostgresPartition [sourcePartition=" + this.getSourcePartition() + "]";
    }

    static class Provider
    implements Partition.Provider<PostgresPartition> {
        private final PostgresConnectorConfig connectorConfig;
        private final Configuration taskConfig;

        Provider(PostgresConnectorConfig connectorConfig, Configuration taskConfig) {
            this.connectorConfig = connectorConfig;
            this.taskConfig = taskConfig;
        }

        @Override
        public Set<PostgresPartition> getPartitions() {
            return Collections.singleton(new PostgresPartition(this.connectorConfig.getLogicalName(), this.taskConfig.getString(RelationalDatabaseConnectorConfig.DATABASE_NAME.name())));
        }
    }
}

