/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.AbstractPartition;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SqlServerPartition
extends AbstractPartition
implements Partition {
    private static final String SERVER_PARTITION_KEY = "server";
    private static final String DATABASE_PARTITION_KEY = "database";
    private final String serverName;
    private final Map<String, String> sourcePartition;
    private final int hashCode;

    public SqlServerPartition(String serverName, String databaseName) {
        super(databaseName);
        this.serverName = serverName;
        this.sourcePartition = Collect.hashMapOf(SERVER_PARTITION_KEY, serverName, DATABASE_PARTITION_KEY, databaseName);
        this.hashCode = Objects.hash(serverName, databaseName);
    }

    @Override
    public Map<String, String> getSourcePartition() {
        return this.sourcePartition;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlServerPartition other = (SqlServerPartition)obj;
        return Objects.equals(this.serverName, other.serverName) && Objects.equals(this.databaseName, other.databaseName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "SqlServerPartition [sourcePartition=" + this.getSourcePartition() + "]";
    }

    static class Provider
    implements Partition.Provider<SqlServerPartition> {
        private final SqlServerConnectorConfig connectorConfig;

        Provider(SqlServerConnectorConfig connectorConfig) {
            this.connectorConfig = connectorConfig;
        }

        @Override
        public Set<SqlServerPartition> getPartitions() {
            String serverName = this.connectorConfig.getLogicalName();
            return this.connectorConfig.getDatabaseNames().stream().map(databaseName -> new SqlServerPartition(serverName, (String)databaseName)).collect(Collectors.toSet());
        }
    }
}

