/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.embedded.Predicates;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transformations
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Transformations.class);
    private static final String TYPE_SUFFIX = ".type";
    private static final String PREDICATE_SUFFIX = ".predicate";
    private static final String NEGATE_SUFFIX = ".negate";
    private final Configuration config;
    private final List<Transformation<SourceRecord>> transforms = new ArrayList<Transformation<SourceRecord>>();
    private final Predicates predicates;

    public Transformations(Configuration config) {
        this.config = config;
        this.predicates = new Predicates(config);
        String transformationList = config.getString(EmbeddedEngine.TRANSFORMS);
        if (transformationList == null) {
            return;
        }
        for (String transfName : transformationList.split(",")) {
            transfName = transfName.trim();
            Transformation<SourceRecord> transformation = this.getTransformation(transfName);
            this.transforms.add(transformation);
        }
    }

    private static String transformationConfigNamespace(String name) {
        return EmbeddedEngine.TRANSFORMS.name() + "." + name;
    }

    Transformation<SourceRecord> getTransformation(String name) {
        Transformation<SourceRecord> transformation;
        String transformPrefix = Transformations.transformationConfigNamespace(name);
        try {
            transformation = this.config.getInstance(transformPrefix + TYPE_SUFFIX, Transformation.class);
        }
        catch (Exception e) {
            throw new DebeziumException("Error while instantiating transformation '" + name + "'", e);
        }
        if (transformation == null) {
            throw new DebeziumException("Cannot instantiate transformation '" + name + "'");
        }
        transformation.configure(this.config.subset(transformPrefix, true).asMap());
        String predicateName = this.config.getString(transformPrefix + PREDICATE_SUFFIX);
        if (predicateName != null) {
            Boolean negate = this.config.getBoolean(transformPrefix + NEGATE_SUFFIX);
            Predicate<SourceRecord> predicate = this.predicates.getPredicate(predicateName);
            transformation = Transformations.createPredicateTransformation(negate != null && negate != false, predicate, transformation);
        }
        return transformation;
    }

    public SourceRecord transform(SourceRecord record) {
        Transformation<SourceRecord> t;
        Iterator<Transformation<SourceRecord>> iterator = this.transforms.iterator();
        while (iterator.hasNext() && (record = (t = iterator.next()).apply(record)) != null) {
        }
        return record;
    }

    private static Transformation<SourceRecord> createPredicateTransformation(final boolean negate, final Predicate<SourceRecord> predicate, final Transformation<SourceRecord> transformation) {
        return new Transformation<SourceRecord>(){

            @Override
            public SourceRecord apply(SourceRecord sourceRecord) {
                if (negate ^ predicate.test(sourceRecord)) {
                    return transformation.apply(sourceRecord);
                }
                return sourceRecord;
            }

            @Override
            public ConfigDef config() {
                return null;
            }

            @Override
            public void close() {
                try {
                    transformation.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void configure(Map<String, ?> map) {
            }
        };
    }

    @Override
    public void close() throws IOException {
        for (Transformation<SourceRecord> t : this.transforms) {
            try {
                t.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error while closing transformation", (Throwable)e);
            }
        }
        this.predicates.close();
    }
}

