/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;

public class JsonSchemaData {
    private final EventRouterConfigDefinition.JsonPayloadNullFieldBehavior jsonPayloadNullFieldBehavior;

    public JsonSchemaData() {
        this.jsonPayloadNullFieldBehavior = EventRouterConfigDefinition.JsonPayloadNullFieldBehavior.IGNORE;
    }

    public JsonSchemaData(EventRouterConfigDefinition.JsonPayloadNullFieldBehavior jsonPayloadNullFieldBehavior) {
        this.jsonPayloadNullFieldBehavior = jsonPayloadNullFieldBehavior;
    }

    public Schema toConnectSchema(String key, JsonNode node) {
        switch (node.getNodeType()) {
            case STRING: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case NUMBER: {
                if (node.isInt()) {
                    return Schema.OPTIONAL_INT32_SCHEMA;
                }
                if (node.isLong()) {
                    return Schema.OPTIONAL_INT64_SCHEMA;
                }
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case ARRAY: {
                ArrayNode arrayNode = (ArrayNode)node;
                return arrayNode.isEmpty() ? null : SchemaBuilder.array(this.toConnectSchemaWithCycles(key, arrayNode)).optional().build();
            }
            case OBJECT: {
                SchemaBuilder schemaBuilder = SchemaBuilder.struct().name(key).optional();
                if (node != null) {
                    Iterator fieldsEntries = node.fields();
                    while (fieldsEntries.hasNext()) {
                        Map.Entry fieldEntry = (Map.Entry)fieldsEntries.next();
                        String fieldName = (String)fieldEntry.getKey();
                        Schema fieldSchema = this.toConnectSchema(key + "." + fieldName, (JsonNode)fieldEntry.getValue());
                        if (fieldSchema == null || this.hasField(schemaBuilder, fieldName)) continue;
                        schemaBuilder.field(fieldName, fieldSchema);
                    }
                }
                return schemaBuilder.build();
            }
            case NULL: {
                if (this.jsonPayloadNullFieldBehavior.equals(EventRouterConfigDefinition.JsonPayloadNullFieldBehavior.OPTIONAL_BYTES)) {
                    return Schema.OPTIONAL_BYTES_SCHEMA;
                }
                return null;
            }
        }
        return null;
    }

    private Schema toConnectSchemaWithCycles(String key, ArrayNode array) throws ConnectException {
        Schema schema = null;
        JsonNode sample = this.getFirstArrayElement(array);
        if (sample.isObject()) {
            Iterator elements = array.elements();
            while (elements.hasNext()) {
                JsonNode element = (JsonNode)elements.next();
                if (!element.isObject()) continue;
                if (schema == null) {
                    schema = this.toConnectSchema(key, element);
                    continue;
                }
                schema = this.toConnectSchema(key, element);
            }
        } else {
            schema = this.toConnectSchema(null, sample);
            if (schema == null) {
                throw new ConnectException(String.format("Array '%s' has unrecognized member schema.", array.asText()));
            }
        }
        return schema;
    }

    private JsonNode getFirstArrayElement(ArrayNode array) throws ConnectException {
        NullNode refNode = NullNode.getInstance();
        Schema refSchema = null;
        Iterator elements = array.elements();
        while (elements.hasNext()) {
            Schema elementSchema;
            JsonNode element = (JsonNode)elements.next();
            if (element.isNull()) continue;
            if (refNode.isNull()) {
                refNode = element;
            }
            if (element.getNodeType() != refNode.getNodeType()) {
                throw new ConnectException(String.format("Field is not a homogenous array (%s x %s).", refNode.asText(), element.getNodeType().toString()));
            }
            if (refNode.getNodeType() != JsonNodeType.NUMBER) continue;
            if (refSchema == null) {
                refSchema = this.toConnectSchema(null, (JsonNode)refNode);
            }
            if (refSchema == (elementSchema = this.toConnectSchema(null, element))) continue;
            throw new ConnectException(String.format("Field is not a homogenous array (%s x %s), different number types (%s x %s)", refNode.asText(), element.asText(), refSchema, elementSchema));
        }
        return refNode;
    }

    private boolean hasField(SchemaBuilder builder, String fieldName) {
        return builder.field(fieldName) != null;
    }

    public Object toConnectData(JsonNode document, Schema schema) {
        if (document == null) {
            return null;
        }
        return this.jsonNodeToStructInternal(document, schema);
    }

    private Struct jsonNodeToStructInternal(JsonNode document, Schema schema) {
        Struct struct = new Struct(schema);
        for (Field field : schema.fields()) {
            if (!document.has(field.name())) continue;
            struct.put(field.name(), this.getStructFieldValue(document.path(field.name()), field.schema()));
        }
        return struct;
    }

    private Object getStructFieldValue(JsonNode node, Schema schema) {
        switch (node.getNodeType()) {
            case STRING: {
                return node.asText();
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case NUMBER: {
                if (node.isFloat()) {
                    return Float.valueOf(node.floatValue());
                }
                if (node.isDouble()) {
                    return node.asDouble();
                }
                if (node.isInt()) {
                    return node.asInt();
                }
                if (node.isLong()) {
                    return node.asLong();
                }
                return node.decimalValue();
            }
            case ARRAY: {
                return this.getArrayAsList((ArrayNode)node, schema);
            }
            case OBJECT: {
                return this.jsonNodeToStructInternal(node, schema);
            }
        }
        return null;
    }

    private List getArrayAsList(ArrayNode array, Schema schema) {
        ArrayList<Object> arrayObjects = new ArrayList<Object>(array.size());
        Iterator elements = array.elements();
        while (elements.hasNext()) {
            arrayObjects.add(this.getStructFieldValue((JsonNode)elements.next(), schema.valueSchema()));
        }
        return arrayObjects;
    }
}

