/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.ToolsUtils;
import org.apache.kafka.tools.TerseException;

public class MetadataQuorumCommand {
    public static void main(String ... args) {
        Exit.exit(MetadataQuorumCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            MetadataQuorumCommand.execute(args);
            return 0;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace(e));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute(String ... args) throws Exception {
        block10: {
            ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-metadata-quorum").defaultHelp(true).description("This tool describes kraft metadata quorum status.");
            parser.addArgument(new String[]{"--bootstrap-server"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka cluster.").required(true);
            parser.addArgument(new String[]{"--command-config"}).type((ArgumentType)Arguments.fileType()).help("Property file containing configs to be passed to Admin Client.");
            Subparsers subparsers = parser.addSubparsers().dest("command");
            MetadataQuorumCommand.addDescribeParser(subparsers);
            try (Admin admin = null;){
                Namespace namespace = parser.parseArgsOrFail(args);
                String command = namespace.getString("command");
                File commandConfig = (File)namespace.get("command_config");
                Properties props = new Properties();
                if (commandConfig != null) {
                    if (!commandConfig.exists()) {
                        throw new TerseException("Properties file " + commandConfig.getPath() + " does not exists!");
                    }
                    Utils.loadProps(commandConfig.getPath());
                }
                props.put("bootstrap.servers", namespace.getString("bootstrap_server"));
                admin = Admin.create(props);
                if (command.equals("describe")) {
                    if (namespace.getBoolean("status").booleanValue() && namespace.getBoolean("replication").booleanValue()) {
                        throw new TerseException("Only one of --status or --replication should be specified with describe sub-command");
                    }
                    if (namespace.getBoolean("replication").booleanValue()) {
                        MetadataQuorumCommand.handleDescribeReplication(admin);
                        break block10;
                    }
                    if (namespace.getBoolean("status").booleanValue()) {
                        MetadataQuorumCommand.handleDescribeStatus(admin);
                        break block10;
                    }
                    throw new TerseException("One of --status or --replication must be specified with describe sub-command");
                }
                throw new IllegalStateException("Unknown command: " + command + ", only 'describe' is supported");
            }
        }
    }

    private static void addDescribeParser(Subparsers subparsers) {
        Subparser describeParser = subparsers.addParser("describe").help("Describe the metadata quorum info");
        ArgumentGroup statusArgs = describeParser.addArgumentGroup("Status");
        statusArgs.addArgument(new String[]{"--status"}).help("A short summary of the quorum status and the other provides detailed information about the status of replication.").action((ArgumentAction)Arguments.storeTrue());
        ArgumentGroup replicationArgs = describeParser.addArgumentGroup("Replication");
        replicationArgs.addArgument(new String[]{"--replication"}).help("Detailed information about the status of replication").action((ArgumentAction)Arguments.storeTrue());
    }

    private static void handleDescribeReplication(Admin admin) throws ExecutionException, InterruptedException {
        QuorumInfo quorumInfo = admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = quorumInfo.voters().stream().filter(voter -> voter.replicaId() == leaderId).findFirst().get();
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, Stream.of(leader), "Leader"));
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, quorumInfo.voters().stream().filter(v -> v.replicaId() != leaderId), "Follower"));
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, quorumInfo.observers().stream(), "Observer"));
        ToolsUtils.prettyPrintTable(Arrays.asList("NodeId", "LogEndOffset", "Lag", "LastFetchTimestamp", "LastCaughtUpTimestamp", "Status"), rows, System.out);
    }

    private static List<List<String>> quorumInfoToRows(QuorumInfo.ReplicaState leader, Stream<QuorumInfo.ReplicaState> infos, String status) {
        return infos.map(info -> Stream.of(Integer.valueOf(info.replicaId()), info.logEndOffset(), leader.logEndOffset() - info.logEndOffset(), info.lastFetchTimestamp().orElse(-1L), info.lastCaughtUpTimestamp().orElse(-1L), status).map(r -> r.toString()).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private static void handleDescribeStatus(Admin admin) throws ExecutionException, InterruptedException {
        String clusterId = admin.describeCluster().clusterId().get();
        QuorumInfo quorumInfo = admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = quorumInfo.voters().stream().filter(voter -> voter.replicaId() == leaderId).findFirst().get();
        QuorumInfo.ReplicaState maxLagFollower = quorumInfo.voters().stream().min(Comparator.comparingLong(qi -> qi.logEndOffset())).get();
        long maxFollowerLag = leader.logEndOffset() - maxLagFollower.logEndOffset();
        long maxFollowerLagTimeMs = leader == maxLagFollower ? 0L : (leader.lastCaughtUpTimestamp().isPresent() && maxLagFollower.lastCaughtUpTimestamp().isPresent() ? leader.lastCaughtUpTimestamp().getAsLong() - maxLagFollower.lastCaughtUpTimestamp().getAsLong() : -1L);
        System.out.println("ClusterId:              " + clusterId + "\nLeaderId:               " + quorumInfo.leaderId() + "\nLeaderEpoch:            " + quorumInfo.leaderEpoch() + "\nHighWatermark:          " + quorumInfo.highWatermark() + "\nMaxFollowerLag:         " + maxFollowerLag + "\nMaxFollowerLagTimeMs:   " + maxFollowerLagTimeMs + "\nCurrentVoters:          " + Utils.mkString(quorumInfo.voters().stream().map(v -> v.replicaId()), "[", "]", ",") + "\nCurrentObservers:       " + Utils.mkString(quorumInfo.observers().stream().map(v -> v.replicaId()), "[", "]", ","));
    }
}

