/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.internal.recorder.MutableSpan;
import brave.internal.recorder.MutableSpanConverter;
import brave.propagation.TraceContext;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

public final class SpanReporter
implements Reporter<Span> {
    static final Logger logger = Logger.getLogger(SpanReporter.class.getName());
    final Endpoint localEndpoint;
    final Reporter<Span> delegate;
    final AtomicBoolean noop;

    public SpanReporter(Endpoint localEndpoint, Reporter<Span> delegate, AtomicBoolean noop) {
        this.localEndpoint = localEndpoint;
        this.delegate = delegate;
        this.noop = noop;
    }

    public void report(TraceContext context, MutableSpan span) {
        Span.Builder builderWithContextData = Span.newBuilder().traceId(context.traceIdHigh(), context.traceId()).parentId(context.parentIdAsLong()).id(context.spanId()).debug(context.debug()).localEndpoint(this.localEndpoint);
        MutableSpanConverter.convert(span, builderWithContextData);
        this.report(builderWithContextData.build());
    }

    public void report(Span span) {
        block3: {
            if (this.noop.get()) {
                return;
            }
            try {
                this.delegate.report((Object)span);
            }
            catch (RuntimeException e) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.log(Level.FINE, "error reporting " + span, e);
            }
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

