/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.reporter;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.SpanBuilderR;
import io.opentracing.propagation.Format;

public class TracerR
implements Tracer {
    final Tracer wrapped;
    final Reporter reporter;
    final ScopeManager scopeManager;

    public TracerR(Tracer wrapped, Reporter reporter, ScopeManager scopeManager) {
        this.wrapped = wrapped;
        this.reporter = reporter;
        this.scopeManager = scopeManager;
    }

    @Override
    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Override
    public Span activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope == null ? null : scope.span();
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String s) {
        return new SpanBuilderR(this.wrapped.buildSpan(s), this.reporter, s, this.scopeManager());
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C c) {
        this.wrapped.inject(spanContext, format, c);
    }

    @Override
    public <C> SpanContext extract(Format<C> format, C c) {
        return this.wrapped.extract(format, c);
    }
}

