/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.ErrorParser;
import brave.NoopScopedSpan;
import brave.NoopSpan;
import brave.NoopSpanCustomizer;
import brave.RealScopedSpan;
import brave.RealSpan;
import brave.RealSpanCustomizer;
import brave.ScopedSpan;
import brave.Span;
import brave.SpanCustomizer;
import brave.internal.InternalPropagation;
import brave.internal.Lists;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.TraceContexts;
import brave.internal.recorder.MutableSpan;
import brave.internal.recorder.PendingSpan;
import brave.internal.recorder.PendingSpans;
import brave.internal.recorder.SpanReporter;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.TraceIdContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracer {
    final Clock clock;
    final Propagation.Factory propagationFactory;
    final SpanReporter spanReporter;
    final PendingSpans pendingSpans;
    final Sampler sampler;
    final ErrorParser errorParser;
    final CurrentTraceContext currentTraceContext;
    final boolean traceId128Bit;
    final boolean supportsJoin;
    final AtomicBoolean noop;

    Tracer(Clock clock, Propagation.Factory propagationFactory, SpanReporter spanReporter, PendingSpans pendingSpans, Sampler sampler, ErrorParser errorParser, CurrentTraceContext currentTraceContext, boolean traceId128Bit, boolean supportsJoin, AtomicBoolean noop) {
        this.clock = clock;
        this.propagationFactory = propagationFactory;
        this.spanReporter = spanReporter;
        this.pendingSpans = pendingSpans;
        this.sampler = sampler;
        this.errorParser = errorParser;
        this.currentTraceContext = currentTraceContext;
        this.traceId128Bit = traceId128Bit;
        this.supportsJoin = supportsJoin;
        this.noop = noop;
    }

    public Tracer withSampler(Sampler sampler) {
        if (sampler == null) {
            throw new NullPointerException("sampler == null");
        }
        return new Tracer(this.clock, this.propagationFactory, this.spanReporter, this.pendingSpans, sampler, this.errorParser, this.currentTraceContext, this.traceId128Bit, this.supportsJoin, this.noop);
    }

    public Span newTrace() {
        return this._toSpan(this.newRootContext());
    }

    public final Span joinSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (!this.supportsJoin) {
            return this.newChild(context);
        }
        int flags = InternalPropagation.instance.flags(context);
        if ((flags & 4) != 4) {
            context = this.sampleContext(context, flags);
        } else if ((flags & 2) == 2) {
            context = TraceContexts.contextWithFlags(context, flags | 0x10);
        }
        return this._toSpan(this.propagationFactory.decorate(context));
    }

    public Span newChild(TraceContext parent) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        return this._toSpan(this.nextContext(parent));
    }

    TraceContext newRootContext() {
        return this.nextContext(0, 0L, 0L, 0L, Collections.<Object>emptyList());
    }

    TraceContext nextContext(TraceContext parent) {
        return this.nextContext(InternalPropagation.instance.flags(parent), parent.traceIdHigh(), parent.traceId(), parent.spanId(), parent.extra());
    }

    TraceContext nextContext(int flags, long traceIdHigh, long traceId, long parentId, List<Object> extra) {
        long nextId = this.nextId();
        if (traceId == 0L) {
            traceIdHigh = this.traceId128Bit ? Platform.get().nextTraceIdHigh() : 0L;
            traceId = nextId;
        } else {
            flags &= 0xFFFFFFEF;
        }
        long spanId = nextId;
        if ((flags & 4) != 4) {
            flags = TraceContexts.sampled(this.sampler.isSampled(traceId), flags);
        }
        return this.propagationFactory.decorate(InternalPropagation.instance.newTraceContext(flags, traceIdHigh, traceId, parentId, spanId, extra));
    }

    public Span nextSpan(TraceContextOrSamplingFlags extracted) {
        int flags;
        if (extracted == null) {
            throw new NullPointerException("extracted == null");
        }
        TraceContext context = extracted.context();
        if (context != null) {
            return this.newChild(context);
        }
        TraceIdContext traceIdContext = extracted.traceIdContext();
        if (traceIdContext != null) {
            return this._toSpan(this.nextContext(InternalPropagation.instance.flags(extracted.traceIdContext()), traceIdContext.traceIdHigh(), traceIdContext.traceId(), 0L, extracted.extra()));
        }
        SamplingFlags samplingFlags = extracted.samplingFlags();
        List<Object> extra = extracted.extra();
        TraceContext implicitParent = this.currentTraceContext.get();
        long traceIdHigh = 0L;
        long traceId = 0L;
        long spanId = 0L;
        if (implicitParent != null) {
            flags = InternalPropagation.instance.flags(implicitParent);
            traceIdHigh = implicitParent.traceIdHigh();
            traceId = implicitParent.traceId();
            spanId = implicitParent.spanId();
            extra = Lists.concatImmutableLists(extra, implicitParent.extra());
        } else {
            flags = InternalPropagation.instance.flags(samplingFlags);
        }
        return this._toSpan(this.nextContext(flags, traceIdHigh, traceId, spanId, extra));
    }

    public Span toSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        return this._toSpan(this.propagationFactory.decorate(context));
    }

    Span _toSpan(TraceContext decorated) {
        if (this.isNoop(decorated)) {
            return new NoopSpan(decorated);
        }
        PendingSpan pendingSpan = this.pendingSpans.getOrCreate(decorated, false);
        return new RealSpan(decorated, this.pendingSpans, pendingSpan.state(), pendingSpan.clock(), this.spanReporter, this.errorParser);
    }

    public SpanInScope withSpanInScope(@Nullable Span span) {
        return new SpanInScope(this.currentTraceContext.newScope(span != null ? span.context() : null));
    }

    public SpanCustomizer currentSpanCustomizer() {
        TraceContext context = this.currentTraceContext.get();
        if (context == null || this.isNoop(context)) {
            return NoopSpanCustomizer.INSTANCE;
        }
        PendingSpan pendingSpan = this.pendingSpans.getOrCreate(context, false);
        return new RealSpanCustomizer(context, pendingSpan.state(), pendingSpan.clock());
    }

    @Nullable
    public Span currentSpan() {
        TraceContext currentContext = this.currentTraceContext.get();
        return currentContext != null ? this.toSpan(currentContext) : null;
    }

    public Span nextSpan() {
        TraceContext parent = this.currentTraceContext.get();
        return parent != null ? this.newChild(parent) : this.newTrace();
    }

    public ScopedSpan startScopedSpan(String name) {
        return this.startScopedSpanWithParent(name, null);
    }

    public ScopedSpan startScopedSpanWithParent(String name, @Nullable TraceContext parent) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (parent == null) {
            parent = this.currentTraceContext.get();
        }
        TraceContext context = parent != null ? this.nextContext(parent) : this.newRootContext();
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(context);
        if (this.isNoop(context)) {
            return new NoopScopedSpan(context, scope);
        }
        PendingSpan pendingSpan = this.pendingSpans.getOrCreate(context, true);
        Clock clock = pendingSpan.clock();
        MutableSpan state = pendingSpan.state();
        state.name(name);
        return new RealScopedSpan(context, scope, state, clock, this.pendingSpans, this.spanReporter, this.errorParser);
    }

    public String toString() {
        TraceContext currentSpan = this.currentTraceContext.get();
        List<zipkin2.Span> inFlight = this.pendingSpans.snapshot();
        return "Tracer{" + (currentSpan != null ? "currentSpan=" + currentSpan + ", " : "") + (inFlight.size() > 0 ? "inFlight=" + inFlight + ", " : "") + (this.noop.get() ? "noop=true, " : "") + "reporter=" + this.spanReporter + "}";
    }

    boolean isNoop(TraceContext context) {
        return this.noop.get() || !Boolean.TRUE.equals(context.sampled());
    }

    long nextId() {
        long nextId = Platform.get().randomLong();
        while (nextId == 0L) {
            nextId = Platform.get().randomLong();
        }
        return nextId;
    }

    TraceContext sampleContext(TraceContext context, int flags) {
        flags = TraceContexts.sampled(this.sampler.isSampled(context.traceId()), flags);
        return TraceContexts.contextWithFlags(context, flags);
    }

    public static final class SpanInScope
    implements Closeable {
        final CurrentTraceContext.Scope scope;

        SpanInScope(CurrentTraceContext.Scope scope) {
            if (scope == null) {
                throw new NullPointerException("scope == null");
            }
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
        }

        public String toString() {
            return this.scope.toString();
        }
    }
}

