/*
 * Decompiled with CFR 0.152.
 */
package brave.internal.recorder;

import brave.Span;
import brave.internal.recorder.MutableSpan;
import zipkin2.Endpoint;
import zipkin2.Span;

public final class MutableSpanConverter {
    static final MutableSpan.TagConsumer TAG_CONSUMER = new MutableSpan.TagConsumer<Span.Builder>(){

        @Override
        public void accept(Span.Builder target, String key, String value) {
            target.putTag(key, value);
        }
    };
    static final MutableSpan.AnnotationConsumer ANNOTATION_CONSUMER = new MutableSpan.AnnotationConsumer<Span.Builder>(){

        @Override
        public void accept(Span.Builder target, long timestamp, String value) {
            target.addAnnotation(timestamp, value);
        }
    };

    public static void convert(MutableSpan span, Span.Builder result) {
        Span.Kind kind;
        result.name(span.name());
        long start = span.startTimestamp();
        long finish = span.finishTimestamp();
        result.timestamp(start);
        if (start != 0L && finish != 0L) {
            result.duration(Math.max(finish - start, 1L));
        }
        if ((kind = span.kind()) != null && kind.ordinal() < Span.Kind.values().length) {
            result.kind(Span.Kind.values()[kind.ordinal()]);
        }
        String remoteServiceName = span.remoteServiceName();
        String remoteIp = span.remoteIp();
        if (remoteServiceName != null || remoteIp != null) {
            result.remoteEndpoint(Endpoint.newBuilder().serviceName(remoteServiceName).ip(remoteIp).port(span.remotePort()).build());
        }
        span.forEachTag(TAG_CONSUMER, result);
        span.forEachAnnotation(ANNOTATION_CONSUMER, result);
        if (span.shared()) {
            result.shared(true);
        }
    }
}

