/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanContext;
import brave.propagation.TraceContext;
import brave.sampler.Sampler;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BraveSpanBuilder
implements Tracer.SpanBuilder {
    private final io.opentracing.Tracer tracer;
    private final Tracer braveTracer;
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private String operationName;
    private long timestamp;
    private int remotePort;
    private BraveSpanContext reference;
    private boolean ignoreActiveSpan = false;

    BraveSpanBuilder(io.opentracing.Tracer tracer, Tracer braveTracer, String operationName) {
        this.tracer = tracer;
        this.braveTracer = braveTracer;
        this.operationName = operationName;
    }

    @Override
    public BraveSpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    @Override
    public BraveSpanBuilder asChildOf(io.opentracing.Span parent) {
        return this.asChildOf(parent != null ? parent.context() : null);
    }

    @Override
    public BraveSpanBuilder addReference(String type, SpanContext context) {
        if (this.reference != null || context == null) {
            return this;
        }
        if ("child_of".equals(type) || "follows_from".equals(type)) {
            this.reference = (BraveSpanContext)context;
        }
        return this;
    }

    @Override
    public BraveSpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    @Override
    public BraveSpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key) && !value) {
            return this;
        }
        return this.withTag(key, Boolean.toString(value));
    }

    @Override
    public BraveSpanBuilder withTag(String key, Number value) {
        if (Tags.PEER_PORT.getKey().equals(key)) {
            this.remotePort = value.intValue();
            return this;
        }
        return this.withTag(key, value.toString());
    }

    @Override
    public BraveSpanBuilder withStartTimestamp(long microseconds) {
        this.timestamp = microseconds;
        return this;
    }

    @Override
    @Deprecated
    public BraveSpan startManual() {
        return this.start();
    }

    @Override
    public Scope startActive(boolean finishSpanOnClose) {
        Scope parent;
        if (!this.ignoreActiveSpan && (parent = this.tracer.scopeManager().active()) != null) {
            this.asChildOf(parent.span());
        }
        return this.tracer.scopeManager().activate(this.start(), finishSpanOnClose);
    }

    @Override
    public BraveSpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    @Override
    public BraveSpan start() {
        Span span;
        Scope parent;
        boolean server = "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        if (this.reference == null && !this.ignoreActiveSpan && (parent = this.tracer.scopeManager().active()) != null) {
            this.asChildOf(parent.span());
        }
        if (this.reference == null) {
            Tracer scopedBraveTracer = this.braveTracer;
            String sampling = this.tags.get(Tags.SAMPLING_PRIORITY.getKey());
            if (sampling != null) {
                try {
                    Integer samplingPriority = Integer.valueOf(sampling);
                    if (samplingPriority == 0) {
                        scopedBraveTracer = this.braveTracer.withSampler(Sampler.NEVER_SAMPLE);
                    } else if (samplingPriority > 0) {
                        scopedBraveTracer = this.braveTracer.withSampler(Sampler.ALWAYS_SAMPLE);
                    }
                }
                catch (NumberFormatException samplingPriority) {
                    // empty catch block
                }
            }
            span = scopedBraveTracer.newTrace();
        } else {
            TraceContext context = this.reference.unwrap();
            span = context != null ? (server ? this.braveTracer.joinSpan(context) : this.braveTracer.newChild(context)) : this.braveTracer.nextSpan(((BraveSpanContext.Incomplete)this.reference).extractionResult());
        }
        if (this.operationName != null) {
            span.name(this.operationName);
        }
        BraveSpan result = new BraveSpan(this.braveTracer, span);
        result.remotePort = this.remotePort;
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            result.setTag(tag.getKey(), tag.getValue());
        }
        if (this.timestamp != 0L) {
            span.start(this.timestamp);
        } else {
            span.start();
        }
        return result;
    }
}

