/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Tracer;
import brave.Tracing;
import brave.opentracing.BraveScopeManager;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanBuilder;
import brave.opentracing.BraveSpanContext;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class BraveTracer
implements io.opentracing.Tracer {
    private final Tracer brave4;
    private final BraveScopeManager scopeManager;
    final Map<Format<TextMap>, TraceContext.Injector<TextMap>> formatToInjector = new LinkedHashMap<Format<TextMap>, TraceContext.Injector<TextMap>>();
    final Map<Format<TextMap>, TraceContext.Extractor<TextMap>> formatToExtractor = new LinkedHashMap<Format<TextMap>, TraceContext.Extractor<TextMap>>();
    static final Propagation.Setter<TextMap, String> TEXT_MAP_SETTER = new Propagation.Setter<TextMap, String>(){

        @Override
        public void put(TextMap carrier, String key, String value) {
            carrier.put(key, value);
        }

        public String toString() {
            return "TextMap::put";
        }
    };
    static final Propagation.Getter<Map<String, String>, String> LC_MAP_GETTER = new Propagation.Getter<Map<String, String>, String>(){

        @Override
        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key.toLowerCase(Locale.ROOT));
        }

        public String toString() {
            return "Map::getLowerCase";
        }
    };

    public static BraveTracer create(Tracing brave4) {
        return BraveTracer.newBuilder(brave4).build();
    }

    public static Builder newBuilder(Tracing brave4) {
        return new Builder(brave4);
    }

    BraveTracer(Builder b) {
        this.brave4 = b.tracing.tracer();
        this.scopeManager = new BraveScopeManager(b.tracing);
        for (Map.Entry<Format<TextMap>, Propagation<String>> entry : b.formatToPropagation.entrySet()) {
            this.formatToInjector.put(entry.getKey(), entry.getValue().injector(TEXT_MAP_SETTER));
            this.formatToExtractor.put(entry.getKey(), new TextMapExtractorAdaptor(entry.getValue()));
        }
    }

    @Override
    public BraveScopeManager scopeManager() {
        return this.scopeManager;
    }

    @Override
    public BraveSpan activeSpan() {
        Scope scope = this.scopeManager.active();
        return scope != null ? (BraveSpan)scope.span() : null;
    }

    @Override
    public BraveSpanBuilder buildSpan(String operationName) {
        return new BraveSpanBuilder(this, this.brave4, operationName);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        TraceContext.Injector<TextMap> injector = this.formatToInjector.get(format);
        if (injector == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToInjector.keySet());
        }
        TraceContext traceContext = ((BraveSpanContext)spanContext).unwrap();
        injector.inject(traceContext, (TextMap)carrier);
    }

    @Override
    public <C> BraveSpanContext extract(Format<C> format, C carrier) {
        TraceContext.Extractor<TextMap> extractor = this.formatToExtractor.get(format);
        if (extractor == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToExtractor.keySet());
        }
        TraceContextOrSamplingFlags extractionResult = extractor.extract((TextMap)carrier);
        return BraveSpanContext.create(extractionResult);
    }

    static Set<String> lowercaseSet(List<String> fields) {
        LinkedHashSet<String> lcSet = new LinkedHashSet<String>();
        for (String f : fields) {
            lcSet.add(f.toLowerCase());
        }
        return lcSet;
    }

    static final class TextMapExtractorAdaptor
    implements TraceContext.Extractor<TextMap> {
        final Set<String> fields;
        final TraceContext.Extractor<Map<String, String>> delegate;

        TextMapExtractorAdaptor(Propagation<String> propagation) {
            this.fields = BraveTracer.lowercaseSet(propagation.keys());
            this.delegate = propagation.extractor(LC_MAP_GETTER);
        }

        @Override
        public TraceContextOrSamplingFlags extract(TextMap entries) {
            LinkedHashMap<String, String> cache = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> next : entries) {
                String inputKey = next.getKey().toLowerCase(Locale.ROOT);
                if (!this.fields.contains(inputKey)) continue;
                cache.put(inputKey, next.getValue());
            }
            return this.delegate.extract(cache);
        }
    }

    public static final class Builder {
        Tracing tracing;
        Map<Format<TextMap>, Propagation<String>> formatToPropagation = new LinkedHashMap<Format<TextMap>, Propagation<String>>();

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("brave tracing component == null");
            }
            this.tracing = tracing;
            this.formatToPropagation.put(Format.Builtin.HTTP_HEADERS, tracing.propagation());
            this.formatToPropagation.put(Format.Builtin.TEXT_MAP, tracing.propagation());
        }

        public Builder textMapPropagation(Format<TextMap> format, Propagation<String> propagation) {
            if (format == null) {
                throw new NullPointerException("format == null");
            }
            if (propagation == null) {
                throw new NullPointerException("propagation == null");
            }
            this.formatToPropagation.put(format, propagation);
            return this;
        }

        public BraveTracer build() {
            return new BraveTracer(this);
        }
    }
}

