/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.ArrayDeque;
import java.util.Deque;

public class ThreadLocalSpan {
    public static final ThreadLocalSpan CURRENT_TRACER = new ThreadLocalSpan(null){

        @Override
        Tracer tracer() {
            return Tracing.currentTracer();
        }
    };
    final ThreadLocal<Deque<SpanAndScope>> currentSpanInScope = new ThreadLocal<Deque<SpanAndScope>>(){

        @Override
        protected Deque<SpanAndScope> initialValue() {
            return new ArrayDeque<SpanAndScope>();
        }
    };
    final Tracer tracer;

    public static ThreadLocalSpan create(Tracer tracer) {
        if (tracer == null) {
            throw new NullPointerException("tracer == null");
        }
        return new ThreadLocalSpan(tracer);
    }

    ThreadLocalSpan(Tracer tracer) {
        this.tracer = tracer;
    }

    Tracer tracer() {
        return this.tracer;
    }

    @Nullable
    public Span next(TraceContextOrSamplingFlags extracted) {
        Tracer tracer = this.tracer();
        if (tracer == null) {
            return null;
        }
        Span next = tracer.nextSpan(extracted);
        SpanAndScope spanAndScope = new SpanAndScope(next, tracer.withSpanInScope(next));
        this.currentSpanInScope.get().addFirst(spanAndScope);
        return next;
    }

    @Nullable
    public Span next() {
        Tracer tracer = this.tracer();
        if (tracer == null) {
            return null;
        }
        Span next = tracer.nextSpan();
        SpanAndScope spanAndScope = new SpanAndScope(next, tracer.withSpanInScope(next));
        this.currentSpanInScope.get().addFirst(spanAndScope);
        return next;
    }

    @Nullable
    public Span remove() {
        Tracer tracer = this.tracer();
        Span currentSpan = tracer != null ? tracer.currentSpan() : null;
        SpanAndScope scope = this.currentSpanInScope.get().pollFirst();
        if (scope == null) {
            return currentSpan;
        }
        scope.scope.close();
        assert (scope.span.equals(currentSpan)) : "Misalignment: scoped span " + scope.span + " !=  current span " + currentSpan;
        return currentSpan;
    }

    static final class SpanAndScope {
        final Span span;
        final Tracer.SpanInScope scope;

        SpanAndScope(Span span, Tracer.SpanInScope scope) {
            this.span = span;
            this.scope = scope;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpanAndScope)) {
                return false;
            }
            SpanAndScope that = (SpanAndScope)o;
            return this.span.equals(that.span) && this.scope.equals(that.scope);
        }

        public int hashCode() {
            int h = 1;
            h *= 1000003;
            h ^= this.span.hashCode();
            h *= 1000003;
            return h ^= this.scope.hashCode();
        }
    }
}

