/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.Lists;
import brave.internal.Nullable;
import brave.internal.TraceContexts;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceIdContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TraceContextOrSamplingFlags {
    public static final TraceContextOrSamplingFlags EMPTY = new TraceContextOrSamplingFlags(3, SamplingFlags.EMPTY, Collections.<Object>emptyList());
    public static final TraceContextOrSamplingFlags NOT_SAMPLED = new TraceContextOrSamplingFlags(3, SamplingFlags.NOT_SAMPLED, Collections.<Object>emptyList());
    public static final TraceContextOrSamplingFlags SAMPLED = new TraceContextOrSamplingFlags(3, SamplingFlags.SAMPLED, Collections.<Object>emptyList());
    public static final TraceContextOrSamplingFlags DEBUG = new TraceContextOrSamplingFlags(3, SamplingFlags.DEBUG, Collections.<Object>emptyList());
    final int type;
    final SamplingFlags value;
    final List<Object> extra;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public Boolean sampled() {
        return this.value.sampled();
    }

    @Deprecated
    public TraceContextOrSamplingFlags sampled(@Nullable Boolean sampled) {
        if (sampled != null) {
            return this.sampled((boolean)sampled);
        }
        if (this.value.flags == 0) {
            return this;
        }
        switch (this.type) {
            case 1: {
                int flags = this.value.flags & 0xFFFFFFF9;
                TraceContext traceContext = TraceContexts.contextWithFlags((TraceContext)this.value, flags);
                return new TraceContextOrSamplingFlags(this.type, traceContext, this.extra);
            }
            case 2: {
                return new TraceContextOrSamplingFlags(this.type, this.idContextWithFlags(0), this.extra);
            }
            case 3: {
                if (this.extra.isEmpty()) {
                    return EMPTY;
                }
                return new TraceContextOrSamplingFlags(this.type, SamplingFlags.EMPTY, this.extra);
            }
        }
        throw new AssertionError((Object)"programming error");
    }

    public TraceContextOrSamplingFlags sampled(boolean sampled) {
        int flags = TraceContexts.sampled(sampled, this.value.flags);
        if (flags == this.value.flags) {
            return this;
        }
        switch (this.type) {
            case 1: {
                TraceContext traceContext = TraceContexts.contextWithFlags((TraceContext)this.value, flags);
                return new TraceContextOrSamplingFlags(this.type, traceContext, this.extra);
            }
            case 2: {
                TraceIdContext traceIdContext = this.idContextWithFlags(flags);
                return new TraceContextOrSamplingFlags(this.type, traceIdContext, this.extra);
            }
            case 3: {
                SamplingFlags samplingFlags = TraceContextOrSamplingFlags.toSamplingFlags(sampled, flags);
                if (this.extra.isEmpty()) {
                    return TraceContextOrSamplingFlags.create(samplingFlags);
                }
                return new TraceContextOrSamplingFlags(this.type, samplingFlags, this.extra);
            }
        }
        throw new AssertionError((Object)"programming error");
    }

    @Nullable
    public TraceContext context() {
        return this.type == 1 ? (TraceContext)this.value : null;
    }

    @Nullable
    public TraceIdContext traceIdContext() {
        return this.type == 2 ? (TraceIdContext)this.value : null;
    }

    @Nullable
    public SamplingFlags samplingFlags() {
        return this.type == 3 ? this.value : null;
    }

    public final List<Object> extra() {
        return this.extra;
    }

    public final Builder toBuilder() {
        Builder result = new Builder();
        result.type = this.type;
        result.value = this.value;
        result.extra = this.extra;
        return result;
    }

    public String toString() {
        return "{value=" + this.value + ", extra=" + this.extra + "}";
    }

    public static TraceContextOrSamplingFlags create(TraceContext context) {
        return new TraceContextOrSamplingFlags(1, context, Collections.<Object>emptyList());
    }

    public static TraceContextOrSamplingFlags create(TraceIdContext traceIdContext) {
        return new TraceContextOrSamplingFlags(2, traceIdContext, Collections.<Object>emptyList());
    }

    public static TraceContextOrSamplingFlags create(SamplingFlags flags) {
        if (flags == SamplingFlags.DEBUG) {
            return DEBUG;
        }
        if (flags == SamplingFlags.EMPTY) {
            return EMPTY;
        }
        return flags == SamplingFlags.SAMPLED ? SAMPLED : NOT_SAMPLED;
    }

    public static TraceContextOrSamplingFlags create(@Nullable Boolean sampled, boolean debug) {
        if (debug) {
            return DEBUG;
        }
        if (sampled == null) {
            return EMPTY;
        }
        return sampled != false ? SAMPLED : NOT_SAMPLED;
    }

    TraceContextOrSamplingFlags(int type, SamplingFlags value, List<Object> extra) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (extra == null) {
            throw new NullPointerException("extra == null");
        }
        this.type = type;
        this.value = value;
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceContextOrSamplingFlags)) {
            return false;
        }
        TraceContextOrSamplingFlags that = (TraceContextOrSamplingFlags)o;
        return this.type == that.type && this.value.equals(that.value) && this.extra.equals(that.extra);
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.type;
        h *= 1000003;
        h ^= this.value.hashCode();
        h *= 1000003;
        return h ^= this.extra.hashCode();
    }

    static SamplingFlags toSamplingFlags(boolean sampled, int flags) {
        if (flags == SamplingFlags.DEBUG.flags) {
            return SamplingFlags.DEBUG;
        }
        if (sampled) {
            return SamplingFlags.SAMPLED;
        }
        return SamplingFlags.NOT_SAMPLED;
    }

    TraceIdContext idContextWithFlags(int flags) {
        TraceIdContext traceIdContext = (TraceIdContext)this.value;
        return new TraceIdContext(flags, traceIdContext.traceIdHigh, traceIdContext.traceId);
    }

    public static final class Builder {
        int type;
        SamplingFlags value;
        List<Object> extra = Collections.emptyList();

        public final Builder context(TraceContext context) {
            if (context == null) {
                throw new NullPointerException("context == null");
            }
            this.type = 1;
            this.value = context;
            return this;
        }

        public final Builder traceIdContext(TraceIdContext traceIdContext) {
            if (traceIdContext == null) {
                throw new NullPointerException("traceIdContext == null");
            }
            this.type = 2;
            this.value = traceIdContext;
            return this;
        }

        public final Builder samplingFlags(SamplingFlags samplingFlags) {
            if (samplingFlags == null) {
                throw new NullPointerException("samplingFlags == null");
            }
            this.type = 3;
            this.value = samplingFlags;
            return this;
        }

        public final Builder extra(List<Object> extra) {
            if (extra == null) {
                throw new NullPointerException("extra == null");
            }
            this.extra = extra;
            return this;
        }

        public final Builder addExtra(Object extra) {
            if (extra == null) {
                throw new NullPointerException("extra == null");
            }
            if (!(this.extra instanceof ArrayList)) {
                this.extra = new ArrayList<Object>(this.extra);
            }
            this.extra.add(extra);
            return this;
        }

        public final TraceContextOrSamplingFlags build() {
            if (!this.extra.isEmpty() && this.type == 1) {
                TraceContext context = (TraceContext)this.value;
                context = context.extra().isEmpty() ? TraceContexts.contextWithExtra(context, Lists.ensureImmutable(this.extra)) : TraceContexts.contextWithExtra(context, Lists.concatImmutableLists(context.extra(), this.extra));
                return new TraceContextOrSamplingFlags(this.type, context, Collections.<Object>emptyList());
            }
            return new TraceContextOrSamplingFlags(this.type, this.value, Lists.ensureImmutable(this.extra));
        }

        Builder() {
        }
    }
}

