/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.reporter;

import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.reporter.Reporter;
import io.opentracing.contrib.reporter.SpanR;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class SpanBuilderR
implements Tracer.SpanBuilder {
    private static final String BAGGAGE_SPANID_KEY = "reporter.spanId";
    private Tracer.SpanBuilder wrapped;
    private Reporter reporter;
    private ScopeManager scopeManager;
    private final Map<String, Object> tags = new LinkedHashMap<String, Object>();
    private final Map<String, String> references = new LinkedHashMap<String, String>();
    private String operationName;

    SpanBuilderR(Tracer.SpanBuilder wrapped, Reporter reporter, String operationName, ScopeManager scopeManager) {
        this.wrapped = wrapped;
        this.reporter = reporter;
        this.operationName = operationName;
        this.scopeManager = scopeManager;
    }

    String findSpanId(SpanContext context) {
        for (Map.Entry<String, String> kv : context.baggageItems()) {
            if (!BAGGAGE_SPANID_KEY.equals(kv.getKey())) continue;
            return kv.getValue();
        }
        return "";
    }

    @Override
    public Tracer.SpanBuilder asChildOf(SpanContext spanContext) {
        return this.addReference("child_of", spanContext);
    }

    @Override
    public Tracer.SpanBuilder asChildOf(Span parent) {
        return this.addReference("child_of", parent.context());
    }

    @Override
    public Tracer.SpanBuilder addReference(String s, SpanContext spanContext) {
        this.wrapped.addReference(s, spanContext);
        this.references.put(s, this.findSpanId(spanContext));
        return this;
    }

    @Override
    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.wrapped.ignoreActiveSpan();
        return this;
    }

    @Override
    public Tracer.SpanBuilder withTag(String s, String s1) {
        this.wrapped = this.wrapped.withTag(s, s1);
        this.tags.put(s, s1);
        return this;
    }

    @Override
    public Tracer.SpanBuilder withTag(String s, boolean b) {
        this.wrapped = this.wrapped.withTag(s, b);
        this.tags.put(s, b);
        return this;
    }

    @Override
    public Tracer.SpanBuilder withTag(String s, Number number) {
        this.wrapped = this.wrapped.withTag(s, number);
        this.tags.put(s, number);
        return this;
    }

    @Override
    public Tracer.SpanBuilder withStartTimestamp(long l) {
        this.wrapped = this.wrapped.withStartTimestamp(l);
        return this;
    }

    @Override
    public Scope startActive(boolean finishSpanOnClose) {
        return this.scopeManager.activate(this.startManual(), finishSpanOnClose);
    }

    @Override
    public Span startManual() {
        Span wspan = this.wrapped.startManual();
        String spanId = UUID.randomUUID().toString();
        wspan.setBaggageItem(BAGGAGE_SPANID_KEY, spanId);
        return new SpanR(wspan, this.reporter, spanId, this.operationName, this.tags, this.references);
    }

    @Override
    public Span start() {
        Span wspan = this.wrapped.start();
        String spanId = UUID.randomUUID().toString();
        wspan.setBaggageItem(BAGGAGE_SPANID_KEY, spanId);
        return new SpanR(wspan, this.reporter, spanId, this.operationName, this.tags, this.references);
    }
}

