/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenModel;
import io.swagger.codegen.CodegenOperation;
import io.swagger.codegen.CodegenParameter;
import io.swagger.codegen.CodegenProperty;
import io.swagger.codegen.CodegenResponse;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Response;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ElmClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final String X_ENCODER = "x-encoder";
    private static final String X_DECODER = "x-decoder";
    private static final String X_DISCRIMINATOR_TYPE = "x-discriminator-value";
    private static final String X_UNION_TYPE = "x-union-type";
    private Set<String> customPrimitives = new HashSet<String>();
    protected String packageName = "swagger";
    protected String packageVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "elm";
    }

    @Override
    public String getHelp() {
        return "Generates a Elm client library (beta).";
    }

    public ElmClientCodegen() {
        this.outputFolder = "generated-code/elm";
        this.modelTemplateFiles.put("model.mustache", ".elm");
        this.apiTemplateFiles.put("api.mustache", ".elm");
        this.templateDir = "elm";
        this.supportsInheritance = true;
        this.reservedWords = new HashSet<String>(Arrays.asList("if", "then", "else", "case", "of", "let", "in", "type", "module", "where", "import", "exposing", "as", "port"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("List"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "Dict", "Float", "Int", "String"));
        this.customPrimitives = new HashSet<String>(Arrays.asList("Byte", "DateOnly", "DateTime"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Int");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("date", "DateOnly");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("password", "String");
        this.typeMapping.put("file", "String");
        this.typeMapping.put("ByteArray", "Byte");
        this.typeMapping.put("binary", "String");
        this.importMapping.clear();
        this.cliOptions.clear();
        this.supportingFiles.add(new SupportingFile("Byte.mustache", "src", "Byte.elm"));
        this.supportingFiles.add(new SupportingFile("DateOnly.mustache", "src", "DateOnly.elm"));
        this.supportingFiles.add(new SupportingFile("DateTime.mustache", "src", "DateTime.elm"));
        this.supportingFiles.add(new SupportingFile("Main.mustache", "src", "Main.elm"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("elm-package.mustache", "", "elm-package.json"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "Default";
        }
        return this.initialCaps(name);
    }

    @Override
    public String toModelName(String name) {
        return ElmClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.toModelName(property.name);
    }

    @Override
    public String toVarName(String name) {
        String varName = ElmClientCodegen.camelize(name, true);
        return this.isReservedWord(varName) ? this.escapeReservedWord(name) : varName;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        String camelized = ElmClientCodegen.camelize(value.replace(" ", "_").replace("(", "_").replace(")", ""));
        if (!Character.isUpperCase(camelized.charAt(0))) {
            return "N" + camelized;
        }
        return camelized;
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/src/Request/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/src/Data/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        HashMap<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            String modelName = this.toModelName(entry.getKey());
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                allModels.put(modelName, cm);
            }
        }
        for (CodegenModel cm : allModels.values()) {
            CodegenModel parent = (CodegenModel)allModels.get(cm.parent);
            if (parent == null) continue;
            if (parent.children == null) {
                parent.children = new ArrayList<CodegenModel>();
                parent.hasChildren = true;
            }
            parent.children.add(cm);
            Collections.sort(parent.children, new Comparator<CodegenModel>(){

                @Override
                public int compare(CodegenModel cm1, CodegenModel cm2) {
                    return Collator.getInstance().compare(cm1.classname, cm2.classname);
                }
            });
        }
        for (Map.Entry<String, Object> entry : objs.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (cm.isEnum) {
                    this.addEncoderAndDecoder(cm.vendorExtensions, cm.classname, false);
                    cm.vendorExtensions.put(X_UNION_TYPE, cm.classname);
                } else if (cm.isAlias) {
                    this.addEncoderAndDecoder(cm.vendorExtensions, cm.dataType, true);
                }
                ArrayList<ElmImport> elmImports = new ArrayList<ElmImport>();
                for (CodegenProperty property : cm.allVars) {
                    if (property.complexType == null) continue;
                    elmImports.add(this.createPropertyImport(property));
                }
                if (cm.discriminator != null) {
                    for (CodegenModel child : cm.children) {
                        ElmImport elmImport = new ElmImport();
                        String modulePrefix = this.customPrimitives.contains(child.classname) ? "" : "Data.";
                        elmImport.moduleName = modulePrefix + child.classname;
                        elmImport.exposures = new TreeSet<String>();
                        elmImport.exposures.add(child.classname);
                        elmImport.exposures.add(child.classVarName + "Decoder");
                        elmImport.exposures.add(child.classVarName + "Encoder");
                        elmImport.hasExposures = true;
                        elmImports.add(elmImport);
                        this.setDiscriminatorValue(child, cm.discriminator, this.getDiscriminatorValue(child));
                        int index = 0;
                        for (CodegenProperty property : cm.vars) {
                            if (cm.discriminator.equals(property.baseName)) continue;
                            child.vars.add(index++, property);
                        }
                    }
                }
                inner.put("elmImports", elmImports);
            }
        }
        return objs;
    }

    private void setDiscriminatorValue(CodegenModel model, String baseName, String value) {
        for (CodegenProperty prop : model.vars) {
            if (!prop.baseName.equals(baseName)) continue;
            prop.discriminatorValue = value;
        }
        for (CodegenProperty prop : model.allVars) {
            if (!prop.baseName.equals(baseName)) continue;
            prop.discriminatorValue = value;
        }
        if (model.children != null) {
            boolean newDiscriminator = model.discriminator != null;
            for (CodegenModel child : model.children) {
                this.setDiscriminatorValue(child, baseName, newDiscriminator ? value : this.getDiscriminatorValue(child));
            }
        }
    }

    private String getDiscriminatorValue(CodegenModel model) {
        return model.vendorExtensions.containsKey(X_DISCRIMINATOR_TYPE) ? (String)model.vendorExtensions.get(X_DISCRIMINATOR_TYPE) : model.classname;
    }

    private ElmImport createPropertyImport(CodegenProperty property) {
        ElmImport elmImport = new ElmImport();
        String modulePrefix = this.customPrimitives.contains(property.complexType) ? "" : "Data.";
        elmImport.moduleName = modulePrefix + property.complexType;
        elmImport.exposures = new TreeSet<String>();
        elmImport.exposures.add(property.complexType);
        if (property.vendorExtensions.containsKey(X_DECODER)) {
            elmImport.exposures.add((String)property.vendorExtensions.get(X_DECODER));
        }
        if (property.vendorExtensions.containsKey(X_ENCODER)) {
            elmImport.exposures.add((String)property.vendorExtensions.get(X_ENCODER));
        }
        elmImport.hasExposures = true;
        return elmImport;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> operations) {
        Map objs = (Map)operations.get("operations");
        List ops = (List)objs.get("operation");
        HashMap dependencies = new HashMap();
        for (CodegenOperation op : ops) {
            Object encoder;
            String path = op.path;
            for (CodegenParameter param : op.pathParams) {
                String var = param.isString ? param.paramName : "toString " + param.paramName;
                path = path.replace("{" + param.paramName + "}", "\" ++ " + var + " ++ \"");
            }
            op.path = ("\"" + path + "\"").replaceAll(" \\+\\+ \"\"", "");
            if (op.bodyParam != null && (encoder = (String)op.bodyParam.vendorExtensions.get(X_ENCODER)) != null) {
                if (!dependencies.containsKey(op.bodyParam.dataType)) {
                    dependencies.put(op.bodyParam.dataType, new TreeSet());
                }
                ((Set)dependencies.get(op.bodyParam.dataType)).add(encoder);
            }
            encoder = op.responses.iterator();
            while (encoder.hasNext()) {
                CodegenResponse resp = (CodegenResponse)encoder.next();
                String decoder = (String)resp.vendorExtensions.get(X_DECODER);
                if (decoder == null) continue;
                if (!dependencies.containsKey(resp.dataType)) {
                    dependencies.put(resp.dataType, new TreeSet());
                }
                ((Set)dependencies.get(resp.dataType)).add(decoder);
            }
        }
        ArrayList<ElmImport> elmImports = new ArrayList<ElmImport>();
        for (Map.Entry entry : dependencies.entrySet()) {
            ElmImport elmImport = new ElmImport();
            String key = (String)entry.getKey();
            elmImport.moduleName = "Data." + key;
            elmImport.exposures = (Set)entry.getValue();
            elmImport.exposures.add(key);
            elmImport.hasExposures = true;
            elmImports.add(elmImport);
        }
        operations.put("elmImports", elmImports);
        return operations;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty sp = (StringProperty)p;
            if (sp.getDefault() != null) {
                return this.toOptionalValue("\"" + sp.getDefault().toString() + "\"");
            }
            return this.toOptionalValue(null);
        }
        if (p instanceof BooleanProperty) {
            BooleanProperty bp = (BooleanProperty)p;
            if (bp.getDefault() != null) {
                return this.toOptionalValue(bp.getDefault() != false ? "True" : "False");
            }
            return this.toOptionalValue(null);
        }
        if (p instanceof DateProperty) {
            return this.toOptionalValue(null);
        }
        if (p instanceof DateTimeProperty) {
            return this.toOptionalValue(null);
        }
        if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getDefault() != null) {
                return this.toOptionalValue(dp.getDefault().toString());
            }
            return this.toOptionalValue(null);
        }
        if (p instanceof FloatProperty) {
            FloatProperty fp = (FloatProperty)p;
            if (fp.getDefault() != null) {
                return this.toOptionalValue(fp.getDefault().toString());
            }
            return this.toOptionalValue(null);
        }
        if (p instanceof IntegerProperty) {
            IntegerProperty ip = (IntegerProperty)p;
            if (ip.getDefault() != null) {
                return this.toOptionalValue(ip.getDefault().toString());
            }
            return this.toOptionalValue(null);
        }
        if (p instanceof LongProperty) {
            LongProperty lp = (LongProperty)p;
            if (lp.getDefault() != null) {
                return this.toOptionalValue(lp.getDefault().toString());
            }
            return this.toOptionalValue(null);
        }
        return this.toOptionalValue(null);
    }

    private String toOptionalValue(String value) {
        if (value == null) {
            return "Nothing";
        }
        return "(Just " + value + ")";
    }

    @Override
    public String getSwaggerType(Property p) {
        String type;
        String swaggerType = super.getSwaggerType(p);
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Property p) {
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getTypeDeclaration(inner);
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getTypeDeclaration(inner);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public CodegenProperty fromProperty(String name, Property p) {
        CodegenProperty property = super.fromProperty(name, p);
        String dataType = property.isEnum ? property.baseName : property.datatype;
        this.addEncoderAndDecoder(property.vendorExtensions, dataType, property.isPrimitiveType && !property.isEnum);
        if (property.isEnum) {
            property.vendorExtensions.put(X_UNION_TYPE, property.datatypeWithEnum);
        }
        return property;
    }

    @Override
    public CodegenResponse fromResponse(String responseCode, Response resp) {
        CodegenResponse response = super.fromResponse(responseCode, resp);
        if (response.dataType != null) {
            this.addEncoderAndDecoder(response.vendorExtensions, response.dataType, response.primitiveType);
        }
        return response;
    }

    @Override
    public CodegenParameter fromParameter(Parameter param, Set<String> imports) {
        CodegenParameter parameter = super.fromParameter(param, imports);
        this.addEncoderAndDecoder(parameter.vendorExtensions, parameter.dataType, parameter.isPrimitiveType);
        return parameter;
    }

    private void addEncoderAndDecoder(Map<String, Object> vendorExtensions, String dataType, Boolean isPrimitiveType) {
        String decoderName;
        String encoderName;
        String baseName = ElmClientCodegen.camelize(dataType, true);
        if (isPrimitiveType.booleanValue()) {
            encoderName = "Encode." + baseName;
            decoderName = "Decode." + baseName;
        } else {
            encoderName = baseName + "Encoder";
            decoderName = baseName + "Decoder";
        }
        if (!vendorExtensions.containsKey(X_ENCODER)) {
            vendorExtensions.put(X_ENCODER, encoderName);
        }
        if (!vendorExtensions.containsKey(X_DECODER)) {
            vendorExtensions.put(X_DECODER, decoderName);
        }
    }

    private static class ElmImport {
        public String moduleName;
        public String as;
        public Set<String> exposures;
        public Boolean hasExposures;

        private ElmImport() {
        }
    }
}

