/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CliOption;
import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.DefaultCodegen;
import io.swagger.codegen.SupportingFile;
import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.util.Json;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerGenerator
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerGenerator.class);
    public static final String OUTPUT_NAME = "outputFile";
    public static final String SWAGGER_FILENAME_DEFAULT_JSON = "swagger.json";
    protected String outputFile = "swagger.json";

    public SwaggerGenerator() {
        this.templateDir = "swagger";
        this.embeddedTemplateDir = "swagger";
        this.outputFolder = "generated-code/swagger";
        this.cliOptions.add(new CliOption(OUTPUT_NAME, "output filename").defaultValue(SWAGGER_FILENAME_DEFAULT_JSON));
        this.supportingFiles.add(new SupportingFile("README.md", "", "README.md"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.DOCUMENTATION;
    }

    @Override
    public String getName() {
        return "swagger";
    }

    @Override
    public String getHelp() {
        return "Creates a static swagger.json file.";
    }

    @Override
    public void processSwagger(Swagger swagger) {
        String swaggerString = Json.pretty(swagger);
        try {
            String outputFile = this.outputFolder + File.separator + this.outputFile;
            FileUtils.writeStringToFile((File)new File(outputFile), (String)swaggerString, (Charset)StandardCharsets.UTF_8);
            LOGGER.debug("wrote file to " + outputFile);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OUTPUT_NAME) && !StringUtils.isBlank((CharSequence)((String)this.additionalProperties.get(OUTPUT_NAME)))) {
            this.setOutputFile((String)this.additionalProperties.get(OUTPUT_NAME));
        }
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input;
    }

    @Override
    protected List<Map<String, String>> getExamples(Map<String, Model> definitions, Map<String, Object> examples, List<String> produces, Object object) {
        if (examples == null || examples.isEmpty()) {
            return null;
        }
        return super.getExamples(definitions, examples, produces, object);
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input;
    }
}

