/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.inflector.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.inflector.Constants;
import io.swagger.inflector.config.Configuration;
import io.swagger.inflector.models.RequestContext;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.RefModel;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.ByteArrayProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.EmailProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.properties.UUIDProperty;
import io.swagger.util.Json;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectionUtils.class);
    protected Configuration config;
    protected Set<String> unimplementedMappedModels = new TreeSet<String>();
    private ClassNameValidator classNameValidator = new ClassNameValidator(){

        @Override
        public boolean isValidClassname(String classname) {
            try {
                return Class.forName(classname) != null;
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Failed to find class [" + classname + "]");
                return false;
            }
        }
    };

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public JavaType[] getOperationParameterClasses(Operation operation, Map<String, Model> definitions) {
        TypeFactory tf = Json.mapper().getTypeFactory();
        JavaType[] jt = new JavaType[operation.getParameters().size() + 1];
        int i = 0;
        jt[i] = tf.constructType(RequestContext.class);
        ++i;
        for (Parameter parameter : operation.getParameters()) {
            JavaType argumentClass;
            jt[i] = argumentClass = this.getTypeFromParameter(parameter, definitions);
            ++i;
        }
        return jt;
    }

    public JavaType getTypeFromParameter(Parameter parameter, Map<String, Model> definitions) {
        if (parameter instanceof SerializableParameter) {
            SerializableParameter sp = (SerializableParameter)parameter;
            Property inner = sp.getItems();
            JavaType tp = this.getTypeFromProperty(sp.getType(), sp.getFormat(), inner, definitions);
            if (tp != null) {
                return tp;
            }
        } else if (parameter instanceof BodyParameter) {
            BodyParameter bp = (BodyParameter)parameter;
            Model model = bp.getSchema();
            return this.getTypeFromModel("", model, definitions);
        }
        return null;
    }

    public JavaType getTypeFromProperty(String type, String format, Property property, Map<String, Model> definitions) {
        TypeFactory tf = Json.mapper().getTypeFactory();
        if (property instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)property;
            Property inner = ap.getItems();
            JavaType innerType = this.getTypeFromProperty(null, null, inner, definitions);
            return tf.constructCollectionType(List.class, innerType);
        }
        if (property instanceof MapProperty) {
            MapProperty mp = (MapProperty)property;
            Property inner = mp.getAdditionalProperties();
            JavaType innerType = this.getTypeFromProperty(null, null, inner, definitions);
            return tf.constructMapLikeType(Map.class, this.getTypeFromProperty("string", null, null, definitions), innerType);
        }
        if (property instanceof RefProperty) {
            JavaType mt;
            Model model;
            RefProperty ref = (RefProperty)property;
            if (definitions != null && (model = definitions.get(ref.getSimpleRef())) != null && (mt = this.getTypeFromModel(ref.getSimpleRef(), model, definitions)) != null) {
                return mt;
            }
        }
        if ("array".equals(type)) {
            JavaType innerType = this.getTypeFromProperty(null, null, property, definitions);
            return tf.constructCollectionType(List.class, innerType);
        }
        if ("byte".equals(type) || property instanceof ByteArrayProperty) {
            return tf.constructType(Byte[].class);
        }
        if ("boolean".equals(type) || property instanceof BooleanProperty) {
            return tf.constructType(Boolean.class);
        }
        if ("string".equals(type) && "date".equals(format) || property instanceof DateProperty) {
            return tf.constructType(LocalDate.class);
        }
        if ("string".equals(type) && "date-time".equals(format) || property instanceof DateTimeProperty) {
            return tf.constructType(DateTime.class);
        }
        if ("string".equals(type) && format == null || property instanceof StringProperty) {
            return tf.constructType(String.class);
        }
        if ("number".equals(type) && format == null || property instanceof DecimalProperty) {
            return tf.constructType(BigDecimal.class);
        }
        if ("number".equals(type) && "double".equals(format) || property instanceof DoubleProperty) {
            return tf.constructType(Double.class);
        }
        if ("string".equals(type) && "email".equals(format) || property instanceof EmailProperty) {
            return tf.constructType(String.class);
        }
        if ("number".equals(type) && "float".equals(format) || property instanceof FloatProperty) {
            return tf.constructType(Float.class);
        }
        if ("string".equals(type) && "uuid".equals(format) || property instanceof UUIDProperty) {
            return tf.constructType(UUID.class);
        }
        if ("file".equals(type) || property instanceof FileProperty) {
            return tf.constructType(File.class);
        }
        if ("integer".equals(type) && "int32".equals(format) || property instanceof IntegerProperty) {
            return tf.constructType(Integer.class);
        }
        if ("integer".equals(type) && "int64".equals(format) || property instanceof LongProperty) {
            return tf.constructType(Long.class);
        }
        if ("integer".equals(type)) {
            LOGGER.warn("falling back to `string` with format `" + format + "`");
            return tf.constructType(Long.class);
        }
        if ("string".equals(type) || property instanceof StringProperty) {
            LOGGER.warn("falling back to `string` with format `" + format + "`");
            return tf.constructType(String.class);
        }
        if (property instanceof ObjectProperty) {
            JavaType modelType;
            String name = (String)property.getVendorExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL);
            if (name != null && (modelType = this.getTypeFromModelName(name)) != null) {
                return modelType;
            }
            return tf.constructType(JsonNode.class);
        }
        return null;
    }

    public JavaType getTypeFromModel(String name, Model model, Map<String, Model> definitions) {
        ArrayModel am;
        Model inner;
        JavaType modelType;
        RefModel ref;
        TypeFactory tf = Json.mapper().getTypeFactory();
        if (model instanceof RefModel && "".equals(name)) {
            ref = (RefModel)model;
            name = ref.getSimpleRef();
        }
        if (this.config != null && this.config.getModelMapping(name) != null) {
            return tf.constructType(this.config.getModelMapping(name));
        }
        if (model.getVendorExtensions() != null && model.getVendorExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL) != null && (modelType = this.getTypeFromModelName((String)model.getVendorExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL))) != null) {
            return modelType;
        }
        if (model instanceof RefModel && (inner = definitions.get((ref = (RefModel)model).getSimpleRef())) != null) {
            return this.getTypeFromModel(name, inner, definitions);
        }
        if (!"".equals(name)) {
            Class<?> cls;
            String modelName = name;
            if (this.config.getModelPackage() != null && name.indexOf(".") == -1) {
                modelName = this.config.getModelPackage() + "." + modelName;
            }
            if ((cls = this.loadClass(modelName)) != null) {
                return tf.constructType(cls);
            }
            if (model.getVendorExtensions() == null || model.getVendorExtensions().get(Constants.X_SWAGGER_ROUTER_MODEL) == null) {
                this.unimplementedMappedModels.add(modelName);
            }
        }
        if (model instanceof ArrayModel && (inner = (am = (ArrayModel)model).getItems()) != null) {
            JavaType innerType = this.getTypeFromProperty(inner.getType(), inner.getFormat(), (Property)inner, definitions);
            if (innerType != null) {
                return tf.constructArrayType(innerType);
            }
            return tf.constructArrayType(JsonNode.class);
        }
        if (model instanceof ModelImpl) {
            ModelImpl mi = (ModelImpl)model;
            String type = mi.getType();
            Property property = this.propertyFromModel(mi);
            if (property != null) {
                return this.getTypeFromProperty(mi.getType(), mi.getFormat(), property, definitions);
            }
        }
        return tf.constructType(JsonNode.class);
    }

    public Property propertyFromModel(ModelImpl model) {
        if (model.getType() == null) {
            return null;
        }
        HashMap<PropertyBuilder.PropertyId, Object> map = new HashMap<PropertyBuilder.PropertyId, Object>();
        if (model.getTitle() != null) {
            map.put(PropertyBuilder.PropertyId.TITLE, model.getTitle());
        }
        if (model.getDescription() != null) {
            map.put(PropertyBuilder.PropertyId.DESCRIPTION, model.getDescription());
        }
        if (model.getDefaultValue() != null) {
            map.put(PropertyBuilder.PropertyId.DEFAULT, model.getDefaultValue());
        }
        if (model.getExample() != null) {
            map.put(PropertyBuilder.PropertyId.EXAMPLE, model.getExample());
        }
        if (model.getFormat() != null) {
            map.put(PropertyBuilder.PropertyId.FORMAT, model.getFormat());
        }
        if (model.getVendorExtensions() != null) {
            map.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, model.getVendorExtensions());
        }
        return PropertyBuilder.build((String)model.getType(), (String)model.getFormat(), map);
    }

    public Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String sanitizeToJava(String operationId) {
        String op = operationId.trim();
        if ((op = op.replaceAll("[^a-zA-Z0-9]", "_")).length() == 0) {
            return "nullId";
        }
        return op;
    }

    public String getMethodName(String path, String httpMethod, Operation operation) {
        String output = operation.getOperationId();
        if (output != null) {
            return this.sanitizeToJava(output);
        }
        String tmpPath = path;
        tmpPath = tmpPath.replaceAll("\\{", "");
        tmpPath = tmpPath.replaceAll("\\}", "");
        String[] parts = (tmpPath + "/" + httpMethod).split("/");
        StringBuilder builder = new StringBuilder();
        if ("/".equals(tmpPath)) {
            builder.append("root");
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.length() <= 0) continue;
            part = builder.toString().length() == 0 ? Character.toLowerCase(part.charAt(0)) + part.substring(1) : StringUtils.capitalize((String)part);
            builder.append(part);
        }
        output = builder.toString();
        LOGGER.warn("generated operationId " + output);
        return output;
    }

    public String getControllerName(Operation operation) {
        String controllerClass;
        String name = (String)operation.getVendorExtensions().get(Constants.X_SWAGGER_ROUTER_CONTROLLER);
        if (name != null) {
            if ((name = name.replaceAll("^\"|\"$", "")).indexOf(".") == -1 && this.config.getControllerPackage() != null) {
                name = this.config.getControllerPackage() + "." + name;
            }
            if (this.classNameValidator.isValidClassname(name)) {
                return name;
            }
        }
        if (operation.getTags() != null && operation.getTags().size() > 0) {
            for (String tag : operation.getTags()) {
                name = StringUtils.capitalize((String)this.sanitizeToJava(tag));
                if (this.config.getControllerPackage() != null) {
                    name = this.config.getControllerPackage() + "." + name;
                }
                if (this.classNameValidator.isValidClassname(name)) {
                    return name;
                }
                if (this.classNameValidator.isValidClassname(name + "Controller")) {
                    return name + "Controller";
                }
                if (this.classNameValidator.isValidClassname(this.sanitizeToJava("default"))) {
                    return this.sanitizeToJava("default");
                }
                if (!this.classNameValidator.isValidClassname(this.sanitizeToJava("default"))) continue;
                return this.sanitizeToJava("default") + "Controller";
            }
        }
        if (StringUtils.isEmpty((String)(controllerClass = this.config.getControllerClass()))) {
            controllerClass = StringUtils.capitalize((String)this.sanitizeToJava("default"));
        }
        return this.config.getControllerPackage() + "." + controllerClass;
    }

    public Set<String> getUnimplementedMappedModels() {
        return this.unimplementedMappedModels;
    }

    public void setUnimplementedMappedModels(Set<String> unimplementedMappedModels) {
        this.unimplementedMappedModels = unimplementedMappedModels;
    }

    public ClassNameValidator getClassNameValidator() {
        return this.classNameValidator;
    }

    public void setClassNameValidator(ClassNameValidator classNameValidator) {
        this.classNameValidator = classNameValidator;
    }

    private JavaType getTypeFromModelName(String name) {
        TypeFactory tf = Json.mapper().getTypeFactory();
        String modelName = name.replaceAll("^\"|\"$", "");
        Class<?> cls = this.loadClass(modelName);
        if (cls != null) {
            return tf.constructType(cls);
        }
        if (this.config.getModelPackage() != null && !modelName.contains(".") && (cls = this.loadClass(modelName = this.config.getModelPackage() + "." + modelName)) != null) {
            return tf.constructType(cls);
        }
        this.unimplementedMappedModels.add(modelName);
        return null;
    }

    public static interface ClassNameValidator {
        public boolean isValidClassname(String var1);
    }
}

