/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.analysis.ja.dict.TokenInfoFST;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public final class TokenInfoDictionary
extends BinaryDictionary {
    public static final String FST_FILENAME_SUFFIX = "$fst.dat";
    private final TokenInfoFST fst;

    public TokenInfoDictionary(BinaryDictionary.ResourceScheme resourceScheme, String resourcePath) throws IOException {
        super(resourceScheme, resourcePath);
        FST<Long> fst;
        try (BufferedInputStream is = new BufferedInputStream(this.getResource(FST_FILENAME_SUFFIX));){
            InputStreamDataInput in = new InputStreamDataInput(is);
            fst = new FST<Long>(in, in, PositiveIntOutputs.getSingleton());
        }
        this.fst = new TokenInfoFST(fst, true);
    }

    private TokenInfoDictionary() throws IOException {
        this(BinaryDictionary.ResourceScheme.CLASSPATH, null);
    }

    public TokenInfoFST getFST() {
        return this.fst;
    }

    public static TokenInfoDictionary getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final TokenInfoDictionary INSTANCE;

        private SingletonHolder() {
        }

        static {
            try {
                INSTANCE = new TokenInfoDictionary();
            }
            catch (IOException ioe) {
                throw new RuntimeException("Cannot load TokenInfoDictionary.", ioe);
            }
        }
    }
}

