/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.lucene.analysis.ja.dict.ConnectionCosts;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.OutputStreamDataOutput;

final class ConnectionCostsWriter {
    private final short[][] costs;
    private final int forwardSize;
    private final int backwardSize;

    ConnectionCostsWriter(int forwardSize, int backwardSize) {
        this.forwardSize = forwardSize;
        this.backwardSize = backwardSize;
        this.costs = new short[backwardSize][forwardSize];
    }

    public void add(int forwardId, int backwardId, int cost) {
        this.costs[backwardId][forwardId] = (short)cost;
    }

    public void write(Path baseDir) throws IOException {
        Files.createDirectories(baseDir, new FileAttribute[0]);
        String fileName = ConnectionCosts.class.getName().replace('.', '/') + ".dat";
        try (OutputStream os = Files.newOutputStream(baseDir.resolve(fileName), new OpenOption[0]);
             BufferedOutputStream bos = new BufferedOutputStream(os);){
            OutputStreamDataOutput out = new OutputStreamDataOutput(bos);
            CodecUtil.writeHeader(out, "kuromoji_cc", 1);
            out.writeVInt(this.forwardSize);
            out.writeVInt(this.backwardSize);
            short last = 0;
            assert (this.costs.length == this.backwardSize);
            for (short[] a : this.costs) {
                assert (a.length == this.forwardSize);
                for (short cost : a) {
                    int delta = cost - last;
                    out.writeZInt(delta);
                    last = cost;
                }
            }
        }
    }
}

