/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.blockterms.TermsIndexWriterBase;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class VariableGapTermsIndexWriter
extends TermsIndexWriterBase {
    protected IndexOutput out;
    static final String TERMS_INDEX_EXTENSION = "tiv";
    static final String CODEC_NAME = "VariableGapTermsIndex";
    static final int VERSION_START = 3;
    static final int VERSION_CURRENT = 3;
    private final List<FSTFieldWriter> fields = new ArrayList<FSTFieldWriter>();
    private final FieldInfos fieldInfos;
    private final IndexTermSelector policy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VariableGapTermsIndexWriter(SegmentWriteState state, IndexTermSelector policy) throws IOException {
        String indexFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, TERMS_INDEX_EXTENSION);
        this.out = state.directory.createOutput(indexFileName, state.context);
        boolean success = false;
        try {
            this.fieldInfos = state.fieldInfos;
            this.policy = policy;
            CodecUtil.writeIndexHeader(this.out, CODEC_NAME, 3, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.out);
            throw throwable;
        }
    }

    @Override
    public TermsIndexWriterBase.FieldWriter addField(FieldInfo field, long termsFilePointer) throws IOException {
        this.policy.newField(field);
        FSTFieldWriter writer = new FSTFieldWriter(field, termsFilePointer);
        this.fields.add(writer);
        return writer;
    }

    protected int indexedTermPrefixLength(BytesRef priorTerm, BytesRef indexedTerm) {
        int idxTermOffset = indexedTerm.offset;
        int priorTermOffset = priorTerm.offset;
        int limit = Math.min(priorTerm.length, indexedTerm.length);
        for (int byteIdx = 0; byteIdx < limit; ++byteIdx) {
            if (priorTerm.bytes[priorTermOffset + byteIdx] == indexedTerm.bytes[idxTermOffset + byteIdx]) continue;
            return byteIdx + 1;
        }
        return Math.min(1 + priorTerm.length, indexedTerm.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.out != null) {
            try {
                FSTFieldWriter field;
                int i;
                long dirStart = this.out.getFilePointer();
                int fieldCount = this.fields.size();
                int nonNullFieldCount = 0;
                for (i = 0; i < fieldCount; ++i) {
                    field = this.fields.get(i);
                    if (field.fst == null) continue;
                    ++nonNullFieldCount;
                }
                this.out.writeVInt(nonNullFieldCount);
                for (i = 0; i < fieldCount; ++i) {
                    field = this.fields.get(i);
                    if (field.fst == null) continue;
                    this.out.writeVInt(field.fieldInfo.number);
                    this.out.writeVLong(field.indexStart);
                }
                this.writeTrailer(dirStart);
                CodecUtil.writeFooter(this.out);
            }
            finally {
                this.out.close();
                this.out = null;
            }
        }
    }

    private void writeTrailer(long dirStart) throws IOException {
        this.out.writeLong(dirStart);
    }

    private class FSTFieldWriter
    extends TermsIndexWriterBase.FieldWriter {
        private final Builder<Long> fstBuilder;
        private final PositiveIntOutputs fstOutputs;
        private final long startTermsFilePointer;
        final FieldInfo fieldInfo;
        FST<Long> fst;
        final long indexStart;
        private final BytesRefBuilder lastTerm = new BytesRefBuilder();
        private boolean first = true;
        private final IntsRefBuilder scratchIntsRef = new IntsRefBuilder();

        public FSTFieldWriter(FieldInfo fieldInfo, long termsFilePointer) throws IOException {
            this.fieldInfo = fieldInfo;
            this.fstOutputs = PositiveIntOutputs.getSingleton();
            this.fstBuilder = new Builder<Long>(FST.INPUT_TYPE.BYTE1, this.fstOutputs);
            this.indexStart = VariableGapTermsIndexWriter.this.out.getFilePointer();
            this.fstBuilder.add(new IntsRef(), termsFilePointer);
            this.startTermsFilePointer = termsFilePointer;
        }

        @Override
        public boolean checkIndexTerm(BytesRef text, TermStats stats) throws IOException {
            if (VariableGapTermsIndexWriter.this.policy.isIndexTerm(text, stats) || this.first) {
                this.first = false;
                return true;
            }
            this.lastTerm.copyBytes(text);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(BytesRef text, TermStats stats, long termsFilePointer) throws IOException {
            if (text.length == 0) {
                assert (termsFilePointer == this.startTermsFilePointer);
                return;
            }
            int lengthSave = text.length;
            text.length = VariableGapTermsIndexWriter.this.indexedTermPrefixLength(this.lastTerm.get(), text);
            try {
                this.fstBuilder.add(Util.toIntsRef(text, this.scratchIntsRef), termsFilePointer);
            }
            finally {
                text.length = lengthSave;
            }
            this.lastTerm.copyBytes(text);
        }

        @Override
        public void finish(long termsFilePointer) throws IOException {
            this.fst = this.fstBuilder.finish();
            if (this.fst != null) {
                this.fst.save(VariableGapTermsIndexWriter.this.out, VariableGapTermsIndexWriter.this.out);
            }
        }
    }

    public static final class EveryNOrDocFreqTermSelector
    extends IndexTermSelector {
        private int count;
        private final int docFreqThresh;
        private final int interval;

        public EveryNOrDocFreqTermSelector(int docFreqThresh, int interval) {
            this.interval = interval;
            this.docFreqThresh = docFreqThresh;
            this.count = interval;
        }

        @Override
        public boolean isIndexTerm(BytesRef term, TermStats stats) {
            if (stats.docFreq >= this.docFreqThresh || this.count >= this.interval) {
                this.count = 1;
                return true;
            }
            ++this.count;
            return false;
        }

        @Override
        public void newField(FieldInfo fieldInfo) {
            this.count = this.interval;
        }
    }

    public static final class EveryNTermSelector
    extends IndexTermSelector {
        private int count;
        private final int interval;

        public EveryNTermSelector(int interval) {
            this.interval = interval;
            this.count = interval;
        }

        @Override
        public boolean isIndexTerm(BytesRef term, TermStats stats) {
            if (this.count >= this.interval) {
                this.count = 1;
                return true;
            }
            ++this.count;
            return false;
        }

        @Override
        public void newField(FieldInfo fieldInfo) {
            this.count = this.interval;
        }
    }

    public static abstract class IndexTermSelector {
        public abstract boolean isIndexTerm(BytesRef var1, TermStats var2);

        public abstract void newField(FieldInfo var1);
    }
}

