/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.blocktreeords.FSTOrdsOutputs;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsReader;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsWriter;
import org.apache.lucene.codecs.blocktreeords.OrdsIntersectTermsEnum;
import org.apache.lucene.codecs.blocktreeords.OrdsSegmentTermsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.fst.FST;

final class OrdsFieldReader
extends Terms
implements Accountable {
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long indexStartFP;
    final long rootBlockFP;
    final FSTOrdsOutputs.Output rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final OrdsBlockTreeTermsReader parent;
    final FST<FSTOrdsOutputs.Output> index;

    OrdsFieldReader(OrdsBlockTreeTermsReader parent, FieldInfo fieldInfo, long numTerms, FSTOrdsOutputs.Output rootCode, long sumTotalTermFreq, long sumDocFreq, int docCount, long indexStartFP, IndexInput indexIn, BytesRef minTerm, BytesRef maxTerm) throws IOException {
        assert (numTerms > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = parent;
        this.numTerms = numTerms;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.sumDocFreq = sumDocFreq;
        this.docCount = docCount;
        this.indexStartFP = indexStartFP;
        this.rootCode = rootCode;
        this.minTerm = minTerm;
        this.maxTerm = maxTerm;
        this.rootBlockFP = new ByteArrayDataInput(rootCode.bytes.bytes, rootCode.bytes.offset, rootCode.bytes.length).readVLong() >>> 2;
        if (indexIn != null) {
            IndexInput clone = indexIn.clone();
            clone.seek(indexStartFP);
            this.index = new FST<FSTOrdsOutputs.Output>(clone, clone, OrdsBlockTreeTermsWriter.FST_OUTPUTS);
        } else {
            this.index = null;
        }
    }

    @Override
    public BytesRef getMin() throws IOException {
        if (this.minTerm == null) {
            return super.getMin();
        }
        return this.minTerm;
    }

    @Override
    public BytesRef getMax() throws IOException {
        if (this.maxTerm == null) {
            return super.getMax();
        }
        return this.maxTerm;
    }

    @Override
    public boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    @Override
    public TermsEnum iterator() throws IOException {
        return new OrdsSegmentTermsEnum(this);
    }

    @Override
    public long size() {
        return this.numTerms;
    }

    @Override
    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    @Override
    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    @Override
    public int getDocCount() {
        return this.docCount;
    }

    @Override
    public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
        if (compiled.type != CompiledAutomaton.AUTOMATON_TYPE.NORMAL) {
            throw new IllegalArgumentException("please use CompiledAutomaton.getTermsEnum instead");
        }
        return new OrdsIntersectTermsEnum(this, compiled, startTerm);
    }

    @Override
    public long ramBytesUsed() {
        return this.index != null ? this.index.ramBytesUsed() : 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        if (this.index == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(Accountables.namedAccountable("term index", this.index));
    }

    public String toString() {
        return "OrdsBlockTreeTerms(terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

