/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextSkipReader;
import org.apache.lucene.codecs.simpletext.SimpleTextSkipWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BaseTermsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

class SimpleTextFieldsReader
extends FieldsProducer {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextFieldsReader.class) + RamUsageEstimator.shallowSizeOfInstance(TreeMap.class);
    private final TreeMap<String, Long> fields;
    private final IndexInput in;
    private final FieldInfos fieldInfos;
    private final int maxDoc;
    private static final long TERMS_BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextTerms.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + RamUsageEstimator.shallowSizeOfInstance(CharsRef.class);
    private final Map<String, SimpleTextTerms> termsCache = new HashMap<String, SimpleTextTerms>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTextFieldsReader(SegmentReadState state) throws IOException {
        this.maxDoc = state.segmentInfo.maxDoc();
        this.fieldInfos = state.fieldInfos;
        this.in = state.directory.openInput(SimpleTextPostingsFormat.getPostingsFileName(state.segmentInfo.name, state.segmentSuffix), state.context);
        boolean success = false;
        try {
            this.fields = this.readFields(this.in.clone());
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(new Closeable[]{this});
            throw throwable;
        }
    }

    private TreeMap<String, Long> readFields(IndexInput in) throws IOException {
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(in);
        BytesRefBuilder scratch = new BytesRefBuilder();
        TreeMap<String, Long> fields = new TreeMap<String, Long>();
        while (true) {
            SimpleTextUtil.readLine(input, scratch);
            if (scratch.get().equals(SimpleTextFieldsWriter.END)) {
                SimpleTextUtil.checkFooter(input);
                return fields;
            }
            if (!StringHelper.startsWith(scratch.get(), SimpleTextFieldsWriter.FIELD)) continue;
            String fieldName = new String(scratch.bytes(), SimpleTextFieldsWriter.FIELD.length, scratch.length() - SimpleTextFieldsWriter.FIELD.length, StandardCharsets.UTF_8);
            fields.put(fieldName, ((IndexInput)input).getFilePointer());
        }
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    @Override
    public synchronized Terms terms(String field) throws IOException {
        SimpleTextTerms terms = this.termsCache.get(field);
        if (terms == null) {
            Long fp = this.fields.get(field);
            if (fp == null) {
                return null;
            }
            terms = new SimpleTextTerms(field, fp, this.maxDoc);
            this.termsCache.put(field, terms);
        }
        return terms;
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public synchronized long ramBytesUsed() {
        long sizeInBytes = BASE_RAM_BYTES_USED + (long)(this.fields.size() * 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        for (SimpleTextTerms simpleTextTerms : this.termsCache.values()) {
            sizeInBytes += simpleTextTerms != null ? simpleTextTerms.ramBytesUsed() : 0L;
        }
        return sizeInBytes;
    }

    @Override
    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("field", this.termsCache);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
    }

    @Override
    public void checkIntegrity() throws IOException {
    }

    private class SimpleTextTerms
    extends Terms
    implements Accountable {
        private final long termsStart;
        private final FieldInfo fieldInfo;
        private final int maxDoc;
        private long sumTotalTermFreq;
        private long sumDocFreq;
        private int docCount;
        private FST<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>> fst;
        private int termCount;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final CharsRefBuilder scratchUTF16 = new CharsRefBuilder();

        public SimpleTextTerms(String field, long termsStart, int maxDoc) throws IOException {
            this.maxDoc = maxDoc;
            this.termsStart = termsStart;
            this.fieldInfo = SimpleTextFieldsReader.this.fieldInfos.fieldInfo(field);
            this.loadTerms();
        }

        private void loadTerms() throws IOException {
            PositiveIntOutputs posIntOutputs = PositiveIntOutputs.getSingleton();
            PairOutputs<Long, Long> outputsOuter = new PairOutputs<Long, Long>(posIntOutputs, posIntOutputs);
            PairOutputs<Long, Long> outputsInner = new PairOutputs<Long, Long>(posIntOutputs, posIntOutputs);
            PairOutputs<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>> outputs = new PairOutputs<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>(outputsOuter, outputsInner);
            Builder<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>> fstCompiler = new Builder<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>>(FST.INPUT_TYPE.BYTE1, outputs);
            IndexInput in = SimpleTextFieldsReader.this.in.clone();
            in.seek(this.termsStart);
            BytesRefBuilder lastTerm = new BytesRefBuilder();
            long lastDocsStart = -1L;
            int docFreq = 0;
            long totalTermFreq = 0L;
            long skipPointer = 0L;
            FixedBitSet visitedDocs = new FixedBitSet(this.maxDoc);
            IntsRefBuilder scratchIntsRef = new IntsRefBuilder();
            while (true) {
                SimpleTextUtil.readLine(in, this.scratch);
                if (this.scratch.get().equals(SimpleTextFieldsWriter.END) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.FIELD)) {
                    if (lastDocsStart == -1L) break;
                    fstCompiler.add(Util.toIntsRef(lastTerm.get(), scratchIntsRef), outputs.newPair(outputsOuter.newPair(lastDocsStart, skipPointer), outputsInner.newPair(Long.valueOf(docFreq), totalTermFreq)));
                    this.sumTotalTermFreq += totalTermFreq;
                    break;
                }
                if (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.DOC)) {
                    ++docFreq;
                    ++this.sumDocFreq;
                    ++totalTermFreq;
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.DOC.length, this.scratch.length() - SimpleTextFieldsWriter.DOC.length);
                    int docID = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                    visitedDocs.set(docID);
                    continue;
                }
                if (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.FREQ)) {
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.FREQ.length, this.scratch.length() - SimpleTextFieldsWriter.FREQ.length);
                    totalTermFreq += (long)(ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length()) - 1);
                    continue;
                }
                if (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.SKIP_LIST)) {
                    skipPointer = in.getFilePointer();
                    continue;
                }
                if (!StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.TERM)) continue;
                if (lastDocsStart != -1L) {
                    fstCompiler.add(Util.toIntsRef(lastTerm.get(), scratchIntsRef), outputs.newPair(outputsOuter.newPair(lastDocsStart, skipPointer), outputsInner.newPair(Long.valueOf(docFreq), totalTermFreq)));
                }
                lastDocsStart = in.getFilePointer();
                int len = this.scratch.length() - SimpleTextFieldsWriter.TERM.length;
                lastTerm.grow(len);
                System.arraycopy(this.scratch.bytes(), SimpleTextFieldsWriter.TERM.length, lastTerm.bytes(), 0, len);
                lastTerm.setLength(len);
                docFreq = 0;
                this.sumTotalTermFreq += totalTermFreq;
                totalTermFreq = 0L;
                ++this.termCount;
                skipPointer = 0L;
            }
            this.docCount = visitedDocs.cardinality();
            this.fst = fstCompiler.finish();
        }

        @Override
        public long ramBytesUsed() {
            return TERMS_BASE_RAM_BYTES_USED + (this.fst != null ? this.fst.ramBytesUsed() : 0L) + RamUsageEstimator.sizeOf(this.scratch.bytes()) + RamUsageEstimator.sizeOf(this.scratchUTF16.chars());
        }

        @Override
        public Collection<Accountable> getChildResources() {
            if (this.fst == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Accountables.namedAccountable("term cache", this.fst));
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(terms=" + this.termCount + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
        }

        @Override
        public TermsEnum iterator() throws IOException {
            if (this.fst != null) {
                return new SimpleTextTermsEnum(this.fst, this.fieldInfo.getIndexOptions());
            }
            return TermsEnum.EMPTY;
        }

        @Override
        public long size() {
            return this.termCount;
        }

        @Override
        public long getSumTotalTermFreq() {
            return this.sumTotalTermFreq;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        @Override
        public int getDocCount() throws IOException {
            return this.docCount;
        }

        @Override
        public boolean hasFreqs() {
            return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        }

        @Override
        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        @Override
        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        @Override
        public boolean hasPayloads() {
            return this.fieldInfo.hasPayloads();
        }
    }

    private class SimpleTextPostingsEnum
    extends ImpactsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private int docID = -1;
        private int tf;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final BytesRefBuilder scratch2 = new BytesRefBuilder();
        private final CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
        private final CharsRefBuilder scratchUTF16_2 = new CharsRefBuilder();
        private int pos;
        private BytesRef payload;
        private long nextDocStart;
        private boolean readOffsets;
        private boolean readPositions;
        private int startOffset;
        private int endOffset;
        private int cost;
        private SimpleTextSkipReader skipReader;
        private int nextSkipDoc = 0;
        private long seekTo = -1L;

        public SimpleTextPostingsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = this.inStart.clone();
            this.skipReader = new SimpleTextSkipReader(this.inStart.clone());
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextPostingsEnum reset(long fp, IndexOptions indexOptions, int docFreq, long skipPointer) throws IOException {
            this.nextDocStart = fp;
            this.docID = -1;
            this.readPositions = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            boolean bl = this.readOffsets = indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            if (!this.readOffsets) {
                this.startOffset = -1;
                this.endOffset = -1;
            }
            this.cost = docFreq;
            this.skipReader.reset(skipPointer, docFreq);
            this.nextSkipDoc = 0;
            this.seekTo = -1L;
            return this;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() throws IOException {
            return this.tf;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID + 1);
        }

        private int readDoc() throws IOException {
            long lineStart;
            boolean first = true;
            this.in.seek(this.nextDocStart);
            long posStart = 0L;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine(this.in, this.scratch);
                if (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.DOC)) {
                    if (!first) {
                        this.nextDocStart = lineStart;
                        this.in.seek(posStart);
                        return this.docID;
                    }
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.DOC.length, this.scratch.length() - SimpleTextFieldsWriter.DOC.length);
                    this.docID = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                    this.tf = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.FREQ)) {
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.FREQ.length, this.scratch.length() - SimpleTextFieldsWriter.FREQ.length);
                    this.tf = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                    posStart = this.in.getFilePointer();
                    continue;
                }
                if (!(StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.POS) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.START_OFFSET) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.END_OFFSET) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.PAYLOAD))) break;
            }
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.SKIP_LIST) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.TERM) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.FIELD) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.END));
            if (!first) {
                this.nextDocStart = lineStart;
                this.in.seek(posStart);
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        private int advanceTarget(int target) throws IOException {
            int doc;
            if (this.seekTo > 0L) {
                this.nextDocStart = this.seekTo;
                this.seekTo = -1L;
            }
            assert (this.docID() < target);
            while ((doc = this.readDoc()) < target) {
            }
            return doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.advanceShallow(target);
            return this.advanceTarget(target);
        }

        @Override
        public int nextPosition() throws IOException {
            if (this.readPositions) {
                SimpleTextUtil.readLine(this.in, this.scratch);
                assert (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.POS)) : "got line=" + this.scratch.get().utf8ToString();
                this.scratchUTF16_2.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.POS.length, this.scratch.length() - SimpleTextFieldsWriter.POS.length);
                this.pos = ArrayUtil.parseInt(this.scratchUTF16_2.chars(), 0, this.scratchUTF16_2.length());
            } else {
                this.pos = -1;
            }
            if (this.readOffsets) {
                SimpleTextUtil.readLine(this.in, this.scratch);
                assert (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.START_OFFSET)) : "got line=" + this.scratch.get().utf8ToString();
                this.scratchUTF16_2.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.START_OFFSET.length, this.scratch.length() - SimpleTextFieldsWriter.START_OFFSET.length);
                this.startOffset = ArrayUtil.parseInt(this.scratchUTF16_2.chars(), 0, this.scratchUTF16_2.length());
                SimpleTextUtil.readLine(this.in, this.scratch);
                assert (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.END_OFFSET)) : "got line=" + this.scratch.get().utf8ToString();
                this.scratchUTF16_2.grow(this.scratch.length() - SimpleTextFieldsWriter.END_OFFSET.length);
                this.scratchUTF16_2.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.END_OFFSET.length, this.scratch.length() - SimpleTextFieldsWriter.END_OFFSET.length);
                this.endOffset = ArrayUtil.parseInt(this.scratchUTF16_2.chars(), 0, this.scratchUTF16_2.length());
            }
            long fp = this.in.getFilePointer();
            SimpleTextUtil.readLine(this.in, this.scratch);
            if (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.PAYLOAD)) {
                int len = this.scratch.length() - SimpleTextFieldsWriter.PAYLOAD.length;
                this.scratch2.grow(len);
                System.arraycopy(this.scratch.bytes(), SimpleTextFieldsWriter.PAYLOAD.length, this.scratch2.bytes(), 0, len);
                this.scratch2.setLength(len);
                this.payload = this.scratch2.get();
            } else {
                this.payload = null;
                this.in.seek(fp);
            }
            return this.pos;
        }

        @Override
        public int startOffset() throws IOException {
            return this.startOffset;
        }

        @Override
        public int endOffset() throws IOException {
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            return this.payload;
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.nextSkipDoc) {
                this.skipReader.skipTo(target);
                if (this.skipReader.getNextSkipDoc() != Integer.MAX_VALUE) {
                    this.seekTo = this.skipReader.getNextSkipDocFP();
                }
            }
            this.nextSkipDoc = this.skipReader.getNextSkipDoc();
            assert (this.nextSkipDoc >= target);
        }

        @Override
        public Impacts getImpacts() throws IOException {
            this.advanceShallow(this.docID);
            return this.skipReader.getImpacts();
        }
    }

    private class SimpleTextDocsEnum
    extends ImpactsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private boolean omitTF;
        private int docID = -1;
        private int tf;
        private final BytesRefBuilder scratch = new BytesRefBuilder();
        private final CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
        private int cost;
        private SimpleTextSkipReader skipReader;
        private int nextSkipDoc = 0;
        private long seekTo = -1L;

        public SimpleTextDocsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = this.inStart.clone();
            this.skipReader = new SimpleTextSkipReader(this.inStart.clone());
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextDocsEnum reset(long fp, boolean omitTF, int docFreq, long skipPointer) throws IOException {
            this.in.seek(fp);
            this.omitTF = omitTF;
            this.docID = -1;
            this.tf = 1;
            this.cost = docFreq;
            this.skipReader.reset(skipPointer, docFreq);
            this.nextSkipDoc = 0;
            this.seekTo = -1L;
            return this;
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int freq() throws IOException {
            return this.tf;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.docID + 1);
        }

        private int readDoc() throws IOException {
            long lineStart;
            if (this.docID == Integer.MAX_VALUE) {
                return this.docID;
            }
            boolean first = true;
            int termFreq = 0;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine(this.in, this.scratch);
                if (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.DOC)) {
                    if (!first) {
                        this.in.seek(lineStart);
                        if (!this.omitTF) {
                            this.tf = termFreq;
                        }
                        return this.docID;
                    }
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.DOC.length, this.scratch.length() - SimpleTextFieldsWriter.DOC.length);
                    this.docID = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                    termFreq = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.FREQ)) {
                    this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextFieldsWriter.FREQ.length, this.scratch.length() - SimpleTextFieldsWriter.FREQ.length);
                    termFreq = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                    continue;
                }
                if (!(StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.POS) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.START_OFFSET) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.END_OFFSET) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.PAYLOAD))) break;
            }
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.SKIP_LIST) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.TERM) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.FIELD) || StringHelper.startsWith(this.scratch.get(), SimpleTextFieldsWriter.END)) : "scratch=" + this.scratch.get().utf8ToString();
            if (!first) {
                this.in.seek(lineStart);
                if (!this.omitTF) {
                    this.tf = termFreq;
                }
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        private int advanceTarget(int target) throws IOException {
            int doc;
            if (this.seekTo > 0L) {
                this.in.seek(this.seekTo);
                this.seekTo = -1L;
            }
            assert (this.docID() < target);
            while ((doc = this.readDoc()) < target) {
            }
            return doc;
        }

        @Override
        public int advance(int target) throws IOException {
            this.advanceShallow(target);
            return this.advanceTarget(target);
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.nextSkipDoc) {
                this.skipReader.skipTo(target);
                if (this.skipReader.getNextSkipDoc() != Integer.MAX_VALUE) {
                    this.seekTo = this.skipReader.getNextSkipDocFP();
                }
                this.nextSkipDoc = this.skipReader.getNextSkipDoc();
            }
            assert (this.nextSkipDoc >= target);
        }

        @Override
        public Impacts getImpacts() throws IOException {
            this.advanceShallow(this.docID);
            return this.skipReader.getImpacts();
        }
    }

    private class SimpleTextTermsEnum
    extends BaseTermsEnum {
        private final IndexOptions indexOptions;
        private int docFreq;
        private long totalTermFreq;
        private long docsStart;
        private long skipPointer;
        private boolean ended;
        private final BytesRefFSTEnum<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>> fstEnum;

        public SimpleTextTermsEnum(FST<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>> fst, IndexOptions indexOptions) {
            this.indexOptions = indexOptions;
            this.fstEnum = new BytesRefFSTEnum<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>>(fst);
        }

        @Override
        public boolean seekExact(BytesRef text) throws IOException {
            BytesRefFSTEnum.InputOutput<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>> result = this.fstEnum.seekExact(text);
            if (result != null) {
                PairOutputs.Pair pair = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair1 = (PairOutputs.Pair)pair.output1;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair.output2;
                this.docsStart = (Long)pair1.output1;
                this.skipPointer = (Long)pair1.output2;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return true;
            }
            return false;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            BytesRefFSTEnum.InputOutput<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>> result = this.fstEnum.seekCeil(text);
            if (result == null) {
                return TermsEnum.SeekStatus.END;
            }
            PairOutputs.Pair pair = (PairOutputs.Pair)result.output;
            PairOutputs.Pair pair1 = (PairOutputs.Pair)pair.output1;
            PairOutputs.Pair pair2 = (PairOutputs.Pair)pair.output2;
            this.docsStart = (Long)pair1.output1;
            this.skipPointer = (Long)pair1.output2;
            this.docFreq = ((Long)pair2.output1).intValue();
            this.totalTermFreq = (Long)pair2.output2;
            if (result.input.equals(text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public BytesRef next() throws IOException {
            assert (!this.ended);
            BytesRefFSTEnum.InputOutput<PairOutputs.Pair<PairOutputs.Pair<Long, Long>, PairOutputs.Pair<Long, Long>>> result = this.fstEnum.next();
            if (result != null) {
                PairOutputs.Pair pair = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair1 = (PairOutputs.Pair)pair.output1;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair.output2;
                this.docsStart = (Long)pair1.output1;
                this.skipPointer = (Long)pair1.output2;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return result.input;
            }
            return null;
        }

        @Override
        public BytesRef term() {
            return this.fstEnum.current().input;
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() {
            return this.docFreq;
        }

        @Override
        public long totalTermFreq() {
            return this.indexOptions == IndexOptions.DOCS ? (long)this.docFreq : this.totalTermFreq;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            boolean hasPositions;
            boolean bl = hasPositions = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            if (hasPositions && PostingsEnum.featureRequested(flags, (short)24)) {
                SimpleTextPostingsEnum docsAndPositionsEnum = reuse != null && reuse instanceof SimpleTextPostingsEnum && ((SimpleTextPostingsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextPostingsEnum)reuse : new SimpleTextPostingsEnum();
                return docsAndPositionsEnum.reset(this.docsStart, this.indexOptions, this.docFreq, this.skipPointer);
            }
            SimpleTextDocsEnum docsEnum = reuse != null && reuse instanceof SimpleTextDocsEnum && ((SimpleTextDocsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextDocsEnum)reuse : new SimpleTextDocsEnum();
            return docsEnum.reset(this.docsStart, this.indexOptions == IndexOptions.DOCS, this.docFreq, this.skipPointer);
        }

        @Override
        public ImpactsEnum impacts(int flags) throws IOException {
            if (this.docFreq <= 8) {
                return new SlowImpactsEnum(this.postings(null, flags));
            }
            return (ImpactsEnum)this.postings(null, flags);
        }
    }
}

