/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SortFieldProvider;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class SimpleTextSegmentInfoFormat
extends SegmentInfoFormat {
    static final BytesRef SI_VERSION = new BytesRef("    version ");
    static final BytesRef SI_MIN_VERSION = new BytesRef("    min version ");
    static final BytesRef SI_DOCCOUNT = new BytesRef("    number of documents ");
    static final BytesRef SI_USECOMPOUND = new BytesRef("    uses compound file ");
    static final BytesRef SI_NUM_DIAG = new BytesRef("    diagnostics ");
    static final BytesRef SI_DIAG_KEY = new BytesRef("      key ");
    static final BytesRef SI_DIAG_VALUE = new BytesRef("      value ");
    static final BytesRef SI_NUM_ATT = new BytesRef("    attributes ");
    static final BytesRef SI_ATT_KEY = new BytesRef("      key ");
    static final BytesRef SI_ATT_VALUE = new BytesRef("      value ");
    static final BytesRef SI_NUM_FILES = new BytesRef("    files ");
    static final BytesRef SI_FILE = new BytesRef("      file ");
    static final BytesRef SI_ID = new BytesRef("    id ");
    static final BytesRef SI_SORT = new BytesRef("    sort ");
    static final BytesRef SI_SORT_TYPE = new BytesRef("      type ");
    static final BytesRef SI_SORT_NAME = new BytesRef("      name ");
    static final BytesRef SI_SORT_BYTES = new BytesRef("      bytes ");
    public static final String SI_EXTENSION = "si";

    @Override
    public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        String segFileName = IndexFileNames.segmentFileName(segmentName, "", SI_EXTENSION);
        try (ChecksumIndexInput input = directory.openChecksumInput(segFileName, context);){
            Version minVersion;
            Version version;
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_VERSION));
            try {
                version = Version.parse(this.readString(SimpleTextSegmentInfoFormat.SI_VERSION.length, scratch));
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), input, (Throwable)pe);
            }
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_MIN_VERSION));
            try {
                String versionString = this.readString(SimpleTextSegmentInfoFormat.SI_MIN_VERSION.length, scratch);
                minVersion = versionString.equals("null") ? null : Version.parse(versionString);
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), input, (Throwable)pe);
            }
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_DOCCOUNT));
            int docCount = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_DOCCOUNT.length, scratch));
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_USECOMPOUND));
            boolean isCompoundFile = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoFormat.SI_USECOMPOUND.length, scratch));
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_NUM_DIAG));
            int numDiag = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_DIAG.length, scratch));
            HashMap<String, String> diagnostics = new HashMap<String, String>();
            for (int i = 0; i < numDiag; ++i) {
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_DIAG_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_KEY.length, scratch);
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_DIAG_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_VALUE.length, scratch);
                diagnostics.put(key, value);
            }
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_NUM_ATT));
            int numAtt = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_ATT.length, scratch));
            HashMap<String, String> attributes = new HashMap<String, String>(numAtt);
            for (int i = 0; i < numAtt; ++i) {
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_ATT_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_KEY.length, scratch);
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_ATT_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_VALUE.length, scratch);
                attributes.put(key, value);
            }
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_NUM_FILES));
            int numFiles = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_FILES.length, scratch));
            HashSet<String> files = new HashSet<String>();
            for (int i = 0; i < numFiles; ++i) {
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_FILE));
                String fileName = this.readString(SimpleTextSegmentInfoFormat.SI_FILE.length, scratch);
                files.add(fileName);
            }
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_ID));
            byte[] id = ArrayUtil.copyOfSubArray(scratch.bytes(), SimpleTextSegmentInfoFormat.SI_ID.length, scratch.length());
            if (!Arrays.equals(segmentID, id)) {
                throw new CorruptIndexException("file mismatch, expected: " + StringHelper.idToString(segmentID) + ", got: " + StringHelper.idToString(id), input);
            }
            SimpleTextUtil.readLine(input, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_SORT));
            int numSortFields = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_SORT.length, scratch));
            SortField[] sortField = new SortField[numSortFields];
            for (int i = 0; i < numSortFields; ++i) {
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_SORT_NAME));
                String provider = this.readString(SimpleTextSegmentInfoFormat.SI_SORT_NAME.length, scratch);
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_SORT_TYPE));
                SimpleTextUtil.readLine(input, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_SORT_BYTES));
                BytesRef serializedSort = SimpleTextUtil.fromBytesRefString(this.readString(SimpleTextSegmentInfoFormat.SI_SORT_BYTES.length, scratch));
                ByteArrayDataInput bytes = new ByteArrayDataInput(serializedSort.bytes, serializedSort.offset, serializedSort.length);
                sortField[i] = SortFieldProvider.forName(provider).readSortField(bytes);
                assert (bytes.eof());
            }
            Sort indexSort = sortField.length == 0 ? null : new Sort(sortField);
            SimpleTextUtil.checkFooter(input);
            SegmentInfo info = new SegmentInfo(directory, version, minVersion, segmentName, docCount, isCompoundFile, null, diagnostics, id, attributes, indexSort);
            info.setFiles(files);
            SegmentInfo segmentInfo = info;
            return segmentInfo;
        }
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String segFileName = IndexFileNames.segmentFileName(si.name, "", SI_EXTENSION);
        try (IndexOutput output = dir.createOutput(segFileName, ioContext);){
            si.addFile(segFileName);
            BytesRefBuilder scratch = new BytesRefBuilder();
            SimpleTextUtil.write(output, SI_VERSION);
            SimpleTextUtil.write(output, si.getVersion().toString(), scratch);
            SimpleTextUtil.writeNewline(output);
            SimpleTextUtil.write(output, SI_MIN_VERSION);
            if (si.getMinVersion() == null) {
                SimpleTextUtil.write(output, "null", scratch);
            } else {
                SimpleTextUtil.write(output, si.getMinVersion().toString(), scratch);
            }
            SimpleTextUtil.writeNewline(output);
            SimpleTextUtil.write(output, SI_DOCCOUNT);
            SimpleTextUtil.write(output, Integer.toString(si.maxDoc()), scratch);
            SimpleTextUtil.writeNewline(output);
            SimpleTextUtil.write(output, SI_USECOMPOUND);
            SimpleTextUtil.write(output, Boolean.toString(si.getUseCompoundFile()), scratch);
            SimpleTextUtil.writeNewline(output);
            Map<String, String> diagnostics = si.getDiagnostics();
            int numDiagnostics = diagnostics == null ? 0 : diagnostics.size();
            SimpleTextUtil.write(output, SI_NUM_DIAG);
            SimpleTextUtil.write(output, Integer.toString(numDiagnostics), scratch);
            SimpleTextUtil.writeNewline(output);
            if (numDiagnostics > 0) {
                for (Map.Entry<String, String> entry : diagnostics.entrySet()) {
                    SimpleTextUtil.write(output, SI_DIAG_KEY);
                    SimpleTextUtil.write(output, entry.getKey(), scratch);
                    SimpleTextUtil.writeNewline(output);
                    SimpleTextUtil.write(output, SI_DIAG_VALUE);
                    SimpleTextUtil.write(output, entry.getValue(), scratch);
                    SimpleTextUtil.writeNewline(output);
                }
            }
            Map<String, String> attributes = si.getAttributes();
            SimpleTextUtil.write(output, SI_NUM_ATT);
            SimpleTextUtil.write(output, Integer.toString(attributes.size()), scratch);
            SimpleTextUtil.writeNewline(output);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                SimpleTextUtil.write(output, SI_ATT_KEY);
                SimpleTextUtil.write(output, entry.getKey(), scratch);
                SimpleTextUtil.writeNewline(output);
                SimpleTextUtil.write(output, SI_ATT_VALUE);
                SimpleTextUtil.write(output, entry.getValue(), scratch);
                SimpleTextUtil.writeNewline(output);
            }
            Set<String> set = si.files();
            int n = set == null ? 0 : set.size();
            SimpleTextUtil.write(output, SI_NUM_FILES);
            SimpleTextUtil.write(output, Integer.toString(n), scratch);
            SimpleTextUtil.writeNewline(output);
            if (n > 0) {
                for (String fileName : set) {
                    SimpleTextUtil.write(output, SI_FILE);
                    SimpleTextUtil.write(output, fileName, scratch);
                    SimpleTextUtil.writeNewline(output);
                }
            }
            SimpleTextUtil.write(output, SI_ID);
            SimpleTextUtil.write(output, new BytesRef(si.getId()));
            SimpleTextUtil.writeNewline(output);
            Sort indexSort = si.getIndexSort();
            SimpleTextUtil.write(output, SI_SORT);
            int numSortFields = indexSort == null ? 0 : indexSort.getSort().length;
            SimpleTextUtil.write(output, Integer.toString(numSortFields), scratch);
            SimpleTextUtil.writeNewline(output);
            for (int i = 0; i < numSortFields; ++i) {
                SortField sortField = indexSort.getSort()[i];
                IndexSorter sorter = sortField.getIndexSorter();
                if (sorter == null) {
                    throw new IllegalStateException("Cannot serialize sort " + sortField);
                }
                SimpleTextUtil.write(output, SI_SORT_NAME);
                SimpleTextUtil.write(output, sorter.getProviderName(), scratch);
                SimpleTextUtil.writeNewline(output);
                SimpleTextUtil.write(output, SI_SORT_TYPE);
                SimpleTextUtil.write(output, sortField.toString(), scratch);
                SimpleTextUtil.writeNewline(output);
                SimpleTextUtil.write(output, SI_SORT_BYTES);
                BytesRefOutput b = new BytesRefOutput();
                SortFieldProvider.write(sortField, b);
                SimpleTextUtil.write(output, b.bytes.get().toString(), scratch);
                SimpleTextUtil.writeNewline(output);
            }
            SimpleTextUtil.writeChecksum(output, scratch);
        }
    }

    static class BytesRefOutput
    extends DataOutput {
        final BytesRefBuilder bytes = new BytesRefBuilder();

        BytesRefOutput() {
        }

        @Override
        public void writeByte(byte b) {
            this.bytes.append(b);
        }

        @Override
        public void writeBytes(byte[] b, int offset, int length) {
            this.bytes.append(b, offset, length);
        }
    }
}

