/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.codecs.MultiLevelSkipListReader;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextSkipWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.Impact;
import org.apache.lucene.index.Impacts;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.StringHelper;

class SimpleTextSkipReader
extends MultiLevelSkipListReader {
    private final CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
    private final BytesRefBuilder scratch = new BytesRefBuilder();
    private Impacts impacts = new Impacts(){

        @Override
        public int numLevels() {
            return SimpleTextSkipReader.this.numLevels;
        }

        @Override
        public int getDocIdUpTo(int level) {
            return SimpleTextSkipReader.this.skipDoc[level];
        }

        @Override
        public List<Impact> getImpacts(int level) {
            assert (level < SimpleTextSkipReader.this.numLevels);
            return (List)SimpleTextSkipReader.this.perLevelImpacts.get(level);
        }
    };
    private List<List<Impact>> perLevelImpacts;
    private long nextSkipDocFP = -1L;
    private int numLevels = 1;
    private boolean hasSkipList = false;

    SimpleTextSkipReader(IndexInput skipStream) {
        super(skipStream, 4, 8, 3);
        this.init();
    }

    @Override
    public int skipTo(int target) throws IOException {
        if (!this.hasSkipList) {
            return -1;
        }
        int result = super.skipTo(target);
        if (this.numberOfSkipLevels > 0) {
            this.numLevels = this.numberOfSkipLevels;
        } else {
            this.numLevels = 1;
            this.perLevelImpacts.add(0, Collections.singletonList(new Impact(Integer.MAX_VALUE, 1L)));
        }
        return result;
    }

    @Override
    protected int readSkipData(int level, IndexInput skipStream) throws IOException {
        this.perLevelImpacts.get(level).clear();
        int skipDoc = Integer.MAX_VALUE;
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(skipStream);
        int freq = 1;
        while (true) {
            SimpleTextUtil.readLine(input, this.scratch);
            if (this.scratch.get().equals(SimpleTextFieldsWriter.END)) {
                SimpleTextUtil.checkFooter(input);
                break;
            }
            if (this.scratch.get().equals(SimpleTextSkipWriter.IMPACTS_END) || this.scratch.get().equals(SimpleTextFieldsWriter.TERM) || this.scratch.get().equals(SimpleTextFieldsWriter.FIELD)) break;
            if (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.SKIP_LIST)) continue;
            if (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.SKIP_DOC)) {
                this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextSkipWriter.SKIP_DOC.length, this.scratch.length() - SimpleTextSkipWriter.SKIP_DOC.length);
                skipDoc = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                skipDoc -= this.skipDoc[level];
                continue;
            }
            if (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.SKIP_DOC_FP)) {
                this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextSkipWriter.SKIP_DOC_FP.length, this.scratch.length() - SimpleTextSkipWriter.SKIP_DOC_FP.length);
                this.nextSkipDocFP = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                continue;
            }
            if (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.IMPACTS) || StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.IMPACT)) continue;
            if (StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.FREQ)) {
                this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextSkipWriter.FREQ.length, this.scratch.length() - SimpleTextSkipWriter.FREQ.length);
                freq = ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
                continue;
            }
            if (!StringHelper.startsWith(this.scratch.get(), SimpleTextSkipWriter.NORM)) continue;
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextSkipWriter.NORM.length, this.scratch.length() - SimpleTextSkipWriter.NORM.length);
            long norm = Long.parseLong(this.scratchUTF16.toString());
            Impact impact = new Impact(freq, norm);
            this.perLevelImpacts.get(level).add(impact);
        }
        return skipDoc;
    }

    @Override
    protected long readLevelLength(IndexInput skipStream) throws IOException {
        SimpleTextUtil.readLine(skipStream, this.scratch);
        this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextSkipWriter.LEVEL_LENGTH.length, this.scratch.length() - SimpleTextSkipWriter.LEVEL_LENGTH.length);
        return Long.parseLong(this.scratchUTF16.toString());
    }

    @Override
    protected long readChildPointer(IndexInput skipStream) throws IOException {
        SimpleTextUtil.readLine(skipStream, this.scratch);
        this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextSkipWriter.CHILD_POINTER.length, this.scratch.length() - SimpleTextSkipWriter.CHILD_POINTER.length);
        return Long.parseLong(this.scratchUTF16.toString());
    }

    void reset(long skipPointer, int docFreq) throws IOException {
        this.init();
        if (skipPointer > 0L) {
            super.init(skipPointer, docFreq);
            this.hasSkipList = true;
        }
    }

    private void init() {
        this.nextSkipDocFP = -1L;
        this.numLevels = 1;
        this.perLevelImpacts = new ArrayList<List<Impact>>(this.maxNumberOfSkipLevels);
        for (int level = 0; level < this.maxNumberOfSkipLevels; ++level) {
            ArrayList<Impact> impacts = new ArrayList<Impact>();
            impacts.add(new Impact(Integer.MAX_VALUE, 1L));
            this.perLevelImpacts.add(level, impacts);
        }
        this.hasSkipList = false;
    }

    Impacts getImpacts() {
        return this.impacts;
    }

    long getNextSkipDocFP() {
        return this.nextSkipDocFP;
    }

    int getNextSkipDoc() {
        if (!this.hasSkipList) {
            return Integer.MAX_VALUE;
        }
        return this.skipDoc[0];
    }

    boolean hasSkipList() {
        return this.hasSkipList;
    }
}

